/**
Javascript query string parsing.
Author: djohnson@ibsys.com {{djohnson}} - you may use this file as you wish but please keep this header with it thanks

Refactored for TWiki by Arthur Clemens 2006

@use 
Pass location.search to the constructor:
<pre>
var myPageQuery = new twiki.String.PageQuery(location.search)
</pre>
Retrieve values:
<pre>
var myValue = myPageQuery.getValue("param1");
</pre>
Shorthand:
<pre>
var myValue = new twiki.String.PageQuery(location.search).getValue("param1");
</pre>
*/

var twiki;
if (twiki == undefined) twiki = {};
var twiki.String;
if (twiki.String == undefined) twiki.String = {};

twiki.String.PageQuery = function (q) {
	if (q.length > 1) {
		this.q = q.substring(1, q.length);
	} else {
		this.q = null;
	}
	this.keyValuePairs = new Array();
	if (q) {
		for(var i=0; i < this.q.split(/[&;]/).length; i++) {
			this.keyValuePairs[i] = this.q.split(/[&;]/)[i];
		}
	}
}

/**

*/
twiki.String.PageQuery.prototype.getKeyValuePairs = function() {
	return this.keyValuePairs;
}

/**
@return The query string value; if not found returns -1.
*/
twiki.String.PageQuery.prototype.getValue = function (s) {
	for(var j=0; j < this.keyValuePairs.length; j++) {
		if(this.keyValuePairs[j].split(/=/)[0] == s)
			return this.keyValuePairs[j].split(/=/)[1];
	}
	return -1;
}

/**

*/
twiki.String.PageQuery.prototype.getParameters = function () {
	var a = new Array(this.getLength());
	for(var j=0; j < this.keyValuePairs.length; j++) {
		a[j] = this.keyValuePairs[j].split(/=/)[0];
	}
	return a;
}

/**

*/
twiki.String.PageQuery.prototype.getLength = function() {
	return this.keyValuePairs.length;
}
