# ---+ Extensions
# ---++ Where-Is Plugin
# This is the configuration of the <b>WhereIsPlugin</b>.

# **STRING 50**
# Message where user was last seen.
# <br />- <tt>$wikiname</tt> resolves to the WikiName of the user
# <br />- <tt>$spacedname</tt> resolves to the spaced name of the user
# <br />- <tt>$location</tt> resolves to the location
# <br />- <tt>$ago</tt> resolves to the time span user was last seen
$TWiki::cfg{Plugins}{WhereIsPlugin}{LastSeenMsg} = '$spacedname last seen at $location $ago';

# **STRING 50**
# Message if user location is unknown. Same <tt>$wikiname</tt> and
# <tt>$spacedname</tt> as above.
$TWiki::cfg{Plugins}{WhereIsPlugin}{NotSeenMsg} = '$spacedname is unknown or has not been seen';

# **BOOLEAN**
# Debug plugin. See output in data/debug.txt
$TWiki::cfg{Plugins}{WhereIsPlugin}{Debug} = 0;

1;
