# Plugin for TWiki Enterprise Collaboration Platform, http://TWiki.org/
#
# Copyright (C) 2014-2015 Wave Systems Corp.
# Copyright (C) 2014-2015 Peter Thoeny, peter[at]thoeny.org 
# Copyright (C) 2014-2015 TWiki Contributors. All Rights Reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. For
# more details read LICENSE in the root of this distribution.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details, published at
# http://www.gnu.org/copyleft/gpl.html
#
# As per the GPL, removal of this notice is prohibited.

package TWiki::Plugins::WhereIsPlugin;

# =========================
our $VERSION = '$Rev: 28579 (2015-01-07) $';
our $RELEASE = '2015-01-07';
our $SHORTDESCRIPTION = 'Where is a person? Show where and when TWiki users were last seen';
our $NO_PREFS_IN_TOPIC = 1;

# =========================
our $debug = $TWiki::cfg{Plugins}{WhereIsPlugin}{Debug} || 0;
our $web;
our $topic;
our $core;

# =========================
sub initPlugin
{
    ( $topic, $web, $user, $installWeb ) = @_;

    # check for Plugins.pm versions
    if( $TWiki::Plugins::VERSION < 1.2 ) {
        TWiki::Func::writeWarning( "Version mismatch between WhereIsPlugin and Plugins.pm" );
        return 0;
    }

    TWiki::Func::registerTagHandler( 'WHEREIS', \&_WHEREIS );
    TWiki::Func::registerRESTHandler( 'set', \&_restSet );

    # Plugin correctly initialized
    TWiki::Func::writeDebug( "- TWiki::Plugins::WhereIsPlugin::initPlugin( $web.$topic ) is OK" ) if $debug;

    return 1;
}

# =========================
sub _WHEREIS
{
    my ( $session, $params ) = @_;

    # Lazy loading, e.g. compile core module only when required
    unless( $core ) {
        require TWiki::Plugins::WhereIsPlugin::Core;
        $core = new TWiki::Plugins::WhereIsPlugin::Core( $debug );
    }
    return $core->VarWHEREIS( $params );
}

# =========================
sub _restSet {
#   my ($session) = @_;
    my $query = TWiki::Func::getCgiQuery();
    return 'ERROR: No query object' unless( $query );
    my $action   = $query->param('whereisaction')   || '';
    my $address  = $query->param('whereisaddress')  || '';
    my $location = $query->param('whereislocation') || 'unknown location';
    if( $debug ) { 
        TWiki::Func::writeDebug( "- TWiki::Plugins::WhereIsPlugin::_restSet("
          . "action: $action, address: $address, location: $location)" );
    }
    return 'ERROR: Missing action parameter' unless $action;
    my $params = {
        action    => $action,
        address   => $address,
        location  => $location,
    };
    unless( $core ) {
        require TWiki::Plugins::WhereIsPlugin::Core;
        $core = new TWiki::Plugins::WhereIsPlugin::Core( $debug );
    }
    return $core->VarWHEREIS( $params );
}

# =========================
1;
