# Plugin for TWiki Collaboration Platform, http://TWiki.org/
#
# Copyright (C) 2000-2003 Andrea Sterbini, a.sterbini@flashnet.it
# Copyright (C) 2001-2003 Peter Thoeny, peter@thoeny.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details, published at 
# http://www.gnu.org/copyleft/gpl.html
#
# =========================
#
# This is an empty TWiki plugin. Use it as a template
# for your own plugins; see TWiki.TWikiPlugins for details.
#
# Each plugin is a package that may contain these functions:        VERSION:
#
#   initPlugin              ( $topic, $web, $user, $installWeb )    1.000
#   initializeUserHandler   ( $loginName, $url, $pathInfo )         1.010
#   registrationHandler     ( $web, $wikiName, $loginName )         1.010
#   commonTagsHandler       ( $text, $topic, $web )                 1.000
#   startRenderingHandler   ( $text, $web )                         1.000
#   outsidePREHandler       ( $text )                               1.000
#   insidePREHandler        ( $text )                               1.000
#   endRenderingHandler     ( $text )                               1.000
#   beforeEditHandler       ( $text, $topic, $web )                 1.010
#   afterEditHandler        ( $text, $topic, $web )                 1.010
#   beforeSaveHandler       ( $text, $topic, $web )                 1.010
#   writeHeaderHandler      ( $query )                              1.010  Use only in one Plugin
#   redirectCgiQueryHandler ( $query, $url )                        1.010  Use only in one Plugin
#   getSessionValueHandler  ( $key )                                1.010  Use only in one Plugin
#   setSessionValueHandler  ( $key, $value )                        1.010  Use only in one Plugin
#
# initPlugin is required, all other are optional. 
# For increased performance, all handlers except initPlugin are
# disabled. To enable a handler remove the leading DISABLE_ from
# the function name. Remove disabled handlers you do not need.
#
# NOTE: To interact with TWiki use the official TWiki functions 
# in the TWiki::Func module. Do not reference any functions or
# variables elsewhere in TWiki!!


# =========================
package TWiki::Plugins::TestlinkQueryPlugin;    # change the package name and $pluginName!!!

use DBI;

# =========================
use vars qw( $web $topic $user $installWeb $VERSION $pluginName 
	     $debug $url $showTestlinkScript $TestlinkListScript $dbHost $dbPort $dbName $dbUser $dbPasswd );

$VERSION = '1.03';
$pluginName = "TestlinkQueryPlugin";  # Name of this Plugin

# HERE YOU HAVE TO SPECIFY THE MYSQL CREDENTIALS
# BECAUSE OF PLAIN TEXT FORMAT YOU SHOULD CREATE NEW USER WHO HAS ONLY READ-ONLY ACCESS TO DATABASE

# =========================
sub initPlugin
{
    ( $topic, $web, $user, $installWeb ) = @_;
 
  # check for Plugins.pm versions
    if( $TWiki::Plugins::VERSION < 1 ) {
	TWiki::Func::writeWarning( "Version mismatch between $pluginName and Plugins.pm" );
	  return 0;
      }

  # Get plugin debug flag
    $bug = TWiki::Func::getPreferencesFlag( "\U$pluginName\E_DEBUG" );
    $url = TWiki::Func::getPreferencesValue( "\U$pluginName\E_URL" );
    if ( $url eq "" ) {
	TWiki::Func::writeWarning( "You have to set up URL variable in TestlinkQueryPlugin topic" );
	  return 0;
      }
    if ( $url =~ /\/$/ ) { $url =~ s/(.*?)\/$/$1/; }
    $showTestlinkScript = TWiki::Func::getPreferencesValue( "\U$pluginName\E_SHOWTLREQSCRIPT" ) || "show_bug.cgi";
    $TestlinkListScript = TWiki::Func::getPreferencesValue( "\U$pluginName\E_TLREQLISTSCRIPT" ) || "buglist.cgi";
  
    $dbHost = TWiki::Func::getPreferencesValue( "\U$pluginName\E_TESTLINK_DB_HOST" ) || "";   # MySQL database host name
    $dbPort = TWiki::Func::getPreferencesValue( "\U$pluginName\E_TESTLINK_DB_PORT" ) || "";   # MySQL database port number 
    $dbName = TWiki::Func::getPreferencesValue( "\U$pluginName\E_TESTLINK_DB_NAME" ) || "bugs";   # MySQL database name

    $dbUser = TWiki::Func::getPreferencesValue( "\U$pluginName\E_TESTLINK_USER" ) || "guest";  # MySQL user who has access to $dbName database (read-only access is the best :-)))
    $dbPasswd = TWiki::Func::getPreferencesValue( "\U$pluginName\E_TESTLINK_PASSWD" ) || "";     # password for $dbUser
  # Plugin correctly initialized
    TWiki::Func::writeDebug( "- TWiki::Plugins::${pluginName}::initPlugin( $web.$topic ) is OK" ) if $debug;
    return 1;
}

# =========================
sub DISABLE_initializeUserHandler
{
### my ( $loginName, $url, $pathInfo ) = @_;   # do not uncomment, use $_[0], $_[1]... instead

    TWiki::Func::writeDebug( "- ${pluginName}::initializeUserHandler( $_[0], $_[1] )" ) if $debug;

    # Allows a plugin to set the username based on cookies. Called by TWiki::initialize.
    # Return the user name, or "guest" if not logged in.
    # New hook in TWiki::Plugins $VERSION = '1.010'

}

# =========================
sub DISABLE_registrationHandler
{
### my ( $web, $wikiName, $loginName ) = @_;   # do not uncomment, use $_[0], $_[1]... instead

    TWiki::Func::writeDebug( "- ${pluginName}::registrationHandler( $_[0], $_[1] )" ) if $debug;

    # Allows a plugin to set a cookie at time of user registration.
    # Called by the register script.
    # New hook in TWiki::Plugins $VERSION = '1.010'

}

# =========================
sub commonTagsHandler
{
### my ( $text, $topic, $web ) = @_;   # do not uncomment, use $_[0], $_[1]... instead

    TWiki::Func::writeDebug( "- ${pluginName}::commonTagsHandler( $_[2].$_[1] )" ) if $debug;

    # This is the place to define customized tags and variables
    # Called by sub handleCommonTags, after %INCLUDE:"..."%

      $_[0] =~ s/%TLQ[{\[](.*?)[}\]]%/&handleTestlinkQuery($1)/ge;
}

# =========================
sub DISABLE_startRenderingHandler
{
### my ( $text, $web ) = @_;   # do not uncomment, use $_[0], $_[1] instead

    TWiki::Func::writeDebug( "- ${pluginName}::startRenderingHandler( $_[1] )" ) if $debug;

    # This handler is called by getRenderedVersion just before the line loop

    # do custom extension rule, like for example:
    # $_[0] =~ s/old/new/g;
}

# =========================
sub DISABLE_outsidePREHandler
{
### my ( $text ) = @_;   # do not uncomment, use $_[0] instead

    ##TWiki::Func::writeDebug( "- ${pluginName}::outsidePREHandler( $renderingWeb.$topic )" ) if $debug;

    # This handler is called by getRenderedVersion, once per line, before any changes,
    # for lines outside <pre> and <verbatim> tags. 
    # Use it to define customized rendering rules.
    # Note: This is an expensive function to comment out.
    # Consider startRenderingHandler instead

    # do custom extension rule, like for example:
    # $_[0] =~ s/old/new/g;
}

# =========================
sub DISABLE_insidePREHandler
{
### my ( $text ) = @_;   # do not uncomment, use $_[0] instead

    ##TWiki::Func::writeDebug( "- ${pluginName}::insidePREHandler( $web.$topic )" ) if $debug;

    # This handler is called by getRenderedVersion, once per line, before any changes,
    # for lines inside <pre> and <verbatim> tags. 
    # Use it to define customized rendering rules.
    # Note: This is an expensive function to comment out.
    # Consider startRenderingHandler instead

    # do custom extension rule, like for example:
    # $_[0] =~ s/old/new/g;
}

# =========================
sub DISABLE_endRenderingHandler
{
### my ( $text ) = @_;   # do not uncomment, use $_[0] instead

    TWiki::Func::writeDebug( "- ${pluginName}::endRenderingHandler( $web.$topic )" ) if $debug;

    # This handler is called by getRenderedVersion just after the line loop, that is,
    # after almost all XHTML rendering of a topic. <nop> tags are removed after this.

}

# =========================
sub DISABLE_beforeEditHandler
{
### my ( $text, $topic, $web ) = @_;   # do not uncomment, use $_[0], $_[1]... instead

    TWiki::Func::writeDebug( "- ${pluginName}::beforeEditHandler( $_[2].$_[1] )" ) if $debug;

    # This handler is called by the edit script just before presenting the edit text
    # in the edit box. Use it to process the text before editing.
    # New hook in TWiki::Plugins $VERSION = '1.010'

}

# =========================
sub DISABLE_afterEditHandler
{
### my ( $text, $topic, $web ) = @_;   # do not uncomment, use $_[0], $_[1]... instead

    TWiki::Func::writeDebug( "- ${pluginName}::afterEditHandler( $_[2].$_[1] )" ) if $debug;

    # This handler is called by the preview script just before presenting the text.
    # New hook in TWiki::Plugins $VERSION = '1.010'

}

# =========================
sub DISABLE_beforeSaveHandler
{
### my ( $text, $topic, $web ) = @_;   # do not uncomment, use $_[0], $_[1]... instead

    TWiki::Func::writeDebug( "- ${pluginName}::beforeSaveHandler( $_[2].$_[1] )" ) if $debug;

    # This handler is called by TWiki::Store::saveTopic just before the save action.
    # New hook in TWiki::Plugins $VERSION = '1.010'

}

# =========================
sub DISABLE_writeHeaderHandler
{
### my ( $query ) = @_;   # do not uncomment, use $_[0] instead

    TWiki::Func::writeDebug( "- ${pluginName}::writeHeaderHandler( query )" ) if $debug;

    # This handler is called by TWiki::writeHeader, just prior to writing header. 
    # Return a single result: A string containing HTTP headers, delimited by CR/LF
    # and with no blank lines. Plugin generated headers may be modified by core
    # code before they are output, to fix bugs or manage caching. Plugins should no
    # longer write headers to standard output.
    # Use only in one Plugin.
    # New hook in TWiki::Plugins $VERSION = '1.010'

}

# =========================
sub DISABLE_redirectCgiQueryHandler
{
### my ( $query, $url ) = @_;   # do not uncomment, use $_[0], $_[1] instead

    TWiki::Func::writeDebug( "- ${pluginName}::redirectCgiQueryHandler( query, $_[1] )" ) if $debug;

    # This handler is called by TWiki::redirect. Use it to overload TWiki's internal redirect.
    # Use only in one Plugin.
    # New hook in TWiki::Plugins $VERSION = '1.010'

}

# =========================
sub DISABLE_getSessionValueHandler
{
### my ( $key ) = @_;   # do not uncomment, use $_[0] instead

    TWiki::Func::writeDebug( "- ${pluginName}::getSessionValueHandler( $_[0] )" ) if $debug;

    # This handler is called by TWiki::getSessionValue. Return the value of a key.
    # Use only in one Plugin.
    # New hook in TWiki::Plugins $VERSION = '1.010'

}

# =========================
sub DISABLE_setSessionValueHandler
{
### my ( $key, $value ) = @_;   # do not uncomment, use $_[0], $_[1] instead

    TWiki::Func::writeDebug( "- ${pluginName}::setSessionValueHandler( $_[0], $_[1] )" ) if $debug;

    # This handler is called by TWiki::setSessionValue. 
    # Use only in one Plugin.
    # New hook in TWiki::Plugins $VERSION = '1.010'

}

# =========================

sub handleTestlinkQuery
{
    my ( $text ) = @_;
  #All possible parameters at the moment
    my $format = "";
    my $format_req = TWiki::Func::getPreferencesValue( "\U$pluginName\E_FORMAT_REQ" ) || "| \$id | \$title |";
    my $format_tc = TWiki::Func::getPreferencesValue( "\U$pluginName\E_FORMAT_TC" ) || "| \$id | \$title | \$summary |";
    my $url_req = $url . TWiki::Func::getPreferencesValue( "\U$pluginName\E_URL_REQ" ) || "/lib/req/reqSpecView.php";
    my $url_tc = $url . TWiki::Func::getPreferencesValue( "\U$pluginName\E_URL_TC" ) || "/lib/testcases/archiveData.php?edit=testcase";  
    my $dataView = 0;
    $dataView = 1 if ( $text =~ s/data=[\"\']on[\"\']// );
    my $show = "";
    $show = $1 if ( $text =~ s/show=[\"\'](.*?)[\"\']// );
    my $id = "";
    $id = $1 if ( $text =~ s/id=[\"\'](.*?)[\"\']// );
    my $title = "";
    $title = $1 if ( $text =~ s/title=[\"\'](.*?)[\"\']// );

    my $result = "";
    my $ids_str = getIdString( $id, $title, $show );	
    if ( $ids_str ne "" ) {
    	my @statements = ( );
	if ( $show eq "REQ" ) {
	    $format_req = $1 if ( $text =~ s/format=[\"\'](.*?)[\"\']// );
	    $format = $format_req;

	    my $statement = "";
	    $statement  =     "SELECT req.* ";
	    $statement .=       "FROM requirements AS req ";
	    $statement .= "INNER JOIN req_coverage AS rc ";
	    $statement .=         "ON rc.req_id = req.id ";
	    $statement .=        "AND rc.testcase_id IN ($ids_str)";	
	    $statement .= "INNER JOIN nodes_hierarchy AS nh ";
	    $statement .=	  "ON rc.testcase_id = nh.id ";
	    $statement .= "INNER JOIN nodes_hierarchy AS nh2 ";
	    $statement .= 	  "ON nh.id = nh2.parent_id ";
	    $statement .=	 "AND nh2.node_type_id = 4 ";
	    $statement .= "INNER JOIN tcversions AS tcv ";
	    $statement .= 	  "ON tcv.id = nh2.id ";
	    $statement .= 	 "AND tcv.active = 1 ";
	    $statement .= "INNER JOIN testplan_tcversions AS tptc ";
	    $statement .= 	  "ON tcv.id = tptc.tcversion_id ";
	    $statement .= "INNER JOIN testplans AS tp ";
	    $statement .=	  "ON tp.id = tptc.testplan_id ";
	    $statement .=	 "AND tp.active = 1";
	    push(  @statements, $statement );
        }
        elsif ( $show eq "TC" ) {
	    $format_tc = $1 if ( $text =~ s/format=[\"\'](.*?)[\"\']// );
            $format = $format_tc;

	    my $statement = "";
	    $statement  =     "SELECT nh.id AS id, nh.name AS title ";
	    $statement .=       "FROM nodes_hierarchy AS nh ";
	    $statement .= "INNER JOIN req_coverage AS rc ";
            $statement .=         "ON rc.testcase_id = nh.id ";
	    $statement .=        "AND rc.req_id IN ($ids_str) ";
	    $statement .= "INNER JOIN requirements AS req ";
	    $statement .=         "ON req.id = rc.req_id ";
            $statement .=      "WHERE nh.node_type_id = 3";
	    push( @statements, $statement );
	    
	    $statement  =     "SELECT nh.parent_id AS parent_id, nh.name AS project ";
 	    $statement .=       "FROM nodes_hierarchy AS nh ";
	    $statement .=      "WHERE nh.id = parent_id_replace";
	    push( @statements, $statement );
			
	    $statement  =     "SELECT nh.id AS tcvid, tcv.summary AS summary, nh2.name AS testplan ";
	    $statement .=       "FROM nodes_hierarchy AS nh ";
            $statement .= "INNER JOIN testplans as tp ";
	    $statement .=         "ON tp.active = 1 ";
	    $statement .=	 "AND tp.testproject_id = project_id_replace ";
	    $statement .= "INNER JOIN nodes_hierarchy AS nh2 ";
	    $statement .=         "ON nh2.id = tp.id ";
  	    $statement .= "INNER JOIN tcversions AS tcv ";
	    $statement .=         "ON tcv.id = nh.id ";
	    $statement .=        "AND tcv.active = 1 ";
	    $statement .= "INNER JOIN testplan_tcversions AS tp_tcv ";
	    $statement .=         "ON tp_tcv.testplan_id = tp.id ";
	    $statement .=        "AND tp_tcv.tcversion_id = nh.id ";
	    $statement .=      "WHERE nh.parent_id = testcase_id_replace";
	    push( @statements, $statement );

        }

    	my $db = openDB();
	#Get all the testcases that are related to the requirements
	my $failed = 0;
	my $tmp_1 = $db->prepare( $statements[0] );
	$tmp_1->execute( ) or $failed = 1;

	if ( $failed == 1 ) {
	    $result = "SQL error. See server error log";
	}
	else {
	    #Iterate all the testcases/requirements
	    while ( my $row_1 = $tmp_1->fetchrow_hashref ) {
		my %data_hash;
		foreach my $field_1 ( keys( %{$row_1} ) ) {
		    my $value = $$row_1{$field_1};
		    $data_hash{$field_1} = cleanValue( $value );
		}
		my $url_complete;
		if ( $show eq "REQ" ) {
		    $url_complete  = $url_req . "?editReq=" . $data_hash{'id'};
		    $url_complete .= "&idSRS=" . $data_hash{'srs_id'};		  
		}
		elsif ( $show eq "TC" ) {

		    # Find out the project
		    # Iterate the nodes_hierarchy till the parent_id is NULL
		    # -> we will find out the testproject name
		    my $parent_id = $data_hash{"id"};
		    my $project;
		    my $project_id;
		    my $statement_tmp; 
		    while ( $parent_id ne NULL ) {
			$project_id = $parent_id;
			$statement_tmp = $statements[1];
			$statement_tmp =~ s/parent_id_replace/$parent_id/g;
			my $tmp_2 = $db->prepare($statement_tmp);
	    	    	$tmp_2->execute( ) or $failed = 1;
 		    	if ( $failed == 1 ) {
	    		    $result = "SQL error. See server error log";
			    return $result; 
    	     	    	}
		 	my $row_2 = $tmp_2->fetchrow_hashref;
			$project = $$row_2{"project"};
		    	$parent_id = NULL;
			$parent_id = $$row_2{"parent_id"} if ( defined( $$row_2{"parent_id"} ) );			
		    }
 	            $data_hash{"project"} = cleanValue( $project );

		    # Find out the the correct and active version of the testcase 
		    # and related testplan
		    $statement_tmp = $statements[2];
		    $statement_tmp =~ s/project_id_replace/$project_id/g;
		    $statement_tmp =~ s/testcase_id_replace/$data_hash{'id'}/g;
		    my $tmp_3 = $db->prepare($statement_tmp);
	    	    $tmp_3->execute( ) or $failed = 1;
 		    if ( $failed == 1 ) {
	    		$result = "SQL error. See server error log";
			return $result; 
    	     	    }
		    my $row_3 = $tmp_3->fetchrow_hashref;
		    if ( scalar keys %$row_3 > 0 ) {
 	                foreach my $field_3 ( keys( %{$row_3} ) ) {
			    my $value = $$row_3{$field_3};
			    $data_hash{$field_3} = cleanValue( $value );
		    	}
		    }
		    else { 
		 	next;	
		    }
		    $url_complete = $url_tc . "&id=" . $data_hash{"id"};
		}
		$result .= getViewableData( $format, \%data_hash, $dataView, $url_complete );
	    }
	    if ( $result eq "" ) {
		if ( $show eq "REQ" ) {
	  	    $result = "No requirements found with given parameters";
		} elsif ( $show eq "TC" ) {
	            $result = "No testcases found with given parameters";
	    	}
	    }	
	}
        $db->disconnect;	
    }
    else {
	if ( $show eq "REQ" ) {
	    $result = "No requirements found with given parameters";
	} elsif ( $show eq "TC" ) {
	    $result = "No testcases found with given parameters";
	}	
    }
    return $result;
}


# Subroutine getViewableData to transform the data of a testcase or 
# a requirement to a viewable format
#
# parameters:
# - $format:	hash that contains the fields that are wanted to be 
#               shown if dataView is true
# - $data:	hash that contains the values of the executed query
# - $dataView:  flag to show whether the data is wanted be shown or
#		just a link
# - $url:	string that conmtains the link
# 
# returns:
# - $result:	string that contains info about a testcase or a
#		requirement

sub getViewableData
{
    my ( $format, $data, $dataView, $url ) = @_;
    my $result;

    if ( $dataView ) {
    	while ( my ($key, $value) = each(%$data) ) {
	    my $new_value = "";
	    my @tags = ( );
	    while ( $value =~ /<[^>]+>/ ) { #tags found
		$value =~ s/(<[^>]+>)/ TAGHERE /;
		push( @tags, $1 );
	    }
	    $value = cleanValue( $value );
	    my @value_array = split( /\s+/, $value );
	    foreach my $val ( @value_array ) {
		if ( $val ne "TAGHERE" ) {
		    $new_value .= " !" . $val;
		} else {
		    $new_value .= shift( @tags );
		}
	    }
	    $new_value = "<a href='" . $url . "'>" . $new_value . "</a>" if ( $key eq "id" );	
            $format =~ s/\$$key/$new_value/g;
	}
	$result = $format . "\n";
    }
    else {
	$result = "| <a href='" . $url . "'>" . $url . "</a> |\n";
    }
    return $result;

}

# Subroutine cleanValue to remove all the empty space from the
# beginning and from the end of a value
#
# parameters:
# - $value:	string to handle
#
# returns:
# - $value:	modified value
 
sub cleanValue
{
    my ( $value ) = @_;
    for ( $value ) {
        s/^\s+//;
        s/\s+$//;
    }
    $value =~ s/(\n|\r)/ /g;

    return $value;
}
# Subroutine getIdString to get a string of Ids of testacases or
# requirements
#
# parameters:
# - $id:	string of Ids of testcases or a requirements
# - $title:	string of titles of testacases or requirements
# - $show:	can be "REQ" or "TC". Defines whether the list
#		concerns about testcases or requirements
#
# returns:
# - $ids_str:	string of Ids of testcases or requirements

sub getIdString
{
    my ( $id, $title, $show ) = @_;

    my $ids_str = "";
    my $statement = "";
    if ( $id eq "" and $title ne "" ) { #id not defined and title defined
	if ( $show eq "TC" ) {
	    $statement  = "SELECT req.id AS id ";
	    $statement .=   "FROM requirements AS req ";
	    $statement .=  "WHERE req.title = '$title'";
	    $ids_str = getField( $statement );
	}
	elsif ( $show eq "REQ" ) {
	    $statement  =     "SELECT nh.id AS id ";
	    $statement .=       "FROM nodes_hierarchy AS nh ";
	    $statement .=      "WHERE nh.name = '$title'";
	    $statement .=        "AND nh.node_type_id = 3";
            $ids_str = getField( $statement );
	} 
    } 
    elsif ( $id ne "" and $title eq "" ) {
	$ids_str = $id;
    }
    return $ids_str;
}

sub getField
{
    my ( $statement ) = @_;
    my @id_arr = ();
 
    $db = openDB();
    my $tmp = $db->prepare( $statement );
    $tmp->execute();
    
    while ( my @row = $tmp->fetchrow_array ) {
	push( @id_arr, $row[0] );
    }

    $tmp->finish;
    $db->disconnect();
    return join( ",", @id_arr );
}

sub openDB
{
    my $host = "";
    $host .= ";host=$dbHost" if ( $dbHost ne "" );
    $host .= ";port=$dbPort" if ( $dbPort ne "" );
    my $db = DBI->connect("DBI:mysql:$dbName$host", $dbUser, $dbPasswd, {PrintError=>1, RaiseError=>0});
    if (! $db ) {
	die "ERROR!! Not possible to connect database!!";
    }
    return $db;
}

1;
