/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.Storable;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Vector;

public class StorableInput {
    private StreamTokenizer fTokenizer;
    private Vector fMap;

    public StorableInput(InputStream stream) {
        BufferedReader r = new BufferedReader(new InputStreamReader(stream));
        this.fTokenizer = new StreamTokenizer(r);
        this.fMap = new Vector();
    }

    public Storable readStorable() throws IOException {
        String s = this.readString();
        if (s.equals("NULL")) {
            return null;
        }
        if (s.equals("REF")) {
            int ref = this.readInt();
            return this.retrieve(ref);
        }
        Storable storable = (Storable)this.makeInstance(s);
        this.map(storable);
        storable.read(this);
        return storable;
    }

    public boolean testForNumber() throws IOException {
        int token = this.fTokenizer.nextToken();
        this.fTokenizer.pushBack();
        return token == -2;
    }

    public String readString() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -3 || token == 34) {
            return StorableInput.unescapeUnicode(this.fTokenizer.sval);
        }
        String msg = "String expected in line: " + this.fTokenizer.lineno();
        throw new IOException(msg);
    }

    public static String unescapeUnicode(String str) throws IOException {
        StringBuffer sbuf = new StringBuffer();
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    sbuf.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                }
                catch (NumberFormatException nfe) {
                    sbuf.append(unicode);
                }
                continue;
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        sbuf.append('\\');
                        break;
                    }
                    case '\'': {
                        sbuf.append('\'');
                        break;
                    }
                    case '\"': {
                        sbuf.append('\"');
                        break;
                    }
                    case 'r': {
                        sbuf.append('\r');
                        break;
                    }
                    case 'f': {
                        sbuf.append('\f');
                        break;
                    }
                    case 't': {
                        sbuf.append('\t');
                        break;
                    }
                    case 'n': {
                        sbuf.append('\n');
                        break;
                    }
                    case 'b': {
                        sbuf.append('\b');
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        sbuf.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            sbuf.append(ch);
        }
        if (hadSlash) {
            sbuf.append('\\');
        }
        return sbuf.toString();
    }

    public int readInt() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -2) {
            return (int)this.fTokenizer.nval;
        }
        String msg = "Integer expected in line: " + this.fTokenizer.lineno();
        throw new IOException(msg);
    }

    public Color readColor() throws IOException {
        return new Color(this.readInt(), this.readInt(), this.readInt());
    }

    public double readDouble() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -2) {
            return this.fTokenizer.nval;
        }
        String msg = "Double expected in line: " + this.fTokenizer.lineno();
        throw new IOException(msg);
    }

    public boolean readBoolean() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -2) {
            return (int)this.fTokenizer.nval == 1;
        }
        String msg = "Integer expected in line: " + this.fTokenizer.lineno();
        throw new IOException(msg);
    }

    private Object makeInstance(String className) throws IOException {
        try {
            Class<?> cl = Class.forName(className);
            return cl.newInstance();
        }
        catch (NoSuchMethodError e) {
            throw new IOException("Class " + className + " does not seem to have a no-arg constructor");
        }
        catch (ClassNotFoundException e) {
            throw new IOException("No class: " + className);
        }
        catch (InstantiationException e) {
            throw new IOException("Cannot instantiate: " + className);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Class (" + className + ") not accessible");
        }
    }

    private void map(Storable storable) {
        if (!this.fMap.contains(storable)) {
            this.fMap.addElement(storable);
        }
    }

    private Storable retrieve(int ref) {
        return (Storable)this.fMap.elementAt(ref);
    }
}

