/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.PaletteListener;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public abstract class PaletteButton
extends Canvas
implements MouseListener,
MouseMotionListener {
    static final int NORMAL = 1;
    static final int PRESSED = 2;
    static final int SELECTED = 3;
    private PaletteListener fListener;
    private int fState;
    private int fOldState;

    public PaletteButton(PaletteListener listener) {
        this.fListener = listener;
        this.fOldState = 1;
        this.fState = 1;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public abstract void paintBackground(Graphics var1);

    public abstract void paintNormal(Graphics var1);

    public abstract void paintPressed(Graphics var1);

    public abstract void paintSelected(Graphics var1);

    public Object value() {
        return null;
    }

    public String name() {
        return "";
    }

    public void reset() {
        this.fState = 1;
        this.repaint();
    }

    public void select() {
        this.fState = 3;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        this.fOldState = this.fState;
        this.fState = 2;
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.fState = this.contains(e.getX(), e.getY()) ? 2 : this.fOldState;
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.fState = this.fOldState;
        this.repaint();
        if (this.contains(e.getX(), e.getY())) {
            this.fListener.paletteUserSelected(this);
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.fListener.paletteUserOver(this, true);
    }

    public void mouseExited(MouseEvent e) {
        if (this.fState == 2) {
            this.mouseDragged(e);
        }
        this.fListener.paletteUserOver(this, false);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this.fState) {
            case 2: {
                this.paintPressed(g);
                break;
            }
            case 3: {
                this.paintSelected(g);
                break;
            }
            default: {
                this.paintNormal(g);
            }
        }
    }
}

