/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.ActionListener;

public class FloatingTextField {
    private TextArea fEditWidget = new TextArea(5, 20);
    private Container fContainer;

    public void createOverlay(Container container) {
        this.createOverlay(container, null);
    }

    public void createOverlay(Container container, Font font) {
        container.add((Component)this.fEditWidget, 0);
        if (font != null) {
            this.fEditWidget.setFont(font);
        }
        this.fContainer = container;
        this.fEditWidget.requestFocus();
    }

    public void addActionListener(ActionListener listener) {
        throw new RuntimeException("Adding action listener " + listener);
    }

    public void removeActionListener(ActionListener listener) {
        throw new RuntimeException("Removing action listener " + listener);
    }

    public void setBounds(Rectangle r, String text) {
        this.fEditWidget.setText(text);
        this.fEditWidget.setBounds(r.x, r.y, r.width, r.height);
        this.fEditWidget.setVisible(true);
        this.fEditWidget.selectAll();
        this.fEditWidget.requestFocus();
    }

    public String getText() {
        return this.fEditWidget.getText();
    }

    public Dimension getPreferredSize(int rows, int cols) {
        return this.fEditWidget.getPreferredSize(rows, cols);
    }

    public void endOverlay() {
        this.fContainer.requestFocus();
        if (this.fEditWidget == null) {
            return;
        }
        this.fEditWidget.setVisible(false);
        this.fContainer.remove(this.fEditWidget);
        Rectangle bounds = this.fEditWidget.getBounds();
        this.fContainer.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
    }
}

