/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.twiki;

import CH.ifa.draw.appframe.LightweightDrawApplet;
import CH.ifa.draw.twiki.TWikiFrame;
import java.awt.Label;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;

public class TWikiDraw
extends LightweightDrawApplet {
    static String NL = "\r\n";
    static String NLNL = NL + NL;
    private static String VIEWPATH_PARAMETER = "viewpath";

    public void init() {
        String colors = this.getParameter("extracolors");
        this.init(new TWikiFrame(this, colors));
        String drawPath = this.getParameter("drawpath");
        this.add(new Label("TWikiDraw editing " + drawPath));
    }

    public boolean post(String url, String fileName, String cryptToken, String type, String path, String content, String comment) throws IOException {
        String sep = "89692781418184";
        while (content.indexOf(sep) != -1) {
            sep = sep + "x";
        }
        String message = this.makeMimeForm(fileName, cryptToken, type, path, content, comment, sep);
        URL server = new URL(this.getCodeBase().getProtocol(), this.getCodeBase().getHost(), this.getCodeBase().getPort(), url);
        URLConnection connection = server.openConnection();
        connection.setAllowUserInteraction(false);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-type", "multipart/form-data; boundary=" + sep);
        connection.setRequestProperty("Content-length", Integer.toString(message.length()));
        String replyString = null;
        try {
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.writeBytes(message);
            out.close();
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String reply = null;
                while ((reply = in.readLine()) != null) {
                    if (!reply.startsWith("ERROR ")) continue;
                    replyString = reply.substring("ERROR ".length());
                }
                in.close();
            }
            catch (IOException ioe) {
                replyString = ioe.toString();
            }
        }
        catch (UnknownServiceException use) {
            replyString = use.getMessage();
            System.out.println(message);
        }
        if (replyString != null) {
            if (replyString.startsWith("URL ")) {
                URL eurl = this.getURL(replyString.substring("URL ".length()));
                this.getAppletContext().showDocument(eurl);
            } else if (replyString.startsWith("java.io.FileNotFoundException")) {
                if (path.endsWith(".draw") || path.endsWith(".map")) {
                    System.out.println(content);
                }
            } else {
                this.showStatus(replyString);
            }
            return false;
        }
        this.showStatus(url + " saved");
        return true;
    }

    private String makeMimeForm(String fileName, String cryptToken, String type, String path, String content, String comment, String sep) {
        String binary = "";
        if (type.equals("image/gif")) {
            binary = "Content-Transfer-Encoding: binary" + NL;
        }
        String mime_sep = NL + "--" + sep + NL;
        return "--" + sep + "\r\n" + "Content-Disposition: form-data; name=\"filename\"" + NLNL + fileName + mime_sep + "Content-Disposition: form-data; name=\"crypttoken\"" + NLNL + cryptToken + mime_sep + "Content-Disposition: form-data; name=\"noredirect\"" + NLNL + 1 + mime_sep + "Content-Disposition: form-data; name=\"filepath\"; " + "filename=\"" + path + "\"" + NL + "Content-Type: " + type + NL + binary + NL + content + mime_sep + "Content-Disposition: form-data; name=\"filecomment\"" + NLNL + comment + NL + "--" + sep + "--" + NL;
    }

    public void exit() {
        String viewPath = this.getParameter(VIEWPATH_PARAMETER);
        if (viewPath != null) {
            try {
                URL url = this.getURL(viewPath);
                this.getAppletContext().showDocument(url, "_self");
            }
            catch (IOException mue) {
                this.showStatus("Bad URL for viewpath " + viewPath);
            }
        }
    }
}

