/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.FigureAttributes;
import CH.ifa.draw.util.ColorMap;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public abstract class AttributeFigure
extends AbstractFigure {
    private static FigureAttributes fgDefaultAttributes = null;
    private static final long serialVersionUID = -10857585979273442L;
    private int attributeFigureSerializedDataVersion = 1;
    private Rectangle urlBox = null;

    protected AttributeFigure() {
    }

    public void draw(Graphics g, boolean showGuides) {
        this.urlBox = null;
        Color fill = this.getFillColor();
        if (!ColorMap.getColorMap().isTransparent(fill)) {
            g.setColor(fill);
            this.drawBackground(g);
        }
        Color frame = this.getFrameColor();
        if (!ColorMap.getColorMap().isTransparent(frame)) {
            g.setColor(frame);
            this.drawFrame(g);
        }
        if (showGuides) {
            this.drawURL(g);
        }
    }

    protected void drawBackground(Graphics g) {
    }

    protected void drawFrame(Graphics g) {
    }

    private void drawURL(Graphics g) {
        String sense = (String)this.getAttribute("Sensitive");
        if (sense != null && sense.length() > 0) {
            String text = "url=" + sense;
            Rectangle r = this.displayBox();
            int x = r.x;
            int y = r.y + r.height;
            g.setColor(Color.red);
            g.setFont(AbstractFigure.dialogFont);
            g.drawString(text, x, y);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D bounds = fm.getStringBounds(text, g);
            int width = (int)Math.ceil(bounds.getWidth());
            int height = (int)Math.ceil(bounds.getHeight());
            this.urlBox = new Rectangle(x, y - height, width, height);
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.urlBox != null) {
            this.getChangeListener().figureInvalidated(new FigureChangeEvent(this, this.urlBox));
        }
    }

    public Color getFillColor() {
        return (Color)this.getAttribute("FillColor");
    }

    public Color getFrameColor() {
        return (Color)this.getAttribute("FrameColor");
    }

    private static void initializeAttributes() {
        fgDefaultAttributes = new FigureAttributes();
        fgDefaultAttributes.set("FrameColor", Color.black);
        fgDefaultAttributes.set("FillColor", new Color(7396243));
        fgDefaultAttributes.set("TextColor", Color.black);
        fgDefaultAttributes.set("ArrowMode", new Integer(0));
        fgDefaultAttributes.set("FontName", "Helvetica");
        fgDefaultAttributes.set("FontSize", new Integer(12));
        fgDefaultAttributes.set("FontStyle", new Integer(0));
        fgDefaultAttributes.set("TextAlign", "Left");
        fgDefaultAttributes.set("Sensitive", "");
    }

    public static Object getDefaultAttribute(String name) {
        if (fgDefaultAttributes == null) {
            AttributeFigure.initializeAttributes();
        }
        return fgDefaultAttributes.get(name);
    }

    public Object defaultAttribute(String name) {
        return AttributeFigure.getDefaultAttribute(name);
    }

    public String getMap() {
        return "";
    }
}

