/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.IOException;

public class ArrowTip
implements LineDecoration {
    private double fAngle;
    private double fOuterRadius;
    private double fInnerRadius;
    private static final long serialVersionUID = -3459171428373823638L;
    private int arrowTipSerializedDataVersion = 1;

    public ArrowTip() {
        this.fAngle = 0.4;
        this.fOuterRadius = 8.0;
        this.fInnerRadius = 8.0;
    }

    public ArrowTip(double angle, double outerRadius, double innerRadius) {
        this.fAngle = angle;
        this.fOuterRadius = outerRadius;
        this.fInnerRadius = innerRadius;
    }

    public void draw(Graphics g, int x1, int y1, int x2, int y2) {
        Polygon p = this.outline(x1, y1, x2, y2);
        g.fillPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public Polygon outline(int x1, int y1, int x2, int y2) {
        double dir = 1.5707963267948966 - Math.atan2(x2 - x1, y1 - y2);
        return this.outline(x1, y1, dir);
    }

    private Polygon outline(int x, int y, double direction) {
        Polygon shape = new Polygon();
        shape.addPoint(x, y);
        this.addPointRelative(shape, x, y, this.fOuterRadius, direction - this.fAngle);
        this.addPointRelative(shape, x, y, this.fInnerRadius, direction);
        this.addPointRelative(shape, x, y, this.fOuterRadius, direction + this.fAngle);
        shape.addPoint(x, y);
        return shape;
    }

    private void addPointRelative(Polygon shape, int x, int y, double radius, double angle) {
        shape.addPoint(x + (int)(radius * Math.cos(angle)), y - (int)(radius * Math.sin(angle)));
    }

    public void write(StorableOutput dw) {
    }

    public String getMap() {
        return "";
    }

    public void read(StorableInput dr) throws IOException {
    }
}

