#!/usr/local/bin/perl -wI.

package TWiki::Contrib::Remix;

use strict;

use CGI;
use TWiki::Func;
use TWiki::UI::View;
use File::Temp qw/ tempfile /;
use File::Basename qw/basename/;
use Error qw( :try );

use List::Compare::Functional qw( get_unique );

use TWiki::Contrib::GenPDF;

use vars qw( $VERSION $RELEASE );

# This should always be $Rev: 9716 $ so that TWiki can determine the checked-in
# status of the plugin. It is used by the build automation tools, so
# you should leave it alone.
$VERSION = '$Rev: 9716 $';

# This is a free-form string you can use to "name" your own plugin version.
# It is *not* used by the build automation tools, but is reported as part
# of the version number in PLUGINDESCRIPTIONS.
$RELEASE = 'Dakar';


=pod

=head1 TWiki::Contrib::IndexGen

TWiki::Contrib::IndexGen - remix and export your web

=head1 DESCRIPTION

This plugin enables you to drag and drop multiple topics from one or
more webs, arrange them in the order you prefer and export them as an
indexed pdf document. Covers can also be chosen (from a seperate
'covers' web) and the pdf can be archived with comments for further
downloads if needed.

=cut


sub _getRenderedView {
   my ($webName, $topic, $authors) = @_;

   my $text = TWiki::Func::readTopicText($webName, $topic);

   # change the credits topic if CopyrightPlugin is installed
   $text =~ s/\%AUTHORS({.+})?\%/\%AUTHORS\{topics="$authors"\}\%/g if($topic eq "Credits");


   $text =~ s/\%TOC({.*?})?\%//g; # remove TWiki TOC
   $text = TWiki::Func::expandCommonVariables($text, $topic, $webName);
   $text = TWiki::Func::renderText($text);
   return $text;
}

sub _prepare {
    my( $text, $session, $webName, $topicName, $meta, $minimalist) = @_;

    $text = $session->handleCommonTags( $text, $webName, $topicName );
    $text = $session->{renderer}->getRenderedVersion( $text, $webName, $topicName );
    $text =~ s/( ?) *<\/?(nop|noautolink)\/?>\n?/$1/gois;

    return $text;
}

sub prepare_page {
  my($userName, $query, $SCRIPT_TEXT, $TEXT) = @_;


  my $session = new TWiki($userName, $query);

  my $skin = $session->getSkin();

  my $template = "remix.tmpl";

  my $tmpl = $session->{templates}->readTemplate( $template, $skin );


  my( $start, $end , $middle);
  if( $tmpl =~ m/^(.*)%PDFSCRIPT%(.*)%TEXT%(.*)$/s ) {
    $start = $1;
    $middle = $2;
    $end = $3;
  } else {
    $start = $tmpl;
    $middle = '';
    $end = '';
  }

  my $webName = "Main";
  my $topicName = "WebHome";

  my @args = ( $session, $webName, $topicName, "", 0 );

  my $page = "";

  $session->enterContext( 'header_text' );

  $start = $session->handleCommonTags( $start, $webName, $topicName );
  $start = $session->{renderer}->getRenderedVersion( $start, $webName, $topicName );
  $start =~ s/( ?) *<\/?(nop|noautolink)\/?>\n?/$1/gois;
  $page = _prepare($start, @args);
  $page .= $SCRIPT_TEXT;
  $page .= _prepare($middle, @args);

  $session->leaveContext( 'header_text' );

  $page .= $TEXT;

  $session->enterContext( 'footer_text' );
  $page .= _prepare($end, @args);
  $session->leaveContext( 'footer_text' );

  $session->writeCompletePage( $page, 'view', "text/html" );
}

sub _createTitleFile {
   my ($webName, $query) = @_;

   
   my ($meta, $text) = TWiki::Func::readTopic($webName, $query->param("cover"));
   # Extract the content between the PDFSTART and PDFSTOP comment markers
   #$text = TWiki::Contrib::GenPDF::_extractPdfSections($text);
   $text = TWiki::Contrib::GenPDF::_fixTags($text);
 
   # Now render the rest of the topic
   $text = TWiki::Func::expandCommonVariables($text, $query->param("cover"), $webName);
   my $manualTitle = $query->param("pdftitle") || "title";
   $text =~ s/\%MANUAL_TITLE\%/$manualTitle/g;
   $text = TWiki::Func::renderText($text);
    
   # FIXME - send to _fixHtml
   # As of HtmlDoc 1.8.24, it only handles HTML3.2 elements so
   # convert some common HTML4.x elements to similar HTML3.2 elements
   $text =~ s/&ndash;/&shy;/g;
   $text =~ s/&[lr]dquo;/"/g;
   $text =~ s/&[lr]squo;/'/g;
   $text =~ s/&brvbar;/|/g;
  
   # convert twikiNewLinks to normal text
   # FIXME - should this be a preference?
   $text =~ s/<span class="twikiNewLink".*?>([\w\s]+)<.*?\/span>/$1/gs;
   
   # Fix the image tags for links relative to web server root and
   # fully qualify any unqualified URLs (to make it portable to another host)
   my $url = TWiki::Func::getUrlHost();
   $text =~ s/<img(.*?) src="\//<img$1 src="$url\//sgi;
   $text =~ s/<a(.*?) href="(?!#)\//<a$1 href="$url\//sgi;
   
    # Save it to a file
    my $fh = new File::Temp(TEMPLATE => 'GenPDFAddOnXXXXXXXXXX',
                             DIR => File::Spec->tmpdir(),
                             UNLINK => 0,
                             SUFFIX => '.html');
    print $fh "<html><body>".$text."</body></html>";

    return $fh;
}


=pod

=head2 saveArrange($webName, $userName, $thePathInfo, $query)

saves the changes.

=cut

sub saveArrange {
  my( $webName, $userName, $thePathInfo, $query) = @_;

  my $topic = "WebHome";
  $webName = "Main";

   # Get preferences
   TWiki::Contrib::GenPDF::_getPrefs($query);

   # Set a default skin in the query
   $query->param('skin', $TWiki::Contrib::GenPDF::prefs{'skin'});

   # Check for existence
   TWiki::Func::redirectCgiQuery($query,
         TWiki::Func::getOopsUrl($webName, $topic, "oopsmissing"))
      unless TWiki::Func::topicExists($webName, $topic);
   TWiki::Func::redirectCgiQuery($query,
         TWiki::Func::getOopsUrl($webName, $TWiki::Contrib::GenPDF::prefs{'hftopic'}, "oopscreatenewtopic"))
      unless TWiki::Func::topicExists($webName, $TWiki::Contrib::GenPDF::prefs{'hftopic'});
   TWiki::Func::redirectCgiQuery($query,
         TWiki::Func::getOopsUrl($webName, $TWiki::Contrib::GenPDF::prefs{'titletopic'}, "oopscreatenewtopic"))
      unless TWiki::Func::topicExists($webName, $TWiki::Contrib::GenPDF::prefs{'titletopic'});


   # Get header/footer data
   my $hfData = TWiki::Contrib::GenPDF::_getHeaderFooterData($webName);

   my $fgrepCmd;
   my $htmldocCmd;
   if( defined $TWiki::cfg{DataDir} ) {
       # TWiki-4 or more recent
       $fgrepCmd = $TWiki::cfg{RCS}{FgrepCmd};
       $htmldocCmd = $TWiki::cfg{Extensions}{GenPDFAddOn}{htmldocCmd};
   } else {
       # Cairo or earlier
       $fgrepCmd = $TWiki::fgrepCmd;
       $htmldocCmd = $TWiki::htmldocCmd;
   }

   die "Path to htmldoc command not defined" unless $htmldocCmd;

   # Do a recursive depth first walk through the ancestors in the tree
   # sub is defined here for clarity
   sub _depthFirst {
      my $parent = shift;
      my $topics = shift; # ref to @topics
      # the grep gets around a perl dereferencing bug when using strict refs
      my @children = grep { $_; } @{ $TWiki::Contrib::GenPDF::tree{$parent} };
      for ( sort @children ) {
         #print STDERR "new child of $parent: '$_'\n"; # DEBUG
         push @$topics, $_;
         if (defined $TWiki::Contrib::GenPDF::tree{$_}) {
            # this child is also a parent so bring them in too
            _depthFirst($_, $topics);
         }
      }
   }
   my @topics;
   push @topics, $topic;
   _depthFirst($topic, \@topics);

   # We shift headers here so every topic gets its own <h1>$topic</h1>
   $TWiki::Contrib::GenPDF::prefs{'shift'} += 1 if (scalar @topics > 1);

   my @contentFiles;

   my $pagesn = $query->param("pagesn");

   my $authors= "";

   for  (split(/,/, $pagesn)) {
       if($_ =~ /^(\w+)_([\d\w_]+)/)  {
         $authors .= "$1:$2,";
       }
   }
   
   $pagesn .= ",Main_Credits";

   for my $item (split(/,/, $pagesn)) {
     if($item ne "") {
       $item =~ /^(\w+)_([\d\w_]+)/;

       $webName = $1;
       $topic   = $2;

       # Get ready to display HTML topic
       my $htmlData = _getRenderedView($webName, $topic, $authors);

       # Fix topic text (i.e. correct any problems with the HTML that htmldoc might not like
       $htmlData = TWiki::Contrib::GenPDF::_fixHtml($htmlData, $topic, $webName, \@topics);

       # The data returned also incluides the header. Remove it.
       $htmlData =~ s|.*(<!DOCTYPE)|$1|s;

       # Save this to a temp file for htmldoc processing
       my $contentFile = new File::Temp(TEMPLATE => 'GenPDFAddOnXXXXXXXXXX',
                                        DIR => File::Spec->tmpdir(),
                                        UNLINK => 1, 
                                        SUFFIX => '.html');
       print $contentFile $hfData . $htmlData;
       push @contentFiles, $contentFile;
     }
   }

   # Create a file holding the title data
   # koji je ovo web name uopce?
   my $titleFile = _createTitleFile("ManualCover", $query);

   # Create a temp file for output
   my $outputFile = new File::Temp(TEMPLATE => 'GenPDFAddOnXXXXXXXXXX',
                                   DIR => File::Spec->tmpdir(),
                                   UNLINK => 1, 
                                   SUFFIX => '.pdf');


#adam hack
#my $pdfsize = "5.88.3in";

   # Convert contentFile to PDF using HTMLDOC
   my @htmldocArgs;
   push @htmldocArgs, "--book",
                      "--quiet",
                      "--links",
		      #adam hack ->a5
                      #"--size",  "176250mm",
                      "--linkstyle", "plain",
                      "--linkcolor", "black",
                      "--outfile", "$outputFile",
                      "--format", "$TWiki::Contrib::GenPDF::prefs{'format'}",
                      "--$TWiki::Contrib::GenPDF::prefs{'orientation'}",
                      "--size", "$TWiki::Contrib::GenPDF::prefs{'size'}",
                      "--browserwidth", "$TWiki::Contrib::GenPDF::prefs{'width'}",
		      #"--title",
                      "--titlefile", "$titleFile";

   if ($TWiki::Contrib::GenPDF::prefs{'toclevels'} eq '0' ) {
      push @htmldocArgs, "--no-toc",
                         "--firstpage", "p1";
   }
   else
   {
      push @htmldocArgs, "--numbered" if $TWiki::Contrib::GenPDF::prefs{'numbered'};
      push @htmldocArgs, "--toclevels", "$TWiki::Contrib::GenPDF::prefs{'toclevels'}",
                         "--tocheader", "$TWiki::Contrib::GenPDF::prefs{'tocheader'}",
                         "--tocfooter", "$TWiki::Contrib::GenPDF::prefs{'tocfooter'}",
                         "--firstpage", "toc";
   }

   push @htmldocArgs, "--duplex" if $TWiki::Contrib::GenPDF::prefs{'duplex'};
   push @htmldocArgs, "--bodyimage", "$TWiki::Contrib::GenPDF::prefs{'bodyimage'}" if $TWiki::Contrib::GenPDF::prefs{'bodyimage'};
   push @htmldocArgs, "--logoimage", "$TWiki::Contrib::GenPDF::prefs{'logoimage'}" if $TWiki::Contrib::GenPDF::prefs{'logoimage'};
   push @htmldocArgs, "--headfootfont", "$TWiki::Contrib::GenPDF::prefs{'headfootfont'}" if $TWiki::Contrib::GenPDF::prefs{'headfootfont'};
   push @htmldocArgs, "--permissions", "$TWiki::Contrib::GenPDF::prefs{'permissions'}" if $TWiki::Contrib::GenPDF::prefs{'permissions'};
   push @htmldocArgs, "--bodycolor", "$TWiki::Contrib::GenPDF::prefs{'bodycolor'}" if $TWiki::Contrib::GenPDF::prefs{'bodycolor'};
   push @htmldocArgs, "--top", "$TWiki::Contrib::GenPDF::prefs{'top'}" if $TWiki::Contrib::GenPDF::prefs{'top'};
   push @htmldocArgs, "--bottom", "$TWiki::Contrib::GenPDF::prefs{'bottom'}" if $TWiki::Contrib::GenPDF::prefs{'bottom'};
   push @htmldocArgs, "--left", "$TWiki::Contrib::GenPDF::prefs{'left'}" if $TWiki::Contrib::GenPDF::prefs{'left'};
   push @htmldocArgs, "--right", "$TWiki::Contrib::GenPDF::prefs{'right'}" if $TWiki::Contrib::GenPDF::prefs{'right'};

   push @htmldocArgs, @contentFiles;

   print STDERR "Calling htmldoc with args: @htmldocArgs\n";

   # Disable CGI feature of newer versions of htmldoc
   # (thanks to Brent Roberts for this fix)
   $ENV{HTMLDOC_NOCGI} = "yes";
   system($htmldocCmd, @htmldocArgs);
   if ($? == -1) {
      die "Failed to start htmldoc ($htmldocCmd): $!\n";
   }
   elsif ($? & 127) {
      printf STDERR "child died with signal %d, %s coredump\n",
         ($? & 127),  ($? & 128) ? 'with' : 'without';
      die "Conversion failed: '$!'";
   }
   else {
      printf STDERR "child exited with value %d\n", $? >> 8 unless $? >> 8 == 0;
   }

   #  output the HTML header and the output of HTMLDOC

   my $filename = $query->param("pdftitle") || "manual";
   $filename =~ s/ /_/g;
   
   my $cd = "filename=".$filename.".";
   $cd =~ s/\s/_/;

   try {
       if ($TWiki::Contrib::GenPDF::prefs{'format'} =~ /pdf/) {
           print CGI::header( -TYPE => 'application/x-pdf',
                              -Content_Disposition => $cd.'pdf');
       }
       elsif ($TWiki::Contrib::GenPDF::prefs{'format'} =~ /ps/) {
           print CGI::header( -TYPE => 'application/postscript',
                              -Content_Disposition => $cd.'ps');
       }
       else {
           print CGI::header( -TYPE => 'text/html',
                              -Content_Disposition => $cd.'html' );
       }
   } catch Error::Simple with {
   };


   while(<$outputFile>){
      print;
   }
   close $outputFile;


}



=pod

=head2 viewArrange($webName, $userName, $thePathInfo, $query)

Show the edit form.

=cut

sub viewArrange {
  my( $webName, $userName, $thePathInfo, $query) = @_;


  $thePathInfo =~ /^\/(.+)(\/){0,1}/;
   $webName = $1;


  ## DEFINE SCRIPT PART

  my $SCRIPT_TEXT = '';

  my $url = TWiki::Func::expandCommonVariables("%PUBURLPATH%", "TWiki", "TWiki");

  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/TWiki/MochiKit/MochiKit.js"></script>'."\n";
  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/TWiki/MochiKit/New.js"></script>'."\n";
  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/TWiki/MochiKit/Visual.js"></script>'."\n";
  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/TWiki/MochiKit/Signal.js"></script>'."\n";
  $SCRIPT_TEXT .=  '<script type="text/javascript" src="'.$url.'/TWiki/MochiKit/DragAndDrop.js"></script>'."\n";
  $SCRIPT_TEXT .=  '<script type="text/javascript" src="'.$url.'/TWiki/MochiKit/Sortable.js"></script>'."\n";

  $SCRIPT_TEXT .=  <<END;
  <script>
// <![CDATA[
    if(typeof(PdfArrange) == 'undefined') {
      PdfArrange = {}
    }

    // PdfArrange.Base

    if(typeof(PdfArrange.Base) == 'undefined') {
     PdfArrange.Base = {}
    }

    PdfArrange.Base.web_list      = new Array();
    PdfArrange.Base.web_topics    = new Array();

    PdfArrange.Base.selected_items    = new Array();

    PdfArrange.Base.edited_topics   = new Array();
    PdfArrange.Base.possible_topics = new Array();

    PdfArrange.Base.edited_topics_n = 0;


    MochiKit.Base.update(PdfArrange.Base, {
    doExport: function() {

        var s = MochiKit.Sortable.Sortable.serialize('thelist2');
        var element = s.split("&");
        var eid_elements = new Array();

        var s = "";

        for(var i = 0; i < element.length; i++) {
            var idx = element[i].lastIndexOf("=");
            var eid = element[i].substr(idx+1);
//            eid_elements.push(eid);
            s = s + eid + ",";
        }


        postform.pagesn.value = s;
        postform.submit();
     },

      hasTopic: function(webName, topicName) {

       for(var i = 0; i<PdfArrange.Base.selected_items.length; i++) {
           if(PdfArrange.Base.selected_items[i] == webName+"_"+topicName)
             return true;
       }

       return false;
      }
    });

    // PdfArrange.Editor 

    if(typeof(PdfArrange.Editor) == 'undefined') {
     PdfArrange.Editor = {}
    }

    PdfArrange.Editor.selected_item = null;


    MochiKit.Base.update(PdfArrange.Editor, {
      closeEditor: function(myform, eid) {
          var elem = PdfArrange.Base.getTopicWithID(eid);
          var text = myform.elements[0].value;

          elem[3] = text;
          replaceChildNodes(\$(eid), PdfArrange.Editor.makeLink(eid, text));

          PdfArrange.Editor.selected_item = null;
      },

      cancelEditor: function(eid) {
          var elem = PdfArrange.Base.getTopicWithID(eid);
          replaceChildNodes(\$(eid), PdfArrange.Editor.makeLink(eid, elem[3]));

          PdfArrange.Editor.selected_item = null;
      },

      undoEditor: function(eid) {
          var form = \$("embededitor");
          var elem = PdfArrange.Base.getTopicWithID(eid);

          form.title.value = elem[4];
      },


      makeEditor: function(eid) {
          if(PdfArrange.Editor.selected_item != null)  {
              PdfArrange.Editor.closeEditor(\$("embededitor"), PdfArrange.Editor.selected_item);
          }

//          if(!PdfArrange.Editor.selected_item) {
          if(1) {

              var elem  = PdfArrange.Base.getTopicWithID(eid);
              var value = elem[3];

              var myform = FORM({"style": "margin: 0px",
                                 "id": "embededitor",
                                 "method": "GET", 
                                 "action": "javascript:void(0)",
                                 "onsubmit": "PdfArrange.Editor.closeEditor(this, '"+eid+"')"},
                                 INPUT({"name": "title", "type": "text", "value": value}),
                                    A({"href":"javascript:void(0)", "onclick": "PdfArrange.Editor.undoEditor('"+eid+"')"}, "undo"),
                                    " | ",
                                    A({"href":"javascript:void(0)", "onclick": "PdfArrange.Editor.cancelEditor('"+eid+"')"}, "cancel"));

              replaceChildNodes(\$(eid), myform);

              myform.title.focus();
              myform.title.select();

              PdfArrange.Editor.selected_item = eid;
          }
      },

      makeLink: function(eid, webName, name) {
          return DIV(null, DIV({"style": "font-size: 10px"}, webName), DIV({"style": "font-size: 14px"},  A({"target": "_new", "href": "/bin/view/"+webName+"/"+name+"?skin=basic"}, name)));
      },

      makeElement: function(eid, webName, name) {
          return LI({"id": eid}, PdfArrange.Editor.makeLink(eid, webName, name));
      }
    });

    function init() {
       var n = 1;
       var thelist2   = \$("thelist2");
       var eid        = "";


END

  my @websList = TWiki::Func::getListOfWebs( "user,public" );
  my $n        = 1;

  my @websExclude = split /,/, TWiki::Func::getPreferencesValue( "REMIXWEBEXCLUDE", "Main");
  my @webs = get_unique([\@websList, \@websExclude ]);


  foreach my $webName (@webs) {
    my @excludeList = split /,/, TWiki::Func::getPreferencesValue( "REMIXTOPICEXCLUDE", "Main" );
    my @topicList   = TWiki::Func::getTopicList($webName);
    my $isinside    = 0;

    $SCRIPT_TEXT .=  ' PdfArrange.Base.web_list.push("'.$webName.'");'."\n";
    $SCRIPT_TEXT .=  ' PdfArrange.Base.web_topics["'.$webName.'"] = new Array();'."\n";

  my @topics = get_unique([\@topicList, \@excludeList ]);

    foreach my $topicName (@topics) {
      $SCRIPT_TEXT .=  '          PdfArrange.Base.web_topics["'.$webName.'"].push(new Array("'.$webName."_".$topicName.'", "'.$topicName.'"));'."\n";
    }
  }

  $SCRIPT_TEXT .=  <<END;
       MochiKit.Sortable.Sortable.create('thelist1',{containment:['thelist1','thelist2'], dropOnEmpty:true, constraint: false});
       MochiKit.Sortable.Sortable.create('thelist2',{containment:['thelist1','thelist2'], dropOnEmpty:true, constraint: false});
    }
// ]]>



function test2() {
  var l = \$("emptyitem");

  if(l.style.display == "block") {
    if(\$("thelist2").childNodes.length == 2)
        l.style.display = "none";
  } else {
    if(\$("thelist2").childNodes.length == 1)
        l.style.display = "block";
  }
}


function select_web(sel) {
  var webName = sel.options[sel.selectedIndex].value;

  checkSelected();

  // destroy sortable list
  MochiKit.Sortable.Sortable.destroy('thelist1');
  MochiKit.Sortable.Sortable.destroy('thelist2');

  var l   = \$("thelist1");

  replaceChildNodes(l);

  // go trough the list
  MochiKit.Base.map(function (elem) {
      var eid = "thelist1_"+elem[0];
      if(!PdfArrange.Base.hasTopic(webName, elem[1]))
        l.appendChild(PdfArrange.Editor.makeElement(eid, webName, elem[1]));
  }, PdfArrange.Base.web_topics[webName]);

  MochiKit.Sortable.Sortable.create('thelist1',{containment:['thelist1','thelist2'], dropOnEmpty:true, constraint: false});
  MochiKit.Sortable.Sortable.create('thelist2',{containment:['thelist1','thelist2'], dropOnEmpty:true, constraint: false,  onUpdate: test2});

}

    function checkSelected() {
        var s = MochiKit.Sortable.Sortable.serialize('thelist2');
        var element = s.split("&");
        PdfArrange.Base.selected_items = new Array();

        for(var i = 0; i < element.length; i++) {
            var idx = element[i].lastIndexOf("=");
            var eid = element[i].substr(idx+1);
            PdfArrange.Base.selected_items.push(eid);
        }
     }


  </script>

  <style type="text/css" media="screen">
    A {
       text-decoration: None;
    }

    ul { 
       border: 1px solid black;
       list-style-type: none;
       padding-left: 0px;
    }

    li {
      border: 1px solid black;
      padding-left: 10px;
      padding-right: 10px;
    }

    .heder { color: red; background-color: yellow}

    .topic { color: black; }

    .title { color: black; background-color: #f0f0f0}
    
  </style>
END

  my $TEXT = <<END;
<!-- start of table -->

<table border="0" style="border: 0px;">

 <tr>
  <td colspan="3">
    <form>
     Select manual:<br/>
     <select onchange="select_web(this)">
END

  foreach (@webs) {
    $TEXT .= '<option value="'.$_.'">'.$_.'</option>'."\n";
  }

$TEXT .= <<END;

     </select>
    </form>
  </td>
 </tr>
 <tr>
  <td valign="top">
   <div style="width: 300px">
    <ul id="thelist1">
    </ul>
   </div>
  </td>

  <td align="center" valign="center" width="100">
    <form name="postform" id="postform" method="POST" action="">
      <input type="hidden" name="step" value="1"/>
      <input type="hidden" name="pagesn" value=""/>
    </form>
<!-- adam hack
    <form method="GET" action="javascript:void(0)" onsubmit="javascript: return false">
      <input type="button" name="left" value="export" onclick="PdfArrange.Base.doExport(); return false;">
    </form>
--> 
  </td>
  <td valign="top">
   <div style="width: 300px">
     <ul id="thelist2">
      <li id="emptyitem" style="display: block"> drag item here </li> 
     </ul>
   </div>
    <form method="GET" action="javascript:void(0)" onsubmit="javascript: return false">
      <input type="button" name="left" value="export" onclick="PdfArrange.Base.doExport(); return false;">
    </form>
  </td>
 </tr>
</table>
END
  
  ## START OF RENDERING
  
  prepare_page($userName, $query, $SCRIPT_TEXT, $TEXT);
}



=pod

=head2 viewArrangeFinish($webName, $userName, $thePathInfo, $query)

Finishing

=cut

sub viewArrangeFinish {
  my( $webName, $userName, $thePathInfo, $query) = @_;

  my $SCRIPT_TEXT = '';

  my $url = TWiki::Func::expandCommonVariables("%PUBURLPATH%", "TWiki", "TWiki");

  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/TWiki/MochiKit/MochiKit.js"></script>'."\n";
  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/TWiki/MochiKit/New.js"></script>'."\n";
  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/TWiki/MochiKit/Visual.js"></script>'."\n";
  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/TWiki/MochiKit/Signal.js"></script>'."\n";
  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/TWiki/MochiKit/DragAndDrop.js"></script>'."\n";
  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/TWiki/MochiKit/Sortable.js"></script>'."\n";
  $SCRIPT_TEXT .= '<script> function checkArchive() { if($("comment").style.display == "none") $("comment").style.display="block"; else $("comment").style.display="none";} function init() {} </script>';

  my $TEXT = '';

  $TEXT .= '<form name="aa" method="POST" action="">';
  $TEXT .= '<input type="hidden" name="pagesn" value="'.$query->param("pagesn").'">';
  $TEXT .= 'Title:<br/><input type="text" name="pdftitle" size="50"> <br/>';
  
  $TEXT .= 'Select cover page: <br/><select name="cover">';
  for my $coverName (TWiki::Func::getTopicList("ManualCover")) {
    if($coverName !~ /^Web.+/ && $coverName !~ /^_.+/) {
        my $s = "";
        $s = "selected" if($coverName eq "Default");

        $TEXT .= '<option value="'.$coverName.'" '.$s.'>'.$coverName.'</option>';   
    }
  }
  $TEXT .= '</select>';
  $TEXT .= '<br/>';

  if(!TWiki::Func::isGuest()) {
      $TEXT .= <<END;
	  <div id="comment" style="display: none">Comment:<br/><textarea name="comment" cols="50" rows="10"></textarea></div>
END
  }

  $TEXT .= <<END;
<input type="hidden" name="pdfheadertopic" value="TWiki.GenPDFExampleHeaderFooterTopic"/>

<br/><br/>
<input type="submit" value="Export as PDF"/>
</form>

END
  prepare_page($userName, $query, $SCRIPT_TEXT, $TEXT);


}

1;

