
package TWiki::Plugins::PloticusPlugin::PlotSettings;

use TWiki::Plugins::PloticusPlugin;

use strict;
use Assert;

sub fromFile{
    my ($class, $web, $topic, $plotName) = @_;
    TWiki::Func::writeDebug( "PloticusPlugin::PlotSettings::fromFile - Creating new PlotSettings Object from file for $web / $topic / $plotName" ) if $debug;
    my $self = {};
    $self->{WEB}   = $web;
    $self->{TOPIC} = $topic;
    $self->{NAME}  = $plotName;
    $self->{TEXT}  = undef;
#    $self->{SETTINGS} = [];

    my $ploticusFile = buildFileName($web, $topic, $plotName);
    $self->{TEXT} = readFile($ploticusFile);
    
    bless ($self, $class);
    return $self;    
}

sub buildFileName{
    my ($web, $topic, $plotName) = @_;
    return TWiki::Func::getPubDir($web) . "/$web/$topic/$plotName.ploticus";
}
sub readFile {
    my $ploticusFile = $_[0];
    TWiki::Func::writeDebug( "PloticusPlugin::PlotSettings::readFile - Reading settings from $ploticusFile" ) if $debug;
    open (my $inFile, $ploticusFile) or return newFile();
    my $content = '';
    {
        local $/;
        $content = <$inFile>;
    }
    TWiki::Func::writeDebug( "PloticusPlugin::PlotSettings::readFile - content:\n$content" ) if $debug;
    if ( $content =~ /#shell|#endshell|\$shellrow|#sql|#load|#write|#endwrite|#cat/ ) {
        $content = <<'END';
#proc annotate
location: 2 6
ellipse: yes
backcolor: red
text:
Security issue!
At least one of the 
following directives was
found in script syntax:
-#shell
-#endshell
-$shellrow
-#sql
-#load
-#write
-#endwrite
-#cat
END
    }
    return $content;
}

sub writeFile{
    my ($web, $topic, $plotName, $text) = @_;
    my $webDir = TWiki::Func::getPubDir($web) . "/$web";
    unless (-e $webDir) { mkdir $webDir };
    unless (-e "$webDir/$topic") { mkdir "$webDir/$topic" };
    my $ploticusFile =  "$webDir/$topic/$plotName.ploticus";
    TWiki::Func::writeDebug( "PloticusPlugin::PlotSettings::writeFile - Writing ---=$text=--- to $ploticusFile" ) if $debug;
    open (OUTFILE, ">", $ploticusFile) or die "Cannot create new Ploticusplot file!";
    TWiki::Func::writeDebug( "PloticusPlugin::PlotSettings::writeFile - Writing ---=$text=--- to $ploticusFile" ) if $debug;
    $text  =~s/<p \/>//g;
    if ( $text =~ /#shell|#endshell|\$shellrow|#sql|#load|#write|#endwrite|#cat/ ) {
        $text = <<'END';
#proc annotate
location: 2 6
ellipse: yes
backcolor: red
text:	
Security issue!
At least one of the 
following directives was
found in script syntax:
-#shell
-#endshell
-$shellrow
-#sql
-#load
-#write
-#endwrite
-#cat
END
    }
    print OUTFILE "$text";
    close OUTFILE;
}

sub newFile{
    TWiki::Func::writeDebug( "PloticusPlugin::PlotSettings::newFile - Creating new default settings" ) if $debug;
    return <<'END';
// simple vertical bars example - replace this with your own plot

#proc areadef
rectangle: 1 1 4 2
xrange: 0 5
yrange: 0 100

#proc xaxis:
stubs: text
Africa
America
Asia
Europe,\nAustralia,\nPacific

#proc yaxis
label: Growth Rate
stubs: inc 20
minortics: yes
minorticinc: 5

#proc getdata
data:
76
54
60
59

#proc bars
lenfield: 1
color: teal
barwidth: 0.2
END
}


sub render{
    my $self = shift;
#    $self->{WEB}   
#    $self->{TOPIC}
#    $self->{NAME} 
#    $self->{TEXT}  
    my $TEXT = $self->{TEXT};
    #$TEXT =~ s:^[ \t]*$:<nop>:mg;
    my $viewTheTopic =
        TWiki::Func::getScriptUrl($self->{WEB}, $self->{TOPIC}, "view" );
    my $viewPluginTopic =
        TWiki::Func::getScriptUrl("TWiki", "PloticusPlugin", "view");
    my $viewPloticusHelp =
        TWiki::Func::getScriptUrl("TWiki", "PloticusHelp", "view");
    return <<END;
*Edit Settings for !$self->{NAME}*
<a name="ploticusplot$self->{NAME}"></a>
<form action="$viewTheTopic#ploticusplot$self->{NAME}" method="post">
<table>
  <tr valign="middle">
    <td><textarea  rows="10" cols="90" name="ploticusPlotSettingsText" >$TEXT</textarea>
    </td>
    <td><input type="submit" value="Save Settings" class="twikiSubmit" /><br>
        <a target="PloticusPlugin" onclick="return launchWindow('TWiki','PloticusPlugin')" href="$viewPluginTopic">PloticusPlugin help</a><br>
        <a target="PloticusHelp" onclick="return launchWindow('TWiki','PloticusHelp')" href="$viewPloticusHelp">Ploticus help</a>
    </td>
  </tr>
</table>
<input type="hidden" name="ploticusPlotName" value="$self->{NAME}" />
<input type="hidden" name="ploticusPlotAction" value="save" />
</form>
END
}

1;
