#ZZContrib for TWiki Collaboration Platform, http://TWiki.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details, published at
# http://www.gnu.org/copyleft/gpl.html

package TWiki::Contrib::LocalizeContrib;

use strict;

use vars qw( $VERSION $RELEASE $SHORTDESCRIPTION );

$VERSION = '$Rev 9716 $';
$RELEASE = 'Dakar';
$SHORTDESCRIPTION = 'This is LocalizeContrib';


use CGI;
use TWiki::Func;
use TWiki::UI::View;
use File::Temp qw/ tempfile /;
use File::Basename qw/basename/;
use File::Copy;
use File::Spec;
use Error qw( :try );
use IO::File;
use Archive::Zip qw( :ERROR_CODES :CONSTANTS );
use Archive::Tar;
use warnings;
use utf8;
use Data::Dumper;
use Locale::PO;
use XML::Writer;
use Getopt::Long;

use Encode;

use JSON;
$JSON::UTF8 = 1;

use List::Compare::Functional qw( get_unique );

#use TWiki::Contrib::GenPDF;


# This should always be $Rev: 9716 $ so that TWiki can determine the checked-in
# status of the plugin. It is used by the build automation tools, so
# you should leave it alone.
$VERSION = '$Rev: 9716 $';

# This is a free-form string you can use to "name" your own plugin version.
# It is *not* used by the build automation tools, but is reported as part
# of the version number in PLUGINDESCRIPTIONS.
$RELEASE = 'Dakar';


## TODO:
## figure this out

my $baseDir = $TWiki::cfg{"InstallDirectory"};

sub _prepare {
    my( $text, $session, $webName, $topicName, $meta, $minimalist) = @_;

    $text = $session->handleCommonTags( $text, $webName, $topicName );
    $text = $session->{renderer}->getRenderedVersion( $text, $webName, $topicName );
    $text =~ s/( ?) *<\/?(nop|noautolink)\/?>\n?/$1/gois;

    return $text;
}


## prepare_page

sub prepare_page {
  my($userName, $query, $SCRIPT_TEXT, $TEXT) = @_;


  my $session = new TWiki($userName, $query);
  my $skin = $session->getSkin();

  my $template = "localize.tmpl";

  my $tmpl = TWiki::Func::readTemplate($template, $skin);

  my( $start, $end , $middle);
  if( $tmpl =~ m/^(.*)%PDFSCRIPT%(.*)%TEXT%(.*)$/s ) {
      $start = $1;
      $middle = $2;
      $end = $3;
  } else {
      $start = $tmpl;
      $middle = '';
      $end = '';
  }

  my $webName   = "Main";
  my $topicName = "WebHome";

  my @args = ( $session, $webName, $topicName, "", 0 );

  my $page = "";

  $session->enterContext( 'header_text' );

  $start = $session->handleCommonTags( $start, $webName, $topicName );
  $start = $session->{renderer}->getRenderedVersion( $start, $webName, $topicName );
  $start =~ s/( ?) *<\/?(nop|noautolink)\/?>\n?/$1/gois;
  $page = _prepare($start, @args);
  $page .= $SCRIPT_TEXT;
  $page .= _prepare($middle, @args);

  $session->leaveContext( 'header_text' );

  $page .= $TEXT;

  $session->enterContext( 'footer_text' );
  $page .= _prepare($end, @args);
  $session->leaveContext( 'footer_text' );

  $session->writeCompletePage( $page, 'view', "text/html" );
}

## methodUploadAttachment

sub methodUploadAttachment {
  my ($attachmentName, $skinName) = @_;

  print "Content-Type: text/html\r\nContent-Encoding: utf8\r\n\r\n";

  print '<html><body><strong>Upload '.$attachmentName.'<br/><form method="POST" action="" enctype="multipart/form-data">';
  print '<input type="hidden" name="method" value="upload_attachment"></td>';
  print '<input type="hidden" name="skinName" value="'.$skinName.'"></td>';
  print '<input type="hidden" name="attName" value="'.$attachmentName.'"></td>';
  print '<table border="0">';
  print '<tr><td><input type="file" name="uploadfile"></td></tr>';
  print '<tr><td><input type="submit" value="Upload">&nbsp;&nbsp;';
  print '<input type="button" value="Cancel" onclick="top.closeAttachmentDialog()"></td></table>';
  print '</form></body></html>';
}

## methodDownloadAttachment

sub methodDownloadAttachment {
  my ($fileName, $skinName) = @_;
  
  my $data = TWiki::Func::readAttachment("TWiki", $skinName, $fileName );

  print "Content-Type: application/download\r\nContent-Length: ".(length($data))."\r\nContent-Transfer-Encoding: binary\r\nContent-Disposition: attachment; filename=$fileName\r\n\r\n";
  print $data;
}

## methodDownloadPo

sub methodDownloadPo {
  my ($fileName) = @_;

  my $abs_path = File::Spec->rel2abs( $fileName, $baseDir."locale/") ;

  if(substr($abs_path, 0, length($baseDir)+7) eq $baseDir."locale/") {
      print "Content-Type: application/download\r\nContent-Transfer-Encoding: binary\r\nContent-Disposition: attachment; filename=$fileName\r\n\r\n";

      open(FILE, $baseDir."locale/$fileName");
      while(<FILE>) {
         print;
       }
      close(FILE);
  }
}

## methodGetAttachmentData

sub methodGetAttachmentData {
  my ($fileName, $skinName) = @_;

  my $data = TWiki::Func::readAttachment("TWiki", $skinName, $fileName );

  my $json = new JSON;
  my $js = $json->objToJson({"text" => $data});

  print "Content-Type: text/html\r\nContent-Encoding: utf8\r\n\r\n";
  print $js;
}

## methodSaveAttachmentData

sub methodSaveAttachmentData {
 my ($fileName, $skinName, $data) = @_;

 my ($tmp_fh, $tmp_filename) = tempfile( "acaXXXXXXXXXXXXX", DIR => "/tmp/", UNLINK => 0);

 open UPLOADFILE, ">$tmp_filename";
 print UPLOADFILE $data;
 close UPLOADFILE;

 TWiki::Func::saveAttachment( "TWiki", $skinName, $fileName ,
                             { file => $tmp_filename});


 print "Content-Type: text/html\r\nContent-Encoding: utf8\r\n\r\n";
 print "{}";
 print $data;
}

## methodUploadAttachmentPost

sub methodUploadAttachmentPost {
 my ($uploadFile, $fileHandler, $attachmentName, $skinName) = @_;

 $uploadFile =~ s/.*[\/\\](.*)/$1/;

 my $upload_filehandle = $fileHandler;

 # this is stupid

 my ($tmp_fh, $tmp_filename) = tempfile( "acaXXXXXXXXXXXXX", DIR => "/tmp/", UNLINK => 1);

 open UPLOADFILE, ">$tmp_filename";
 binmode UPLOADFILE;
 while (<$upload_filehandle>) {
     print UPLOADFILE;
 }

 TWiki::Func::saveAttachment( "TWiki", $skinName, $attachmentName ,
                              { file => $tmp_filename});

 close UPLOADFILE;

 print "Content-Type: text/html\r\nContent-Encoding: utf8\r\n\r\n";
 print '<html><body><script>top.closeAttachmentDialog()</script></body></html>';
}


## methodRenameAttachment

sub methodRenameAttachment {
  my ($js) = @_;

  print "Content-Type: text/html\r\nContent-Encoding: utf8\r\n\r\n";
  print "{}";
  my $json = new JSON;
  my $obj = $json->jsonToObj($js);

  TWiki::Func::moveAttachment("TWiki", $obj->{"skin_name"}, $obj->{"old_name"}, "TWiki", $obj->{"skin_name"}, $obj->{"new_name"});
}


## methodRemoveAttachment

sub methodRemoveAttachment {
  my ($skinName, $attachmentName) = @_;

  print "Content-Type: text/html\r\nContent-Encoding: utf8\r\n\r\n";
  print "{}";

  TWiki::Func::moveAttachment("TWiki", $skinName, $attachmentName, "Trash", $skinName);
}

## methodCreateSkin

sub methodCreateSkin {
  my ($fileName, $skinName) = @_;

  $fileName =~ /(.*)\.po/;
  my $lang = $1;

  print "Content-Type: text/html\r\nContent-Encoding: utf8\r\n\r\n";
  my ($meta, $text) = TWiki::Func::readTopic( "TWiki", ucfirst($skinName)."Skin" );

  if(!TWiki::Func::topicExists("TWiki", ucfirst($skinName)."Skin".$lang)) {
      my $oops = TWiki::Func::saveTopicText( "TWiki", ucfirst($skinName)."Skin".$lang, $text, "1" ); 
  }
  my @attachments = $meta->find('FILEATTACHMENT');

  foreach my $att (@attachments) {
      my $data = TWiki::Func::readAttachment("TWiki", ucfirst($skinName)."Skin", $att->{name} );
      my ($tmp_fh, $tmp_filename) = tempfile( "acoXXXXXXXXXXXXX", DIR => "/tmp/", UNLINK => 1);
      print $tmp_fh $data;
      TWiki::Func::saveAttachment( "TWiki", ucfirst($skinName)."Skin".$lang, $att->{name} ,
	                          { file => $tmp_filename, size => length $data, filesize => length $data});
      close $tmp_fh;
  }

  print "{}";

}

## methodCreateLanguage

sub methodCreateLanguage {
  my ($lang) = @_;

 if($lang =~ /^[\-\w]+$/) {
    my $abs_path = File::Spec->rel2abs( $lang, $baseDir."locale/") ;

    if(substr($abs_path, 0, length($baseDir)+7) eq $baseDir."locale/") {
      copy($baseDir."locale/TWiki.pot", $baseDir."locale/".$lang.".po");
      print "Content-Type: text/html\r\nContent-Encoding: utf8\r\n\r\n";
      print "{}";
    }
 }

}

## methodGetAttachments

sub methodGetAttachments {
  my ($fileName, $skinName) = @_;

  $fileName =~ /(.*)\.po/;
  my $lang = $1;

  print "Content-Type: text/html\r\nContent-Encoding: utf8\r\n\r\n";
  my $tm = "";

  $tm = $lang if $lang ne "en";
  my ($a, $b) = TWiki::Func::readTopic("TWiki", ucfirst($skinName)."Skin".$tm);

   my $bb = $a->{"FILEATTACHMENT"};

  my @elems;

  foreach my $att (@$bb) {
     push(@elems, {"name" => $att->{"name"}, "size" => $att->{"size"}});
  }
  ## name, size, path, date

  my $json = new JSON;
  my $tm = "";
  $tm = $lang if($lang ne "en");
  my $js = $json->objToJson({"skin_name" => ucfirst($skinName)."Skin".$tm, "attachments" => \@elems});

 print $js;
}

## methodSaveData

sub methodSaveData {
  my ($js) = @_;

  my $json = new JSON;
  my $elems;

  my $obj = $json->jsonToObj($js);

  print "Content-Type: text/html\r\n\r\n";

  my $abs_path = File::Spec->rel2abs( $obj->{"filename"}, $baseDir."locale/") ;

  return if(substr($abs_path, 0, length($baseDir)+7) ne $baseDir."locale/"); 

  my $pohash_local = Locale::PO->load_file_ashash($baseDir."locale/".$obj->{"filename"});

  my $pohash = TWiki::Func::getSessionValue("localize_data_pohash");
  my $pohash_length = TWiki::Func::getSessionValue("localize_data_pohash_length");

  my $desc = $obj->{"description"};
  $desc =~ s/\n/\\n/g;
  #push @$elems, bless({"msgid" => '""', "msgstr" => encode("utf8", $desc)},  'Locale::PO');
  push @$elems, bless({"msgid" => '""', "msgstr" =>  $desc},  'Locale::PO');

  foreach my $itm (@$pohash) {
      $itm->{"reference"} = $pohash_local->{$itm->{"msgid"}}->{"reference"};
      $itm->{"msgstr"}    = encode("utf8", $itm->{"msgstr"}); 
      $itm->{"msgid"}     = encode("utf8", $itm->{"msgid"}); 
      $itm->{"comment"}   = encode("utf8", $itm->{"comment"}); 
      push @$elems, bless ($itm, "Locale::PO");    
  }

  Locale::PO->save_file_fromarray($baseDir."locale/".$obj->{"filename"}, $elems);
  #Locale::PO->save_file_fromarray("/tmp/test.po", $elems);

  print "{}";
  return;
}

## methodSaveChange

sub methodSaveChange {
  my ($js) = @_;

  my $json = new JSON;

  my $pohash = TWiki::Func::getSessionValue("localize_data_pohash");
  my $pohash_length = TWiki::Func::getSessionValue("localize_data_pohash_length");

  my $obj = $json->jsonToObj($js); 

  print "Content-Type: text/html\r\n\r\n";
  print "{}";

  @$pohash[$obj->{"item"}] = {"msgid" => @$pohash[$obj->{"item"}]->{'msgid'}, "comment" => $obj->{'comment'},"msgstr" => '"'.$obj->{'msgstr'}.'"', "fuzzy" => $obj->{"fuzzy"}};

  TWiki::Func::setSessionValue("localize_data_pohash", $pohash);
}

## methodGetDataPart

sub methodGetDataPart {
  my ($js) = @_;

  my $json = new JSON;

  my $obj = $json->jsonToObj($js);

  my $pohash = TWiki::Func::getSessionValue("localize_data_pohash");
  my $pohash_length = TWiki::Func::getSessionValue("localize_data_pohash_length");

  print "Content-Type: text/html\r\nContent-Encoding: utf8\r\n\r\n";

  my $n = $obj->{"continue_from"};

  my $offset = 100;
  my $isEnd = 0;

  if($n + $offset >= $pohash_length) {
     $offset = $pohash_length - $n;
     $isEnd = 1;
  }
  
  my $i = $n;
  my @elemsmall;

  while($i < $n+$offset) {
     push(@elemsmall, @$pohash[$i]);
    $i += 1;
   }

  my $js = $json->objToJson({is_end => $isEnd, stopped_at => $n+$offset, terms => \@elemsmall}, {pretty => 1, indent => 2});

 print $js;
}

## methodGetData

sub methodGetData {
  my ($fileName) = @_;
  my $json = new JSON;

  print "Content-Type: text/html\r\nContent-Encoding: utf8\r\n\r\n";

  my $abs_path = File::Spec->rel2abs( $fileName, $baseDir."locale/") ;

  return if(substr($abs_path, 0,  length($baseDir)+7) ne $baseDir."locale/");
  my $pohash = Locale::PO->load_file_asarray($baseDir."locale/$fileName");

  my $desc = "";
  my @elems;
  my $n = 0;
  my $isOk = 1;

  while($isOk) {
       my $elem = @$pohash[$n];
       if(!$elem) {
          $isOk = 0; 
       } else {
       if($elem->{"msgid"} eq '""') {
           $desc = $elem->msgstr;
       } else {
          push(@elems, {"msgid"   => decode("utf8", $elem->msgid) || '""',
	                "comment" => decode("utf8", $elem->comment) || '',
			"msgstr"  => decode("utf8", $elem->msgstr) || '""',
			"fuzzy"   => $elem->fuzzy || 0});
        }
     }
     $n += 1;
 }

  TWiki::Func::setSessionValue("localize_data_pohash", \@elems);
  TWiki::Func::setSessionValue("localize_data_pohash_length", $#elems + 1);

  my @elemsmall;
  $n = 0;
  while($n < 100) {
     push(@elemsmall, $elems[$n]);
     $n = $n+1;
  }

  my $js = $json->objToJson({total_terms => $#elems, stopped_at => 100, terms => \@elemsmall, desc => $desc}, {pretty => 1, indent => 2});
  print $js;

}

## methodGetSkinList

sub methodGetSkinList {
  my ($fileName) = @_;
  my $json = new JSON;

  my @skins = glob($baseDir."templates/view.*.tmpl");
  my @skinElements;

  $fileName =~ /(.*)\.po/;
  my $lang = $1;

  foreach my $skinName (@skins) {
     if($skinName =~ /.*view\.(.+)\.tmpl/) {
       my $t = $1;
       my $tmpname = ucfirst($t)."Skin";
       $tmpname .= $lang if($lang ne "en");

       push(@skinElements, {name => $t, exists => TWiki::Func::topicExists("TWiki", $tmpname) || 0});
     }
  }

  print "Content-Type: text/html\r\nContent-Encoding: utf8\r\n\r\n";

  my $js = $json->objToJson({skin_elements => \@skinElements}, {pretty => 1, indent => 2});

  print $js;
}


## methodGetLanguages

sub methodGetLanguages {
  my $json = new JSON;

  opendir(DIR, $baseDir."locale/");
  my @files = grep(/\.po$/,readdir(DIR));
  closedir(DIR);

  my @languages ;

  foreach my $fileName  (@files) {
      my (undef, $tfile) = tempfile("xsXXXXXXXXXXXXXXXX", DIR => "/tmp/", OPEN => 0, UNLINK => 0);
      system("/usr/bin/msgfmt --statistics --output=/dev/null ".$baseDir."locale/$fileName &> $tfile ");
      open(FL, $tfile);
      my $line;

      my ($translatedMessages, $untranslatedMessages, $fuzzyMessages) = (0, 0, 0);

      while($line = <FL>) {
        $translatedMessages = $1 if($line =~ /(\d+) translated messages/);
        $untranslatedMessages = $1 if($line =~ /(\d+) untranslated messages/);
        $fuzzyMessages = $1 if($line =~ /(\d+) fuzzy translations/);
      }

      my $k = $untranslatedMessages+$fuzzyMessages+$translatedMessages;

     
      push(@languages, { "filename"     => $fileName, 
                         "translated"   => $translatedMessages,
			 "untranslated" => $untranslatedMessages,
			 "fuzzy"        => $fuzzyMessages});
      close(FL);

  }  
  my $js = $json->objToJson({packets => \@languages}, {pretty => 1, indent => 2});

  print "Content-Type: text/html\r\n\r\n";
  print $js;
}

sub editPOFile {
  my( $webName, $userName, $thePathInfo, $query) = @_;

  my $SCRIPT_TEXT = '';

  my $url = "";
  #my $url = TWiki::Func::expandCommonVariables("%PUBURLPATH%", "TWiki", "TWiki");

  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/pub/TWiki/MochiKit/MochiKit.js"></script>'."\n";
  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/pub/TWiki/MochiKit/New.js"></script>'."\n";
  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/pub/TWiki/MochiKit/Visual.js"></script>'."\n";
  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/pub/TWiki/MochiKit/Signal.js"></script>'."\n";
  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/pub/TWiki/MochiKit/DragAndDrop.js"></script>'."\n";

  my $urlBase =  TWiki::Func::getScriptUrl("", "", "localize");
  $SCRIPT_TEXT .= <<SCRIPTEND;
<script>

if(typeof(LocalizeContrib) == 'undefined') {
  LocalizeContrib = {};
}

LocalizeContrib.termList = new Array();
LocalizeContrib.isBusy   = false;
LocalizeContrib.isModified = false;
LocalizeContrib.isModifiedGlobal = false;
LocalizeContrib.numTotalTerms = 0;
LocalizeContrib.currentLanguage = null;
LocalizeContrib.currentlyOpen = 0;

if(typeof(LocalizeContrib.Base) == 'undefined') {
  LocalizeContrib.Base = {};
}

LocalizeContrib.Base.urlBase = "$urlBase";


MochiKit.Base.update(LocalizeContrib.Base, {
  init: function() {
     \$("step2").style.display="none";
     \$("step3").style.display="none";
     \$("step4").style.display="none";
  },

  setTab: function(tabNumber) {

      if(LocalizeContrib.isBusy) {
         alert("Please wait...");
         return;
      }


      if(!LocalizeContrib.currentLanguage && tabNumber != 1) {
          alert("Select translation file first!");
	  return;
      }

      if(tabNumber == 1) {
        LocalizeContrib.Lang.init();
      }

      if(LocalizeContrib.currentLanguage && LocalizeContrib.termList == null) {
        if(tabNumber == 2 || tabNumber == 4)
           LocalizeContrib.Lang._selectLanguageAndLoad(LocalizeContrib.currentLanguage);
      }

      if(tabNumber == 3 && LocalizeContrib.Skin.skinList == null) {
         var d = MochiKit.Async.loadJSONDoc(LocalizeContrib.Base.urlBase+"?method=get_skin_list&filename="+LocalizeContrib.currentLanguage);
         LocalizeContrib.Base.showNotify("Please wait while loading skin list.");
          d.addErrback(function() { alert("ERROR! Could not read that file!"); });
          d.addCallback(function(res) {
               LocalizeContrib.Skin.skinList = res.skin_elements;
	       LocalizeContrib.Base.showNotify(null);

	       LocalizeContrib.Skin.buildSkinOptions();
	  });

      }
    
      \$("block1").style.display="none";
      \$("block2").style.display="none";
      \$("block3").style.display="none";
      \$("block4").style.display="none";


      \$("block"+tabNumber).style.display="block";

      \$("step1").style.backgroundColor="rgb(255, 194, 14)";
      \$("step1").style.border="1px solid black";
      \$("step2").style.backgroundColor="rgb(255, 194, 14)";
      \$("step2").style.border="1px solid black";
      \$("step3").style.backgroundColor="rgb(255, 194, 14)";
      \$("step3").style.border="1px solid black";
      \$("step4").style.backgroundColor="rgb(255, 194, 14)";
      \$("step4").style.border="1px solid black";

      \$("step"+tabNumber).style.backgroundColor="white";
      \$("step"+tabNumber).style.borderTop="1px solid black";
      \$("step"+tabNumber).style.borderLeft="1px solid black";
      \$("step"+tabNumber).style.borderRight="1px solid black";
      \$("step"+tabNumber).style.borderBottom="2px solid white";
      \$("step"+tabNumber).style.zIndex=10;
  },

  showNotify: function(message) {
    var msg;

    if(message) 
      msg = DIV({"style": "color: white; background-color: #ff7f00;padding:5px;"}, message);
    else
      msg = null;

    MochiKit.DOM.replaceChildNodes(\$("notifier"), msg);
  },

  becomeDirty: function() {
    LocalizeContrib.isModified       = true;
    LocalizeContrib.isModifiedGlobal = true;
  },

  _unquote: function(s) {
     var reg    = new RegExp('"(.*)"', "i");
     var mtch   = null;

     mtch = s.match(reg);
     if(mtch)
        return mtch[1];

     return s;
  }



});


if(typeof(LocalizeContrib.Lang) == 'undefined') {
  LocalizeContrib.Lang = {};
}

LocalizeContrib.Lang.langList = null;


MochiKit.Base.update(LocalizeContrib.Lang, {
  init: function() {
     MochiKit.DOM.replaceChildNodes(\$("block1"), 
       DIV({"style": "width: 300px; position:absolute;top:-80px;left:220px;padding:5px;background-color: #ff7f00; color:white"}, "Loading data! Please wait...")
     );


     var d = MochiKit.Async.loadJSONDoc(LocalizeContrib.Base.urlBase+"?method=get_languages");

     d.addErrback(function() { alert("ERROR! Could not read list of available languages!"); });
     d.addCallback(function(res) {
        var elements = new Array();

        LocalizeContrib.Lang.langList = res.packets;

        MochiKit.Base.map(function(elem) {
	   var k = elem.translated+elem.untranslated+elem.fuzzy;
	   var translatedPercentage = elem.translated/k;
	   var langId = elem.filename.replace("-", "_").replace(".", "_");
	   elements.push(TR({"id": "lang_"+langId},
                         TD(null, A({"href": "#", "onclick": "LocalizeContrib.Lang.selectLanguage('"+elem.filename+"')"}, elem.filename)),
			 TD({"align": "center"}, elem.translated),
			 TD({"align": "center"}, elem.untranslated),
			 TD({"align": "center"}, elem.fuzzy),
			 TD({"align": "left", "width": "180"}, 
			      DIV({"style": "float: left; height: 10px; background-color: green; width: "+(150*elem.translated/k)+"px"}, 
			      " "),
			      DIV({"style": "float: left; height: 10px; background-color: red; width: "+(150*elem.untranslated/k)+"px"}, 
			      " "),
			      DIV({"style": "float: left; height: 10px; background-color: blue; width: "+(150*elem.fuzzy/k)+"px"}, 
			      " ")
                          ),
			 TD({"align": "left"}, A({"href": LocalizeContrib.Base.urlBase+"?method=download_po&filename="+elem.filename, "onclick": "return LocalizeContrib.Lang.downloadPO('"+elem.filename+"')"}, "download"))
	               ));
	}, res.packets);

	MochiKit.DOM.replaceChildNodes(\$("block1"), 
	    DIV({"id": "block1container", "style": "position: absolute"}),
	    TABLE({"border": 0, "width": "770px"},
	      THEAD(null,
	      TR(null,
	        TH({"align": "left"}, "Translation file"),
		TH({"align": "center"}, "Translated"),
		TH({"align": "center"}, "Untranslated"),
		TH({"align": "center"}, "Fuzzy"),
		TH({"align": "left"}, "% translated"),
		TH({"align": "left"}, "")
	      )),
	      TBODY(null, elements)),
	    DIV({"style": "padding-top: 20px"},
              FORM({"method": "GET", "action": "#", "onsubmit": "return false"}, 
		STRONG(null, "New translation"), BR(),
	       TABLE({"border": "0"},
		 TBODY(null,
		  TR(null,
		   TD(null, "Name: "),
		   TD(null, INPUT({"type": "text", "name": "lang", "id":"newtranslationlang"})),
		   TD(null, INPUT({"type": "submit", "value": "Create new translation", "onclick": "LocalizeContrib.Lang.createNewTranslation()"}))
		  )
		 )
	       )
	      )
	    )
	);
     });



  },

  _transformLangName: function (name) {
      return name.replace("-", "_").replace(".", "_");
  },

  createNewTranslation: function() {
      var lang = \$("newtranslationlang").value;

/*      if(!lang.match(new RegExp("^[\-\w]+\$"))) {
         alert("Wrong language format!");
	 return;
      }
*/

      LocalizeContrib.Base.showNotify("Please wait while creating new translation.");

      var d = MochiKit.Async.loadJSONDoc(LocalizeContrib.Base.urlBase+"?method=create_language&lang="+lang);

      d.addErrback(function() { LocalizeContrib.Base.showNotify(null); alert("ERROR! Could not create new language!"); });
      d.addCallback(function() { LocalizeContrib.Base.showNotify(null); init(); });
      return d;
  },

 _selectLanguage: function (lang) {
    LocalizeContrib.currentLanguage = lang;
    LocalizeContrib.termList = null;
    LocalizeContrib.isModifiedGlobal = false;

    \$("step2").style.display="block";
    \$("step3").style.display="block";
    \$("step4").style.display="block";
        MochiKit.DOM.replaceChildNodes(\$("step2"), A({"href": "javascript:void(0)", "onclick": "LocalizeContrib.Base.setTab(2)"},STRONG(null, "TRANSLATE ",MochiKit.DOM.createDOM("SMALL", null,"("+LocalizeContrib.currentLanguage+")"),"")));
        MochiKit.DOM.replaceChildNodes(\$("step3"), A({"href": "javascript:void(0)", "onclick": "LocalizeContrib.Base.setTab(3)"},STRONG(null, "IMAGES & CSS ",MochiKit.DOM.createDOM("SMALL", null,"("+LocalizeContrib.currentLanguage+")"),"")));
        MochiKit.DOM.replaceChildNodes(\$("step4"), A({"href": "javascript:void(0)", "onclick": "LocalizeContrib.Base.setTab(4)"},STRONG(null, "SETTINGS ",MochiKit.DOM.createDOM("SMALL", null,"("+LocalizeContrib.currentLanguage+")"),"")));

     MochiKit.Base.map(function(elem) { \$("lang_"+LocalizeContrib.Lang._transformLangName(elem.filename)).style.backgroundColor="white"; }, LocalizeContrib.Lang.langList);                 \$("lang_"+LocalizeContrib.Lang._transformLangName(LocalizeContrib.currentLanguage)).style.backgroundColor="#ff7f00"; 

     MochiKit.DOM.replaceChildNodes(\$("termlist"));
     if(\$("formdesc"))
       \$("formdesc").value = "";
     LocalizeContrib.Skin.skinList = null;
  },

 selectLanguage: function(lang) {

     if(LocalizeContrib.isModifiedGlobal) {
        if(confirm("Do you want to save changes?")) {
	  var o = LocalizeContrib.Editor.sendChanges();
	  o.addCallback(function() { _selectLanguage(lang); });

          return;	
	} 
     }

     LocalizeContrib.Lang._selectLanguage(lang);
  },

  _selectLanguageAndLoad: function(lang) {
     var d = MochiKit.Async.loadJSONDoc(LocalizeContrib.Base.urlBase+"?method=get_data&filename="+lang);

     d.addErrback(function() { alert("ERROR! Could not read that file!"); });
     d.addCallback(function(res) {
	LocalizeContrib.currentLanguage = lang;
        LocalizeContrib.termList        = res.terms;   
	LocalizeContrib.numTotalTerms   = res.total_terms;

       //\$("formdesc").value = escapeHTML(res.desc);
       //\$("formdesc").value = res.desc.replace("\\\\n", "\\n", "g");

       var desc = res.desc;
       while(desc.indexOf("\\\\n") != -1) {
           desc = desc.replace("\\\\n", "\\n", "gm");
       }

/*
       THIS DOES NOT WORK ON NON FIREFOX BROWSERS?! ?! ?!
       \$("formdesc").value = \$("formdesc").value.replace("\\\\n", "\\n", "gm");
*/
       \$("formdesc").value = desc;

        MochiKit.Async.callLater(0, function() { LocalizeContrib.Lang.continueLoading(res.stopped_at); });

	var n = (res.stopped_at / LocalizeContrib.numTotalTerms)*100;
        LocalizeContrib.Base.showNotify("Please wait while loading data ("+n.toFixed(0)+" %).");
     });

     LocalizeContrib.Base.showNotify("Please wait while loading data (0 %).");
  },

  continueLoading: function(stopped_at) {
     var s = MochiKit.Base.serializeJSON({"continue_from": stopped_at});

     var d = MochiKit.Async.loadJSONDoc(LocalizeContrib.Base.urlBase+"?method=get_data_part&json="+urlEncode(s));
     d.addErrback(function() { alert("ERROR! Could not read that file!"); });
     d.addCallback(function(res) {
        if(res.is_end) {
          LocalizeContrib.Lang.finishLoadingLanguage(); 
	} else {
	  for(i = 0; i < res.terms.length; i ++) {
            LocalizeContrib.termList.push(res.terms[i]);
	  }
          MochiKit.Async.callLater(0, function() { LocalizeContrib.Lang.continueLoading(res.stopped_at); });

          var n = (res.stopped_at / LocalizeContrib.numTotalTerms)*100;
          LocalizeContrib.Base.showNotify("Please wait while loading data ("+n.toFixed(0)+" %).");
	}
     });

  },

  finishLoadingLanguage: function() {
     \$("step2").style.display="block";
     \$("step3").style.display="block";
     \$("step4").style.display="block";

      LocalizeContrib.Base.showNotify("Please wait while loading data (100 %).");
    
     MochiKit.Async.callLater(0, function() { 
        LocalizeContrib.isModified = false;
        LocalizeContrib.isModifiedGlobal = false;

        //MochiKit.DOM.replaceChildNodes(\$("step2"), A({"href": "javascript:void(0)", "onclick": "LocalizeContrib.Base.setTab(2)"},STRONG(null, "TRANSLATE ",MochiKit.DOM.createDOM("SMALL", null,"("+LocalizeContrib.currentLanguage+")"),"")));
        //MochiKit.DOM.replaceChildNodes(\$("step3"), A({"href": "javascript:void(0)", "onclick": "LocalizeContrib.Base.setTab(3)"},STRONG(null, "IMAGES & CSS ",MochiKit.DOM.createDOM("SMALL", null,"("+LocalizeContrib.currentLanguage+")"),"")));
        //MochiKit.DOM.replaceChildNodes(\$("step4"), A({"href": "javascript:void(0)", "onclick": "LocalizeContrib.Base.setTab(4)"},STRONG(null, "SETTINGS ",MochiKit.DOM.createDOM("SMALL", null,"("+LocalizeContrib.currentLanguage+")"),"")));


        LocalizeContrib.Editor.showTerms(1);
        LocalizeContrib.Base.setTab(2);
        MochiKit.DOM.replaceChildNodes(\$("block1container"));

        LocalizeContrib.Base.showNotify(null);
    });
  },

  downloadPO: function(lang) {
    if(LocalizeContrib.isModifiedGlobal && lang == LocalizeContrib.currentLanguage) {
      alert("Save the changes first!");
      return false;
    }
    return true;
  }







});


if(typeof(LocalizeContrib.Editor) == 'undefined') {
  LocalizeContrib.Editor = {};
}

MochiKit.Base.update(LocalizeContrib.Editor, {
 showTerms: function(typ) {
    var container = \$("termlist");

    var blocks = new Array();

    var k = 0;

    for(var n = 0; n < LocalizeContrib.termList.length; n++) {
       elem = LocalizeContrib.termList[n];
        if( (typ == 1) || (typ == 4 && elem["msgstr"] != '""') || (typ == 2 && elem["msgstr"] == '""') || (typ==3 && elem["fuzzy"]) ) {

          var color = "white";
          if(k % 2 == 1) 
             color = "#e0e0e0";


          blocks.push(TR({"id": "line_"+n,"bgcolor": color}, LocalizeContrib.Editor.createLine(n, elem)));
	  k += 1;
	}
    }

    MochiKit.DOM.replaceChildNodes(container, TABLE({"border": 0, "width": "780"}, TBODY(null, blocks)));
    LocalizeContrib.Base.showNotify(null);
  },

  openEditor: function(elem_n, elem) {
    var editor = \$("editor");

    LocalizeContrib.currentlyOpen = elem_n;
    editor.style.display    = "block";
    \$("formmsgid").value   = LocalizeContrib.Base._unquote(elem["msgid"]);
    \$("formmsgstr").value  = LocalizeContrib.Base._unquote(elem["msgstr"]);
    \$("formfuzzy").checked = elem["fuzzy"] ==1;
    \$("formcomment").value = LocalizeContrib.Base._unquote(elem["comment"]);

    LocalizeContrib.isModified = false;
  },

  createLine: function(n, elem) {
      return [TD({"valign": "top"}, elem["fuzzy"]?"*":""),
              TD({"valign": "top", "width": "50%"}, A({"href":"#", "onclick": "javascript:LocalizeContrib.Editor.openEditor("+n+", LocalizeContrib.termList["+n+"])"}, LocalizeContrib.Base._unquote(elem["msgid"]))) ,
              TD({"valign": "top", "width": "50%"}, A({"href": "javascript:void(0)", "onclick": "javascript:LocalizeContrib.Editor.openEditor("+n+", LocalizeContrib.termList["+n+"])"}, LocalizeContrib.Base._unquote(elem["msgstr"])))];

  },

  changedFilter: function(sel) {
    LocalizeContrib.Base.showNotify("Loading.Please wait...");

    MochiKit.Async.callLater(0.2, function () { LocalizeContrib.Editor.showTerms(sel); });
  },

  closeEditor: function() {
    var editor = \$("editor");

    editor.style.display = "none";
  },

 _closeEditor2: function() {
       LocalizeContrib.Editor.closeEditor();

       if(LocalizeContrib.isModified)
          return LocalizeContrib.Editor.saveDataAJAX();

       return null;
  },

  closeEditor2: function() {
       if(LocalizeContrib.isModified) {
          if(confirm("Do you want to save changes?")) {
             var a = LocalizeContrib.Editor._closeEditor2();
	     if(a) {
	     a.addCallback(function() {
	       LocalizeContrib.Editor.sendChanges();
	     });
	     }
	     return;
	  }
        }
       LocalizeContrib.Editor._closeEditor2();
  },

  gotoNextTerm: function() {
     var itm    = \$("line_"+LocalizeContrib.currentlyOpen);
     var reg    = new RegExp("^line_(.+)\$", "i");
     var nextId = null;
     var mtch   = null;

//     if(LocalizeContrib.isModified && !confirm("Discard changes?")) return;

     if(itm.nextSibling) {
           mtch = itm.nextSibling.getAttribute("id").match(reg);
           if(mtch)
               nextId = mtch[1];
     }
     LocalizeContrib.Editor.closeEditor();

     if(LocalizeContrib.isModified) {
       var a = LocalizeContrib.Editor.saveDataAJAX();
       if(a) {
	     a.addCallback(function() {
	       LocalizeContrib.Editor.sendChanges();
	     });
       }
     }

     if(nextId)
         LocalizeContrib.Editor.openEditor(nextId, LocalizeContrib.termList[nextId]);
  },

  gotoPreviousTerm: function() {
     var itm    = \$("line_"+LocalizeContrib.currentlyOpen);
     var reg    = new RegExp("^line_(.+)\$", "i");
     var nextId = null;
     var mtch   = null;

//     if(LocalizeContrib.isModified && !confirm("Discard changes?")) return;

     if(itm.previousSibling) {
           mtch = itm.previousSibling.getAttribute("id").match(reg);
           if(mtch)
               nextId = mtch[1];
     }

     if(LocalizeContrib.isModified) {
       var a = LocalizeContrib.Editor.saveDataAJAX();
       if(a) {
	     a.addCallback(function() {
	       LocalizeContrib.Editor.sendChanges();
	     });
       }
     }

     LocalizeContrib.Editor.closeEditor();

     if(nextId)
         LocalizeContrib.Editor.openEditor(nextId, LocalizeContrib.termList[nextId]);
  },

  saveDataAJAX: function() {
      var xreq = getXMLHttpRequest();

      xreq.open("POST", LocalizeContrib.Base.urlBase+"?method=save_change", true);
      xreq.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=utf-8;');

      var s = MochiKit.Base.serializeJSON({"item": LocalizeContrib.currentlyOpen, "msgstr": \$("formmsgstr").value, "comment": \$("formcomment").value, "fuzzy": \$("formfuzzy").checked?1:0});

      LocalizeContrib.Base.showNotify("Saving changes...");
      var d = MochiKit.Async.sendXMLHttpRequest(xreq, "method=save_change&json="+urlEncode(s));
      d.addErrback(function(res) {
        LocalizeContrib.Base.showNotify("ERROR! Could not save data!");
      });
      d.addCallback(function(res) {
        LocalizeContrib.Base.showNotify(null);
      });

      LocalizeContriv.Editor.saveChanges();
      return d;
  },

  saveData: function() {
     LocalizeContrib.termList[LocalizeContrib.currentlyOpen]["msgstr"] = '"'+ \$("formmsgstr").value+'"';
     LocalizeContrib.termList[LocalizeContrib.currentlyOpen]["comment"] = '"'+\$("formcomment").value+'"';
     LocalizeContrib.termList[LocalizeContrib.currentlyOpen]["fuzzy"] = \$("formfuzzy").checked;
  },

  saveChanges: function() {
     var itm    = \$("line_"+LocalizeContrib.currentlyOpen);

     LocalizeContrib.Editor.saveData();
     MochiKit.DOM.replaceChildNodes(itm, LocalizeContrib.Editor.createLine(LocalizeContrib.currentlyOpen, LocalizeContrib.termList[LocalizeContrib.currentlyOpen]));

     LocalizeContrib.Editor.closeEditor(); 
  },

  sendChanges: function() {

      if(LocalizeContrib.isBusy) {
          alert("Please wait...");
	  return;
      }

      var xreq = getXMLHttpRequest();
      xreq.open("POST", LocalizeContrib.Base.urlBase+"?method=save_data", true);
      xreq.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=utf-8;');


      //var s = MochiKit.Base.serializeJSON({"filename": LocalizeContrib.currentLanguage, "terms": LocalizeContrib.termList, "description": \$("formdesc").value});
      var s = MochiKit.Base.serializeJSON({"description": \$("formdesc").value, "filename": LocalizeContrib.currentLanguage});

      var d = MochiKit.Async.sendXMLHttpRequest(xreq, "method=save_data&json="+urlEncode(s));

      d.addCallback(function() {  LocalizeContrib.isBusy = false; LocalizeContrib.isModifiedGlobal = false;});
      //d.addCallback(function() {  MochiKit.DOM.replaceChildNodes(\$("block3container"), "Data saved."); LocalizeContrib.isBusy = false;});
      d.addErrback(function() { alert("ERROR SAVING!"); LocalizeContrib.isBusy = false;});

      // this is wrong
      LocalizeContrib.isBusy = true;
      return d;
  }



});


if(typeof(LocalizeContrib.Skin) == 'undefined') {
  LocalizeContrib.Skin = {};
}

LocalizeContrib.Skin.skinList = null;
LocalizeContrib.Skin.skinName = "";

MochiKit.Base.update(LocalizeContrib.Skin, {

  buildSkinOptions: function() {
      var elemsOptions = new Array();

      MochiKit.Base.map(function(el) {
            var color = "white";
            if(!el["exists"]) color = "#c0c0c0";

            elemsOptions.push(OPTION({"style": "background-color:"+color, "value": el["name"]}, el["name"]));
      }, LocalizeContrib.Skin.skinList);


	 MochiKit.DOM.replaceChildNodes(\$("block3container"), 
	     FORM(null, 
	        STRONG(null, "Skins"), BR(),
	        SELECT({"id": "skinselect", "name": "skins", "onchange": "LocalizeContrib.Skin.onChangeSkin(this)"},
		  OPTION({"value": ""}, "SELECT SKIN"),
                   elemsOptions
	         )
	      ), 
	      DIV({"id": "block3containerfiles"})
	 );
  },

  onChangeSkin: function(frm) {
    var skinselect = \$("skinselect").options[\$("skinselect").selectedIndex].value;

    if(skinselect == "") return;

     var d = MochiKit.Async.loadJSONDoc(LocalizeContrib.Base.urlBase+"?method=get_attachments&lang="+LocalizeContrib.currentLanguage+"&skin="+skinselect);
     d.addCallback(function(res) {
     var elems = new Array();
     var pos = 0;

     LocalizeContrib.Skin.skinName = res.skin_name;

     MochiKit.Base.map(function(el) {
             var editor_option = new Array();

	     if(el["name"].match(new RegExp(".*\.css\$")) || el["name"].match(new RegExp(".*\.js\$"))) {
                editor_option = new Array(A({"href": "javascript:void(0)", "onclick": "LocalizeContrib.Skin.editAttachment("+pos+", '"+el["name"]+"')"}, "edit"), " | ");
	     }

             elems.push(TR({"id": "attach_line_"+pos}, TD(null, A({"target": "new", "href": "/pub/TWiki/"+res.skin_name+"/"+el["name"]}, el["name"])), TD({"align": "right"}, LocalizeContrib.Skin._calculateSize(parseInt(el["size"])), " Kb"), TD({"align": "right"}, editor_option, A({"href": "javascript:void(0)", "onclick": "LocalizeContrib.Skin.renameAttachment("+pos+", '"+el["name"]+"')"}, "rename"), " | ", A({"href": "javascript:void(0)", "onclick": "LocalizeContrib.Skin.reuploadAttachment("+pos+", '"+el["name"]+"')"}, "upload"), " | ", A({"href": "javascript:void(0)", "onclick": "LocalizeContrib.Skin.removeAttachment("+pos+", '"+el["name"]+"')"}, "remove"), " | ", A({"href": LocalizeContrib.Base.urlBase+"?method=download&filename="+el["name"]+"&skin="+res.skin_name}, "download")))  );
	     pos += 1;
	 }, MochiKit.Base.filter(function(el2) {
	    if(el2["name"].toLowerCase().match(new RegExp(".*\.gif\$"))) return true; 
	    if(el2["name"].toLowerCase().match(new RegExp(".*\.png\$"))) return true; 
	    if(el2["name"].toLowerCase().match(new RegExp(".*\.jpg\$"))) return true; 
	    if(el2["name"].toLowerCase().match(new RegExp(".*\.jpeg\$"))) return true; 
	    if(el2["name"].toLowerCase().match(new RegExp(".*\.css\$"))) return true; 
	    if(el2["name"].toLowerCase().match(new RegExp(".*\.js\$"))) return true; 
	    return false;
	 }, res.attachments));

         var els;
         var hasFound = false;

         for(var i = 0; i < LocalizeContrib.Skin.skinList.length; i++) {
             if(skinselect == LocalizeContrib.Skin.skinList[i]["name"] && !LocalizeContrib.Skin.skinList[i]["exists"]) {
	         hasFound = true;
	     }
	 }

         if(hasFound) {
              els = P(null, "Does not exist. Do you want to create it? ", A({"href":"#", "onclick":"LocalizeContrib.Skin.createNewSkin('"+skinselect+"')"}, "Yes"));
         } else {
	      els = TABLE({"border": 0, "width": "770px"}, 
	        THEAD(null,
	         TR(null, 
		   TD(null,  "filename"), 
		   TD({"align":"right"},  "size"),
		   TD(null, "")
		 )), 
                 TBODY(null, TR(null, TD({"colspan": 3}, DIV({"style": "border-bottom: 1px solid black;width:100%;"}, " ")))
		 , elems));
         }

         MochiKit.DOM.replaceChildNodes(\$("block3containerfiles"), els);
         LocalizeContrib.Base.showNotify(null);

     });
     LocalizeContrib.Base.showNotify("Please wait while loading skin data.");
  },

  reuploadAttachment: function(pos, attachmentName) {
     var elPos = elementPosition(\$("attach_line_"+pos));

    if(LocalizeContrib.isBusy) return;
    LocalizeContrib.isBusy = true;

    setElementPosition(\$("block3dialog"), {"x": 130, "y": elPos["y"]-150});
    setDisplayForElement("block", \$("block3dialog"));

    var reuploadEditor = MochiKit.DOM.createDOM("IFRAME",  {"src": LocalizeContrib.Base.urlBase+"?method=upload_attachment&name="+attachmentName+"&skinName="+LocalizeContrib.Skin.skinName,
                                  "frameborder": 0, "width": 300, "height": "150", "scrolling": "no"}
    );

    replaceChildNodes(\$("block3dialog"), reuploadEditor);
  },

  createNewSkin: function(skinName) {
     var d = MochiKit.Async.loadJSONDoc(LocalizeContrib.Base.urlBase+"?method=create_skin&lang="+LocalizeContrib.currentLanguage+"&skin="+skinName);

     d.addCallback(function(res) {
        for(var i = 0; i < LocalizeContrib.Skin.skinList.length; i++) {
         if(LocalizeContrib.Skin.skinList[i]["name"] == skinName) {
	   LocalizeContrib.Skin.skinList[i]["exists"] = 1;
         }
	}
        LocalizeContrib.Skin.buildSkinOptions();
        LocalizeContrib.Skin.onChangeSkin(null); 
        LocalizeContrib.Base.showNotify(null);
     }); 
     LocalizeContrib.Base.showNotify("Please wait creating new skin.");
  },

  closeAttachmentDialog: function() {
    setDisplayForElement("none", \$("block3dialog"));
    LocalizeContrib.isBusy = false;
  },


  renameAttachment: function(pos, attachmentName) {
     var elPos = elementPosition(\$("attach_line_"+pos));


    if(LocalizeContrib.isBusy) return;
    LocalizeContrib.isBusy = true;

    setElementPosition(\$("block3dialog"), {"x": 130, "y": elPos["y"]-220});
    setDisplayForElement("block", \$("block3dialog"));

    var renameEditor = FORM({"onsubmit": "return false"},
       INPUT({"type": "hidden", id: "attachrename_old_name", "value": attachmentName}),
       STRONG(null, "Rename attachment:"), BR(),
       TABLE({"border": 0},
        TBODY(null, 
         TR(null,
	   TD(null, "New name:"),
	   TD(null, INPUT({"type": "text", "size": 20, "id": "attachrename_name", "value": attachmentName})),
	   TD(null, INPUT({"type": "button", "value": "Rename", "onclick": "LocalizeContrib.Skin.doRenameAttachment()"})),
	   TD(null, INPUT({"type": "button", "onclick": "LocalizeContrib.Skin.closeAttachmentDialog()", "value": "Cancel"}))
	 )
	)
       )

    );

    replaceChildNodes(\$("block3dialog"), renameEditor);
  },

  editAttachment: function(pos, attachmentName) {
    var elPos = elementPosition(\$("attach_line_0"));
    var elPos2 = elementPosition(\$("block3"));

    if(LocalizeContrib.isBusy) return;
    LocalizeContrib.isBusy = true;

    var d = MochiKit.Async.loadJSONDoc(LocalizeContrib.Base.urlBase+"?method=get_attachment_data&skin="+LocalizeContrib.Skin.skinName+"&attachment="+attachmentName);
    d.addCallback(function(res) {
       setElementPosition(\$("block3dialog"), {"x": 30, "y": elPos2["y"]});
       setDisplayForElement("block", \$("block3dialog"));

       var attEditor = DIV({"style": "background-color: white"},
            STRONG(null, attachmentName), BR(),
            FORM({"id": "formattachment", "method": "GET", "action": "#", "onsubmit": "return false"},
	    INPUT({"type": "hidden", "name": "skin", "value": LocalizeContrib.Skin.skinName}),
	    INPUT({"type": "hidden", "name": "attachment", "value": attachmentName}),
            TEXTAREA({"name": "content", "cols": 90, "rows": "40"}, res.text),
            BR(),
	    INPUT({"type": "button", "onclick": "LocalizeContrib.Skin.saveAttachment()", "value": "Save changes"})," ",
	    INPUT({"type": "button", "onclick": "LocalizeContrib.Skin.closeAttachmentDialog()", "value": "Cancel"})
       ));

       replaceChildNodes(\$("block3dialog"), attEditor);
       LocalizeContrib.Base.showNotify(null);
    });

    LocalizeContrib.Base.showNotify("Please wait while loading file.");
  },

  saveAttachment: function() {
    var formattachment = \$("formattachment");

    var xreq = getXMLHttpRequest();
    xreq.open("POST", LocalizeContrib.Base.urlBase+"?method=save_attachment_data", true);
    xreq.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=utf-8;');

    var d = MochiKit.Async.sendXMLHttpRequest(xreq, queryString({"method": "save_attachment_data", "skin": formattachment.skin.value, "attachment": formattachment.attachment.value,"data":formattachment.content.value}));
    d.addCallback(function(res) { LocalizeContrib.Base.showNotify(null); LocalizeContrib.Skin.closeAttachmentDialog(); });

    LocalizeContrib.Base.showNotify("Please wait while saving attachment.");

  },

  removeAttachment: function(pos, attachmentName) {
    if(confirm("Delete attachment "+attachmentName+"?")) {
        var d = MochiKit.Async.loadJSONDoc(LocalizeContrib.Base.urlBase+"?method=remove_attachment&skin="+LocalizeContrib.Skin.skinName+"&attachment="+attachmentName);
	d.addCallback(function(res) {
          LocalizeContrib.Skin.onChangeSkin(null);
	});

    }
  },

  doRenameAttachment: function() {
    var old_name = \$("attachrename_old_name").value;
    var new_name = \$("attachrename_name").value;


    var s = MochiKit.Base.serializeJSON({"old_name": old_name, "new_name": new_name, "skin_name": LocalizeContrib.Skin.skinName});

    var d = MochiKit.Async.loadJSONDoc(LocalizeContrib.Base.urlBase, {"method": "rename_attachment", "json": s});

    d.addCallback(function(res) {
          LocalizeContrib.Skin.closeAttachmentDialog();
          LocalizeContrib.Skin.onChangeSkin(null);
   });


  },

  _calculateSize: function(size) {
      return (size/1024).toFixed(2);

  }




});

/**********************************************************************/

//  var numTotalTerms = 0;
//  var currentLanguage  = null;
//  var currentlyOpen    = 0;
//  var isBusy           = false;
//  var isModified       = false;
//  var isModifiedGlobal = false;




function init() {
 LocalizeContrib.Base.init();
 LocalizeContrib.Lang.init();
}
</script>
SCRIPTEND

  $SCRIPT_TEXT .= '<script type="text/javascript" src="'.$url.'/pub/TWiki/MochiKit/Sortable.js"></script>'."\n";

  my $TEXT = "";

#  my $fileName = $query->param("file");
#  my $pohash = Locale::PO->load_file_ashash("/var/www/floss_dev/locale/$fileName");

  my $TEXT = <<END;

  <!-- HEAD -->

  <div id="notifier" style="position: absolute; padding-top:5px; top: 35px; left: 250px">
  </div>

  <div id="step1" style="height:16px;float: left; text-decoration:none;border-bottom:1px solid white;border-left:1px solid black;border-right:1px solid black;border-top:1px solid black;position:absolute;left:30px;top:107px;padding-left: 20px; padding-right: 20px;  padding-right: 20px; padding-top:3px; padding-bottom:5px;background-color: white; margin-right: 20px;z-index:10;">
  <a href="javascript:void(0)" onclick="LocalizeContrib.Base.setTab(1)" ><b>LANGUAGES</b></a>
  </div>
  <div id="step2" style="height:16px;display: none; float: left;border:1px solid black; position:absolute;left:200px;top:107px;padding-left: 20px; padding-right: 20px; padding-top:3px; padding-bottom:5px; background-color:rgb(255, 194, 14); margin-right: 20px;z-index:1;">
  <a href="javascript:void(0)" onclick="LocalizeContrib.Base.setTab(2)"><b>TRANSLATE</b></a>
  </div>
  <div id="step3" style="display: none; height:16px;float: left; position:absolute;left:410px;top:107px;border:1px solid black;padding-left: 20px; padding-right: 20px;  padding-right: 20px; padding-top:3px; padding-bottom:5px;background-color:  rgb(255, 194, 14); margin-right: 20px">
  <a href="javascript:void(0)" onclick="LocalizeContrib.Base.setTab(3)"><b>IMAGES & CSS</b></a>
  /b></a>
  </div>
  <div id="step4" style="display: none; float: left; height:16px;position:absolute;left:630px;top:107px;padding-left: 20px; border:1px solid black;padding-right: 20px;  padding-right: 20px; padding-top:3px; padding-bottom:5px;background-color:  rgb(255, 194, 14); margin-right: 20px">
  <a href="javascript:void(0)" onclick="LocalizeContrib.Base.setTab(4)"><b>SETTINGS (options)</b></a>
  </div>
<div id="www" style="overflow:hidden;margin:0;padding:0;background-color:black;width:805px;left:25px;height:1px;position:absolute;top:132px;z-index:4;"></div>
  <div style="margin-bottom: 20px; clear: both"/>
  <!-- /HEAD -->
END

## BLOCK 1

  $TEXT .= '<div id="block1" style="padding-top: 20px;position:absolute;top:120px;">';
  $TEXT .= '<div style="position:absolute;top:-80px;left:220px;padding:5px;width: 300px; background-color: #ff7f00; color:white"><font color=white>Loading data. Please wait...</font></div>';
  $TEXT .= '</div>';

## BLOCK 2

  $TEXT .= '<div id="block2" style="position:absolute;top:120px;padding-top: 20px; display: none;">';

  $TEXT .= '<div id="editor" style="padding: 10px; margin: 2px; width: 750px; left: 50px; top: 150px; background-color: white; border: 2px solid black; display: none">';
  
  $TEXT .= '<form id="editorform">';
  $TEXT .= '<table border="0">';
  $TEXT .= '<tr><td valign="top">';
  $TEXT .= '<h3>Original string (msgid)</h3>';
  $TEXT .= '<textarea id="formmsgid" name="msgid" cols="60" rows="7"></textarea>';
  $TEXT .= '<h3>Translated string (msgstr)</h3>';
  $TEXT .= '<textarea id="formmsgstr" name="msgstr" cols="60" rows="7" onclick="LocalizeContrib.Base.becomeDirty()"></textarea>';
  $TEXT .= '</td><td valign="top">';

  $TEXT .= '<h3>Comment</h3>';
  $TEXT .= '<textarea id="formcomment" name="comment" cols="25" rows="10" onclick="LocalizeContrib.Base.becomeDirty()"></textarea>';
  $TEXT .= '<br/><input type="checkbox" name="fuzzy" id="formfuzzy" onclick="LocalizeContrib.Base.becomeDirty()"> Fuzzy';

  $TEXT .= '</td></tr>';
  $TEXT .= '<tr><td colspan="2">';

  $TEXT .= '<div style="clear: all ; padding-top: 5px"><div style="float: right"><a href="javascript:void(0)" onclick="LocalizeContrib.Editor.closeEditor2()">CLOSE</a></div>
  <a href="javascript:void(0)" onclick="LocalizeContrib.Editor.gotoPreviousTerm()">&lt;&lt; PREVIOUS</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="javascript:void(0)" onclick="LocalizeContrib.Editor.gotoNextTerm()">NEXT &gt;&gt;</a>
 </div>';

  $TEXT .= '</td></tr>';
  $TEXT .= '</table>';
  $TEXT .= '</form>';
  $TEXT .= '</div>';

  $TEXT .= '<div style="width: 770px">';
#  $TEXT .= '<span style="float: right"><a href="#" onclick="sendChanges()">Save changes</a></span>';
  $TEXT .= '<br><form name="filter">Display: <input type="radio" name="filter" value="All" checked onchange="LocalizeContrib.Editor.changedFilter(1)"/>All&nbsp;&nbsp;&nbsp;<input type="radio" name="filter" value="All" checked onchange="LocalizeContrib.Editor.changedFilter(4)"/>Translated&nbsp;&nbsp;&nbsp; <input type="radio" name="filter" value="2"  onchange="LocalizeContrib.Editor.changedFilter(2)"/>Untranslated &nbsp;&nbsp;&nbsp;<input type="radio" name="filter" value="3"  onchange="LocalizeContrib.Editor.changedFilter(3)" />Fuzzy</form>'; 
  $TEXT .= '</div>';

  $TEXT .= '<div style="border-bottom: 1px solid black; width: 770px; margin-top: 10px; margin-bottom: 5px; "><table border="0" width="770"><tr><td width="15"></td><td><b>Original message</b></td><td><b>Translated string</b></td></tr></table></div>';

  $TEXT .= '<div id="termlist" style="width: 800px; height: 400px; overflow: auto"></div>';
  my $desc = "";

  $TEXT .= '</div>';

  $desc =~ s/\\n/\n/g;

## BLOCK 3

  $TEXT .= '<div id="block3" style="clear:all;position:absolute;top:20px;display: none; padding-top: 20px;z-index:3000;">';
  $TEXT .= '<div id="block3dialog" style="position: absolute;top:20px;display: none;  border: 2px solid black; background-color: white; padding: 20px;z-index:3000;" ></div>';
  $TEXT .= '<div id="block3container" style="position: absolute; top:140px;"></div>';
  $TEXT .= '</div>';

## BLOCK 4

  $TEXT .= '<div id="block4" style="position:absolute;top:120px;display: none; padding-top: 20px">';
  $TEXT .= 'Settings:';
  $TEXT .= '<form method="GET" action="javascript:void(0)">';
  $TEXT .= '<textarea id="formdesc" name="desc" cols="70" rows="20" onclick="LocalizeContrib.Base.becomeDirty()">'.$desc.'</textarea>';
  $TEXT .= '</form>';
  $TEXT .= '</div>';

  prepare_page($userName, $query, $SCRIPT_TEXT, $TEXT);
}


1;

