# Plugin for TWiki Enterprise Collaboration Platform, http://TWiki.org/
#
# Copyright (C) 2015 Alba Power Quality Solutions
# Copyright (C) 2015 Wave Systems Corp.
# Copyright (C) 2015-2021 Peter Thoeny, peter09[at]thoeny.org
# and TWiki Contributors. All Rights Reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. For
# more details read LICENSE in the root of this distribution.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details, published at
# http://www.gnu.org/copyleft/gpl.html
#
# As per the GPL, removal of this notice is prohibited.

package TWiki::Plugins::IfThenActionPlugin::ThenAction::ViewDaemon;
use base 'TWiki::Plugins::IfThenActionPlugin::ThenAction';

use strict;

# =========================
sub new {
    my $class = shift;
    my $this = $class->SUPER::new( @_ );
    $this->writeDebug( "ViewDaemon::new() - constructor" );
    return $this;
}

# =========================
# $this->handleAction( $web, $topic, $text, $meta, $target ) -> $message
#   * $web:    Name of source web
#   * $topic:  Name of source topic
#   * $text:   Text of source topic, possibly undef
#   * $meta:   Metadata of source topic, possibly undef
#   * $target: Target string
# return: $message: Error or normal message
#
sub handleAction {
    my ( $this, $web, $topic, $text, $meta, $target ) = @_;

    # prepare to execute view script
    my $core = $this->{core};
    my $binDir = $core->{BinDir};
    my $scriptSuffix = $TWiki::cfg{ScriptSuffix};
    my $user = TWiki::Func::wikiToUserName( TWiki::Func::getWikiName() );
    require TWiki::Plugins::BackupRestorePlugin::ProcDaemon;

    # let view script run as shell script, delete env vars that make it look like a cgi
    my $SaveGATEWAY_INTERFACE;
    if( $ENV{GATEWAY_INTERFACE} ) {
        $SaveGATEWAY_INTERFACE = $ENV{GATEWAY_INTERFACE};
        delete $ENV{GATEWAY_INTERFACE};
    }
    my $SaveMOD_PERL;
    if( $ENV{MOD_PERL} ) {
        $SaveMOD_PERL = $ENV{MOD_PERL};
        delete $ENV{MOD_PERL};
    }

    # loop through topic list
    my $i = 0;
    foreach my $item ( $this->expandTopics( $web, $topic, $meta, $target ) ) {
        my $tWeb = $item->{w};
        my $tTopic = $item->{t};

        # build daemon command
        my $cmd = "$binDir/view$scriptSuffix topic=$tWeb.$tTopic user=$user";
        $this->writeDebug( "ViewDaemon::handleAction( $web.$topic ) : start new daemon: $cmd" );
        $this->writeLog( "then-action: viewdaemon, topic: $tWeb.$tTopic" );
        require TWiki::Plugins::BackupRestorePlugin::ProcDaemon;
        my $daemon = TWiki::Plugins::BackupRestorePlugin::ProcDaemon->new(
            work_dir     => $binDir,
            child_STDOUT => $core->{WorkDir} . "/p$i-stdout.txt",
            child_STDERR => $core->{WorkDir} . "/p$i-stderr.txt",
            pid_file     => $core->{WorkDir} . "/p$i-pid.txt",
            exec_command => $cmd,
          );

        # fork background daemon process
        my $pid = $daemon->Init();
        $i++;
    }

    # restore environment variables
    $ENV{GATEWAY_INTERFACE} = $SaveGATEWAY_INTERFACE if( $SaveGATEWAY_INTERFACE );
    $ENV{MOD_PERL}          = $SaveMOD_PERL if( $SaveMOD_PERL );

    return '';
}

1;
