# Plugin for TWiki Enterprise Collaboration Platform, http://TWiki.org/
#
# Copyright (C) 2015 Alba Power Quality Solutions
# Copyright (C) 2015 Wave Systems Corp.
# Copyright (C) 2015-2021 Peter Thoeny, peter09[at]thoeny.org
# and TWiki Contributors. All Rights Reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. For
# more details read LICENSE in the root of this distribution.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details, published at
# http://www.gnu.org/copyleft/gpl.html
#
# As per the GPL, removal of this notice is prohibited.

package TWiki::Plugins::IfThenActionPlugin::ThenAction::Touch;
use base 'TWiki::Plugins::IfThenActionPlugin::ThenAction';

use strict;

# =========================
sub new {
    my $class = shift;
    my $this = $class->SUPER::new( @_ );
    $this->writeDebug( "Touch::new() - constructor" );
    return $this;
}

# =========================
# $this->handleAction( $web, $topic, $text, $meta, $target ) -> $message
#   * $web:    Name of source web
#   * $topic:  Name of source topic
#   * $text:   Text of source topic, possibly undef
#   * $meta:   Metadata of source topic, possibly undef
#   * $target: Target string
# return: $message: Error or normal message
#
sub handleAction {
    my ( $this, $web, $topic, $text, $meta, $target ) = @_;

    # loop through topic list
    my $message = '';
    foreach my $item ( $this->expandTopics( $web, $topic, $meta, $target ) ) {
        my $tWeb = $item->{w};
        my $tTopic = $item->{t};

        # read & save topic
        $this->writeDebug( "Touch::handleAction( $web.$topic ) : Read & save '$tWeb.$tTopic'" );
        my( $tMeta, $tText ) = TWiki::Func::readTopic( $tWeb, $tTopic );
        my $permission = TWiki::Func::checkAccessPermission( 'CHANGE', TWiki::Func::getWikiName(),
                                                             $tText, $tTopic, $tWeb, $tMeta );
        if( $tText && $permission ) {
            my $options = { forcenewrevision => 1 };
            my $err = TWiki::Func::saveTopic( $tWeb, $tTopic, $tMeta, $tText, $options );
            if( $err ) {
                $this->writeDebug( " - save error on $tWeb.$tTopic: $err" );
                $this->writeLog( "then-action: touch, topic: $tWeb.$tTopic, error: $err" );
                $message .= '; ' if( $message );
                $message .= "ERROR: Can't save '$tWeb.$tTopic', $err";
            } else {
                $this->writeLog( "then-action: touch, topic: $tWeb.$tTopic" );
            }
        }
    }

    return $message;
}

1;
