# Plugin for TWiki Enterprise Collaboration Platform, http://TWiki.org/
#
# Copyright (C) 2015 Alba Power Quality Solutions
# Copyright (C) 2015 Wave Systems Corp.
# Copyright (C) 2015-2021 Peter Thoeny, peter09[at]thoeny.org
# and TWiki Contributors. All Rights Reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. For
# more details read LICENSE in the root of this distribution.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details, published at
# http://www.gnu.org/copyleft/gpl.html
#
# As per the GPL, removal of this notice is prohibited.

package TWiki::Plugins::IfThenActionPlugin::ThenAction::Email;
use base 'TWiki::Plugins::IfThenActionPlugin::ThenAction';

use strict;

# =========================
sub new {
    my $class = shift;
    my $this = $class->SUPER::new( @_ );
    $this->writeDebug( "Email::new() - constructor" );
    return $this;
}

# =========================
# $this->handleAction( $web, $topic, $text, $meta, $target ) -> $message
#   * $web:    Name of source web
#   * $topic:  Name of source topic
#   * $text:   Text of source topic, possibly undef
#   * $meta:   Metadata of source topic, possibly undef
#   * $target: Target string
# return: $message: Error or normal message
#
sub handleAction {
    my ( $this, $web, $topic, $text, $meta, $target ) = @_;

    # loop through topic list
    my $message = '';
    my $found = 0;
    foreach my $item ( $this->expandTopics( $web, $topic, $meta, $target ) ) {
        my $tWeb = $item->{w};
        my $tTopic = $item->{t};

        # load e-mail template topic, handle common variables, and send e-mail
        $this->writeDebug( "Email::handleAction( $web.$topic ) : Email template '$tWeb.$tTopic'" );
        my( $tMeta, $tText ) = TWiki::Func::readTopic( $tWeb, $tTopic );
        $tText =~ s/.*\%STARTINCLUDE\%\n*//so;
        $tText =~ s/\%STOPINCLUDE\%.*//so;
        $tText =~ s/^\n+//so;
        $tText =~ s/\n+$/\n/so;
        my ( $header, $body ) = split( /\n\n/, $tText, 2 );
        $body = TWiki::Func::expandCommonVariables( $body, $topic, $web, $meta );
        unless( $body ) { 
            $this->writeDebug( " - e-mail template error: E-mail body is missing" );
            return "ERROR: E-mail body is missing in e-mail template '$tWeb.$tTopic'";
        }
        $header =~ s/(^|\n)From:[^\n]*//so;
        $header =~ s/^\n+//so;
        $header =~ s/\n+$//so;
        $header = "From: \%WIKIWEBMASTERNAME\% <\%WIKIWEBMASTER\%>\n$header";
        $header = TWiki::Func::expandCommonVariables( $header, $topic, $web, $meta );
        unless( $header =~ /(^|\n)To:/s && $header =~ /(^|\n)Subject:/s ) {
            $this->writeDebug( " - e-mail template error: 'To' or 'Subject' is missing" );
            return "ERROR: 'To' or 'Subject' is missing in e-mail template '$tWeb.$tTopic'";
        }
        my $found = 1;
        my $err = TWiki::Func::sendEmail( "$header\n\n$body" );
        if( $err ) {
            $this->writeDebug( " - e-mail error on $tWeb.$tTopic: $err" );
            $this->writeLog( "then-action: email, template: $tWeb.$tTopic, error: $err" );
            $message .= '; ' if( $message );
            $message .= "ERROR: Can't send e-mail using template '$tWeb.$tTopic', $err";
        } else {
            $this->writeLog( "then-action: email, template: $tWeb.$tTopic" );
        }
    }
    return $message if( $found );
    return "ERROR: E-mail template topic not found or not specified";
}

1;
