#!/usr/bin/perl -wI.

use integer;

use Assert;
use FakeWikiIF;
use lib ( '../../../..' );
use TWiki::Plugins::GenHTMLAddon::GenHTML;
use CGI;

use HTML;

print "Please ignore 'errors' from CGI and just look for \"Tests passed\"\n";

# test the CGI interface
$query = new CGI("");
$query->param(-name=>'webname', -value=>"Test");
$query->param(-name=>'topic', -value=>"NoTopicYet");
$wif = FakeWikiIF->getInterface($query);
Assert::sEquals(__LINE__, $wif->webName(), "Test");
Assert::sEquals(__LINE__, $wif->topicName(), "NoTopicYet");

# Create a fake web for testing. Note that attachment URLs are cited in
# their rendered form, because the fake wiki interface we use for testing
# doesn't expand them the way real wiki does.
$wif->writeTopic("WebOrder",
		 "WebTopic");
$wif->writeTopic("TopLevel",
		 "Top Level Trial");
$wif->writeTopic("SecondLevel",
		 "Second =\"%ATTACHURL%/here\" Level GoodLinkHere\n");
$wif->writeTopic("AnotherTopLevel",
		 "Another =\"%ATTACHURLPATH%/there\" Top Level BadLinkHere\n");
$wif->writeTopic("Midges",
		 "Midges\n");
$wif->writeTopic("Mosquitos",
		 "Mosquitos\n");
$wif->writeTopic("Clegs",
		 "Clegs are biting flies =\"%ATTACHURL%/cleg-graphic.gif\" \n");
$wif->writeTopic("Excluded",
		 "This topic should not be included, as it isn't selected by the inclusions\n");

# create fake pub data
mkdir "testdata/pub";
mkdir "testdata/pub/Test";
mkdir "testdata/pub/Test/SecondLevel";
open(WF,">testdata/pub/Test/SecondLevel/here") || die;
print WF "Pubs are good";
close(WF);
mkdir "testdata/pub/Test/Clegs";
open(WF,">testdata/pub/Test/Clegs/cleg-graphic.gif") || die;
print WF "Clegs are bad";
close(WF);

# create an appropriate test query
open(WF,">testdata/cgi.dat") || die;
# include files [^E].* and exclude files M.*
print WF "webname=Test\n\ninclusions=%5B%5EE%5D.%2A\nexclusions=M.%2A\naction=Generate%20HTML";
close(WF);

# Run genhtml on the fake web and pub
open(STDOUT,">testdata/results.lst") || die;
open(WF,"<testdata/cgi.dat") || die;
GenHTML::processWeb($wif, new CGI(WF));
close(WF);

# check the right files were created and the wrong ones weren't
Assert::assert(__LINE__, !-f "testdata/pub/Test/HTML/Midges.html");
Assert::assert(__LINE__, !-f "testdata/pub/Test/HTML/Excluded.html");
Assert::assert(__LINE__, !-f "testdata/pub/Test/HTML/Mosquitos.html");
Assert::assert(__LINE__, -f "testdata/pub/Test/HTML/WebOrder.html");
Assert::assert(__LINE__, -f "testdata/pub/Test/HTML/TopLevel.html");
Assert::assert(__LINE__, -f "testdata/pub/Test/HTML/SecondLevel.html");
Assert::assert(__LINE__, -f "testdata/pub/Test/HTML/AnotherTopLevel.html");
Assert::assert(__LINE__, -f "testdata/pub/Test/HTML/Clegs.html");
Assert::assert(__LINE__, -f "testdata/pub/Test/HTML/images/here");
Assert::assert(__LINE__, -f "testdata/pub/Test/HTML/images/cleg-graphic.gif");

# now check file contents of particular files
Assert::fileContains(__LINE__, $wif->webPubDir()."/HTML/TopLevel.html",
"<BODY>Top Level Trial</BODY></HTML>RENDERED");

Assert::fileContains(__LINE__, $wif->webPubDir()."/HTML/SecondLevel.html",
"<BODY>Second =\"images/here\" Level <a href=\"Good.htmlLink\">Here</a></BODY></HTML>RENDERED");

Assert::fileContains(__LINE__, $wif->webPubDir()."/HTML/Clegs.html",
"<BODY>Clegs are biting flies images/cleg-graphic.gif</BODY></HTML>RENDERED");

Assert::fileContains(__LINE__, $wif->webPubDir()."/HTML/AnotherTopLevel.html",
"<BODY>Another =\"images/there\" Top Level BadLink</BODY></HTML> RENDERED");
close(STDOUT);

# Check the progress log contains expected messages
Assert::fileContains(__LINE__, "testdata/results.lst",
"Generating HTML for web <EM>Test</EM>");
Assert::fileContains(__LINE__, "testdata/results.lst",
"<a href=\"testdata/pub/Test/HTML\">testdata/pub/Test/HTML</a> made<br>");
Assert::fileContains(__LINE__, "testdata/results.lst",
"<a href=\"testdata/pub/Test/HTML/images\">testdata/pub/Test/HTML/images</a> made");
Assert::fileContains(__LINE__, "testdata/results.lst",
"<FONT color=red>Failed to copy testdata/pub/Test/AnotherTopLevel/there to testdata/pub/Test/HTML/images/there</FONT>");
Assert::fileContains(__LINE__, "testdata/results.lst",
"Writing <A HREF=\"testdata/pub/Test/HTML/AnotherTopLevel.html\">testdata/pub/Test/HTML/AnotherTopLevel.html</A>");
Assert::fileContains(__LINE__, "testdata/results.lst",
"Skipping excluded topic Midges");
Assert::fileContains(__LINE__, "testdata/results.lst",
"Skipping excluded topic Excluded");
Assert::fileContains(__LINE__, "testdata/results.lst",
"Skipping excluded topic Mosquitos");
Assert::fileContains(__LINE__, "testdata/results.lst",
"Copied testdata/pub/Test/SecondLevel/here to <A HREF=\"testdata/pub/Test/HTML/images/here\">testdata/pub/Test/HTML/images/here</A>");
Assert::fileContains(__LINE__, "testdata/results.lst",
"Copied testdata/pub/Test/Clegs/cleg-graphic.gif to <A HREF=\"testdata/pub/Test/HTML/images/cleg-graphic.gif\">testdata/pub/Test/HTML/images/cleg-graphic.gif</A>");
Assert::fileContains(__LINE__, "testdata/results.lst",
"Writing <A HREF=\"testdata/pub/Test/HTML/SecondLevel.html\">testdata/pub/Test/HTML/SecondLevel.html</A>");
Assert::fileContains(__LINE__, "testdata/results.lst",
"Writing <A HREF=\"testdata/pub/Test/HTML/TopLevel.html\">testdata/pub/Test/HTML/TopLevel.html</A>");
Assert::fileContains(__LINE__, "testdata/results.lst",
"Writing <A HREF=\"testdata/pub/Test/HTML/WebOrder.html\">testdata/pub/Test/HTML/WebOrder.html</A>");

print STDERR "Tests passed\n";
