use strict;
use integer;
use CGI;

# Implementation of wiki interface for testing
{ package FakeWikiIF;

  my $dataDir = "testdata";
  my $pubDir = $dataDir."/pub";
  my $pubUrlPath = $pubDir;
  my $lsCmd = "/bin/ls";

  sub getInterface {
    my ($class, $query) = @_;
    my $this = {};
    $this->{WEBNAME} = $query->param( 'webname' );
    $this->{TOPIC} = $query->param( 'topic' );
    $this = bless($this, $class);

    $ENV{PATH} = "/usr/local/bin:/usr/bin:/bin";
    `rm -rf $dataDir`;
    mkdir $dataDir;
    mkdir $pubDir;
    mkdir $this->webPubDir();
    mkdir "$dataDir/".$this->webName();

    return $this;
  }

  sub webName { my $this = shift; return $this->{WEBNAME}; }
  sub webPubURL { my $this=shift; return $pubUrlPath."/".$this->webName(); }
  sub webPubDir { my $this=shift; return $pubDir."/".$this->webName(); }
  sub webDirList {
    my $this = shift;
    my $wn = $this->webName();
    my $fl = `cd $dataDir/$wn && ls *.txt`;
    $fl =~ s/\.txt//go;
    return split(/\n/, $fl);
  }

  sub topicName {
    my $this = shift;
    return $this->{TOPIC};
  }

  sub setCurrentTopic {
    my $this = shift;
    $this->{TOPIC} = shift;
  }

  sub _readFile {
    my( $name ) = @_;
    my $data = "";
    undef $/; # set to read to EOF
    open( IN_FILE, "<$name" ) || die "Failed to open $name";
    $data = <IN_FILE>;
    $/ = "\n";
    close( IN_FILE );
    return $data;
  }

  sub readTopic {
    my ( $this,$topic ) = @_;
    my $wn = $this->webName();
    return _readFile( "$dataDir/$wn/$topic.txt" );
  }

  sub readTemplate {
    my ($this, $template, $topic) = @_;
    return undef;
  }

  sub writeTopic {
    my ($this, $name, $text) = @_;
    my $wn = $this->webName();
    open(WF,">$dataDir/$wn/$name.txt") || die;
    print WF $text;
    close(WF);
  }

  sub renderText {
    my ($this, $text) = @_;
    return $text." RENDERED";
  }

  sub expandCommonVariables {
    my ($this, $text) = @_;
    my $wpu = $this->webPubURL();
    my $wpd = $this->webPubDir();
    $text =~ s/%ATTACHURL%/$wpu/eog;
    $text =~ s/%ATTACHURLPATH%/$wpd/eog;
    return $text;
  }

  sub getUnsatisfiedLinkTemplate {
    return "(BadLink)Here";
  }

  sub getInternalLinkTemplate {
    return "(Good)(Link)(Here)";
  }
}

1;
