#
# Copyright (C) Motorola 2001 - All rights reserved
#
# Canned interface to TWiki. Provided so that scripts don't have to use
# TWiki::Func everywhere. This makes testing easier and
# significantly improves portability between versions (a new IF can easily
# be written for older versions of TWiki).
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details, published at 
# http://www.gnu.org/copyleft/gpl.html
#
use strict;
use integer;

use TWiki;
use TWiki::Func;

{ package GenHTMLIF;

  # Singleton instance
  my $singleton;

  # Factory method, returns a singleton instance of a TWiki interface
  sub getInterface {
    my ( $class, $query ) = @_;
    my $this;
    if ( $singleton ) {
      $this = $singleton;
    } else {
      $this = {};
      $singleton = $this;
    }
    # Cache the information required to initalise
    $this->{QUERY} = $query; 
    return bless( $this, $class );
  }

  sub webName {
    my $this = shift;
    return $this->{QUERY}->param( 'webname' );
  }

  sub setWeb {
    my ( $this, $web ) = @_;
    return $this->{QUERY}->param( -name=>'webname', -value=>$web );
  }

  # THIS IS NASTY short-circuits TWiki::Func
  sub topicName {
    return $TWiki::topicName;
  }

  sub readTopic {
    my ( $this, $topic ) = @_;
    return TWiki::Func::readTopic( $this->webName(), $topic );
  }

  sub readTemplate {
    my ( $this, $template ) = @_;
    return TWiki::Func::readTemplate( $template );
  }

  sub webDirList {
    my $this = shift;
    return TWiki::Func::getTopicList( $this->webName() );
  }

  sub webPubURL {
    my $this = shift;
    return TWiki::Func::getUrlHost().
      TWiki::Func::getPubUrlPath()."/".$this->webName();
  }

  sub webPubDir {
    my $this = shift;
    return TWiki::Func::getPubDir()."/".$this->webName();
  }

  # Used to set the topic when traversing the web
  # THIS IS NASTY - but I can't find any other reliable way
  # to force TWiki to change topic
  sub setCurrentTopic {
    my ( $this, $topic ) = @_;

    my $thePathInfo = $this->{QUERY}->path_info(); 
    my $theRemoteUser = $this->{QUERY}->remote_user();
    my $theUrl = $this->{QUERY}->url;

    my ( $ntopic, $webName, $scriptUrlPath, $userName ) = 
      &TWiki::initialize( $thePathInfo, $theRemoteUser,
			  $topic, $theUrl, $this->{QUERY} );
  }

  # Returns a pattern that will match the html
  # used by TWiki to represent an unsatisfied link.
  # THIS IS NASTY, but I don't know how else to do it.
  sub getUnsatisfiedLinkTemplate {
    my $this = shift;
    my $t = "!%^&*(){}";# must _not_ exist!
    my $w = $this->webName();
    my $linkFmt = &TWiki::internalLink( "", $w, $t, "TheLink", undef, 1 );
    $linkFmt =~ s/\//\\\//go;
    my $pre = $linkFmt;
    $pre =~ s/TheLink.*//o;
    my $post = $linkFmt;
    $post =~ s/.*TheLink//o;
    $post =~ s/\"[^\"]*\"/\"[^\"]*\"/o;
    $post =~ s/\?/\\?/o;
    return $pre . "(.*?)" . $post;
  }

  # Returns a pattern that will match the html
  # used by TWiki to represent an internal link.
  # THIS IS NASTY, but I don't know how else to do it.
  sub getInternalLinkTemplate {
    my $this = shift;
    my $w = $this->webName();
    my $t = $this->topicName(); # _must_ exist!
    my $linkFmt = &TWiki::internalLink( "", $w, $t, "TheLink", undef, 1 );
    $linkFmt =~ s/$w\/$t/$w\/([^"#]*)([^"]*)/g;
    $linkFmt =~ s/\//\\\//go;
    $linkFmt =~ s/TheLink/(.*?)/go;
    return $linkFmt;
  }

  sub renderText {
    my ( $this, $text ) = @_;
    return TWiki::Func::renderText( $text,
				   $this->webName() );
  }

  sub expandCommonVariables {
    my ( $this, $text ) = @_;
    TWiki::Func::expandCommonVariables( $text,
				       $this->topicName(),
				       $this->webName() );
  }

  sub extractAttr {
    my ( $this, $a ) = @_;
    return TWiki::Func::extractNameValuePair( $a );
  }
}

1;
