#
# Copyright (C) Motorola 2001 - All rights reserved
#
# TWiki extension that adds tags for the generation of tables of contents.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details, published at 
# http://www.gnu.org/copyleft/gpl.html
use CGI;
use File::Copy;

# Generate stand-alone HTML for a TWiki web
{ package GenHTML;

  sub _error {
    my ( $text ) = @_;
    return "<FONT color=red>$text</FONT>";
  }

  # Locate references to files in pub and make sure they get copied
  sub handlePubReferences {
    my ( $au, $text, $wif, $cgi, $copied ) = @_;

    while ( $text =~ m/=\"$au\/([-a-zA-Z0-9_.\/]*)/ ) {
      my $imgname = $1;
      my $src = $wif->webPubDir()."/".$wif->topicName()."/$imgname";
      # Collapse .. in path names
      $src =~ s~[^/]*/../~~go;
      # Strip / and .. from the target name
      $imgname =~ s~/~_~go;
      $imgname =~ s/\.\./_/go;
      my $href = "images\/$imgname";
      $text =~ s/=\"$au\/[-a-zA-Z0-9_.\/]*/=\"$href/;
      if ( !$copied{"$src:$href"} ) {
	my $dest = $wif->webPubDir()."/HTML/$href";
	if ( File::Copy::copy( $src, $dest ) ) {
	  print "\nCopied $src to ";
	  print $cgi->a( {href=>$wif->webPubURL()."/HTML/$href"},
			$dest );
	  $copied{"$src:$href"} = 1;
	} else {
	  print _error( "Failed to copy $src to $dest");
	}
	print $cgi->br();
      }
    }
    return $text;
  }

  sub processTopic {
    my ( $wif, $cgi, $topic, $text, $copied ) = @_;

    # Insert in the template. Could this be done using skins?
    my $tmpl = $wif->readTemplate( "genhtml" );
    if ( $tmpl ) {
      $tmpl = $wif->expandCommonVariables( $tmpl );
      $tmpl =~ s/%TEXT%/$text/o;
      $text = $tmpl;
    } else {
      $text = $cgi->start_html( $topic ) . $text . $cgi->end_html;
    }

    # Do standard formatting stuff
    $text = $wif->expandCommonVariables( $text );
    $text = $wif->renderText( $text );

    # Strip unsatisfied wikiwords
    my $ult = $wif->getUnsatisfiedLinkTemplate();
    $text =~ s/$ult/$1/g;

    # handle pub links
    my $au = $wif->expandCommonVariables( "%ATTACHURL%" );
    $text = handlePubReferences( $au, $text, $wif, $cgi, $copied );
    $au = $wif->expandCommonVariables( "%ATTACHURLPATH%" );
    $text = handlePubReferences( $au, $text, $wif, $cgi, $copied );

    # Modify internal links
    my $ilt = $wif->getInternalLinkTemplate();
    $text =~ s/$ilt/<a href="$1.html$2">$3<\/a>/g;

    # insert .html in internal links
    $text =~ s/(<a href=\"[A-Z0-9_]*)(\#[^\"]*)?\"/$1.html$2\"/gio;

    if ( open( HTML, ">".$wif->webPubDir()."/HTML/$topic.html" )) {
      print "\nWriting ";
      print $cgi->a( {href=>$wif->webPubURL()."/HTML/$topic.html"},
		    $wif->webPubDir()."/HTML/$topic.html" );
      print $cgi->br();
      print HTML $text;
      close( HTML );
    } else {
      print _error( "Could not open ".$wif->webPubDir().
		   "/HTML/$topic.html for write" );
    }
  }

  sub _inSet {
    my ( $topic, @excluded ) = @_;
    my $e;
    foreach $e ( @excluded ) {
      return 1 if ( $e ne "" && $topic =~ /^$e/ );
    }
    return 0;
  }

  sub processWeb {
    my ( $wif, $cgi ) = @_;

    my $inclusions = $cgi->param( 'inclusions' );
    $inclusions = ".*" unless (defined($inclusions));
    my @include = split( /[\r\n]+/, $inclusions );

    my $exclusions = $cgi->param( 'exclusions' );
    my @exclude = split( /[\r\n]+/, $exclusions );

    my $web = $wif->webName();
    my %copied;

    print 'Generating HTML for web ', $cgi->em( $web ), $cgi->p();

    my @topics = $wif->webDirList();
    my $pd = $wif->webPubDir();
    mkdir "$pd", 0777;
    mkdir "$pd/HTML", 0777;
    mkdir "$pd/HTML/images", 0777;
    if ( -d "$pd/HTML" || -d "$pd/HTML/images" ) {
      print "<a href=\"$pd/HTML\">$pd/HTML</a> made<br>\n";
      print "<a href=\"$pd/HTML/images\">$pd/HTML/images</a> made<br>\n";
      my $topic;
      foreach $topic ( @topics ) {
	if ( _inSet( $topic, @include ) && !_inSet( $topic, @exclude )) {
	  $wif->setCurrentTopic( $topic );
	  my $text = $wif->readTopic( $topic );
	  processTopic( $wif, $cgi, $topic, $text, \%copied );
	} else {
	  print "Skipping excluded topic $topic<br>\n";
	}
      }
    } else {
      print _error( "Failed to make directories - check that $pd has write permissions" );
    }
  }

  # MAIN ENTRY POINT
  # TODO: do tag intercepts programmatically
  # TODO: Sort out where the HTML gets created (ftp:?)
  # TODO: Work out how to handle plugin tags that create complex HTML, such
  # as drawings
  # TODO: handle meta-tags
  sub doForm {
    my ( $wif, $cgi ) = @_;

    print $cgi->header;
    print $cgi->start_html( 'Generate HTML for a TWiki Web' );
    print $cgi->h1( 'Generate HTML for a TWiki Web' );
    print $cgi->start_form();
    print "Generate HTML for web ";
    print $cgi->textfield( -name=>'webname', -default=>$wif->webName() );
    print $cgi->p();
    print "Include topics (perl REs, one per line)", $cgi->br();
    print $cgi->textarea( -name=>'inclusions',
			  -default=>".*",
			  -rows=>5,
			  -columns=>60,
			  -label=>'Specify topics to include using Perl regular expressions:' );
    print $cgi->p();
    print "Exclude topics (perl REs, one per line)", $cgi->br();
    print $cgi->textarea( -name=>'exclusions',
			  -default=>"Web.*",
			  -rows=>5,
			  -columns=>60,
			  -label=>'Specify topics to exclude using Perl regular expressions:' );
    print $cgi->p();
    print $cgi->submit( -name=>'action',
		        -value=>'Generate HTML' );
    print $cgi->end_form();

    print $cgi->hr();
    print $cgi->dump();
    print $cgi->hr();

    if ( $cgi->param( 'action' ) eq "Generate HTML" ) {
      #$cgi->reset(); ?
      processWeb( $wif, $cgi );
    }
    print $cgi->end_html();
  }
}

1;
