# ---+ Extensions
# ---++ Execute Plugin
# This is the configuration of the <b>ExecutePlugin</b>.

# **STRING 80**
# Filter applied to parameters of scripts. This filter can be overloaded by individual
# script settings.
$TWiki::cfg{Plugins}{ExecutePlugin}{ScriptFilter} = '[^a-zA-Z0-9_\\-\\+!\\:\\., /\\(\\)\\@]';

# **STRING 80**
# Filter applied to parameters of Perl code. This filter can be overloaded by individual
# script settings.
$TWiki::cfg{Plugins}{ExecutePlugin}{PerlFilter} =   '[^a-zA-Z0-9_\\-\\+!\\:\\., /\\(\\)\\@]';

# **PERL**
# Scripts and Perl code allowed to be executed. Scripts are defined by an array of hashes.
# Each array item has a hash with these keys:
# <ul>  <li> <tt>name</tt> - name of script, such as <tt>'test_results'</tt>; required.
# </li> <li> <tt>type</tt> - script type, set to <tt>'script'</tt> for shell scripts, and <tt>'perl'</tt> for Perl scripts; default is <tt>'script'</tt>.
# </li> <li> <tt>command</tt> - script to execute, with parameters enclosed in percent signs, such as <tt>'ls /export/test-results %date%'</tt>.
# </li> <li> <tt>filter</tt> - a RegularExpression filter applied to user supplied parameters, such as <tt>'[^0-9\-]'</tt>; <br /> default is {Plugins}{ExecutePlugin}{ScriptFilter} setting for scripts, and {Plugins}{ExecutePlugin}{PerlFilter} setting for Perl code.
# </li> </ul>
$TWiki::cfg{Plugins}{ExecutePlugin}{Scripts} = [
 {
  name => 'echo',
  type => 'script',
  command => '/bin/echo "%text%"',
  filter => '[^a-zA-Z0-9_\\- ]',
 },
 {
  name => 'uppercase',
  type => 'perl',
  command => 'return uc("%text%");',
  filter => '[^a-zA-Z0-9_\\-\\+ \\.\\,\\:\\!\\?\\(\\)/]',
 },
];

# **BOOLEAN**
# Debug plugin. See output in data/debug.txt
$TWiki::cfg{Plugins}{ExecutePlugin}{Debug} = 0;

1;
