# Plugin for TWiki Enterprise Collaboration Platform, http://TWiki.org/
#
# Copyright (C) 2006-2011 Peter Thoeny, peter[at]thoeny.org
# Copyright (C) 2008-2011 TWikiContributors
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. For
# more details read LICENSE in the root of this distribution.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# For licensing info read LICENSE file in the TWiki root.

package TWiki::Plugins::EditSyntaxPlugin;

use strict;

our $VERSION = '$Rev: 21399 (2011-06-04) $';
our $RELEASE = '2011-06-04';

# Name of this Plugin, only used in this module
our $pluginName = 'EditSyntaxPlugin';

our $debug;
our $installWeb;

# ================================================================
sub initPlugin
{
    my( $topic, $web, $user, $installweb ) = @_;

    # check for Plugins.pm versions
    if( $TWiki::Plugins::VERSION < 1.026 ) {
        TWiki::Func::writeWarning( "Version mismatch between $pluginName and Plugins.pm" );
        return 0;
    }

    # get debug flag
    $debug = TWiki::Func::getPreferencesFlag( "\U$pluginName\E_DEBUG" );

    $installWeb = $installweb;

    # Plugin correctly initialized
    return 1;
}

# ================================================================
sub beforeEditHandler
{
    # do not uncomment, use $_[0], $_[1]... instead
    ### my ( $text, $topic, $web ) = @_;
    TWiki::Func::writeDebug( "- ${pluginName}::beforeEditHandler( $_[2].$_[1] )" ) if $debug;

    # Bail out if WYSIWYG edit session
    return if TWiki::Func::getContext()->{textareas_hijacked};

    my $editSyntax = TWiki::Func::getPreferencesValue( 'EDITSYNTAX' ) || '';
    $_[0] = _translateText( $_[0], $editSyntax, 'T2X' ) if( $editSyntax );
}

# ================================================================
sub afterEditHandler
{
    # do not uncomment, use $_[0], $_[1]... instead
    ### my ( $text, $topic, $web ) = @_;
    TWiki::Func::writeDebug( "- ${pluginName}::afterEditHandler( $_[2].$_[1] )" ) if $debug;

    # Bail out if WYSIWYG edit session
    return if TWiki::Func::getContext()->{textareas_hijacked};

    my $editSyntax = TWiki::Func::getPreferencesValue( 'EDITSYNTAX' ) || '';
    $_[0] = _translateText( $_[0], $editSyntax, 'X2T' ) if( $editSyntax );
}

# ================================================================
sub _translateText
{
    my ( $text, $editSyntax, $type ) = @_;

    my @rules = _readRegexRules( $editSyntax, $type );
    return $text unless scalar( @rules );
    foreach my $rule (@rules) {
        $rule =~ /^(.*)$/;
        $rule = $1; # FIXME - this is a security hole!
        eval( "\$text =~ $rule;" );
    }
    $text =~ s/_TML_/_EXT_/go;
    return $text;
}

# ================================================================
sub _readRegexRules {
    my ( $editSyntax, $type ) = @_;
    my $text = TWiki::Func::readTopicText( $installWeb, "${editSyntax}EditSyntaxRegex", '', 1 );
    my $regex = '(\/.*?\/.*?\/)( +\#| *$)';
    my @rules =
      map{ s/.*?\* $type\: *$regex.*/s${1}g/; $_ }
      grep{ /\* $type\: *$regex/ }
      split( /[\n\r]+/, $text );
    return @rules;
}

# ================================================================
1;
