# Module of TWiki Enterprise Collaboration Platform, http://TWiki.org/
#
# Copyright (C) 2013-2014 Wave Systems Corp.
# Copyright (C) 2013-2015 Peter Thoeny, peter[at]thoeny.org
# Copyright (C) 2013-2015 TWiki Contributors. All Rights Reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version. For
# more details read LICENSE in the root of this distribution.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# As per the GPL, removal of this notice is prohibited.
#
# This packages subclasses TWiki::Form::FieldDefinition to implement
# the =autocomplete= type

package TWiki::Form::Autocomplete;
use base 'TWiki::Form::ListFieldDefinition';

use strict;

# ========================================================
sub new {
    my $class = shift;
    my $this = $class->SUPER::new( @_ );
    $this->{size} ||= 2;
    return $this;
}

# ========================================================
sub getDefaultValue {
    return '';
}

# ========================================================
sub getOptions {
    my $this = shift;
    return $this->{_options} if $this->{_options};
    my $vals = $this->SUPER::getOptions(@_);
    return $vals;
}

# ========================================================
sub finish {
    my $this = shift;
    $this->SUPER::finish();
}

# ========================================================
sub renderForEdit {
    my( $this, $web, $topic, $value ) = @_;

    my $options = join( ', ', @{$this->getOptions()} );
    require TWiki::Plugins::AutocompletePlugin;
    my $text = TWiki::Plugins::AutocompletePlugin::renderForEdit(
        $this->{name}, $value, $options, $this->{size}, $this->{type}, $this->{parameters}
      );
    return ( '', $text );
}

# ========================================================
1;
