=pod

---+ package TWiki::Plugins::AuthPagePlugin::Validator

This file is the LDAP Validator. Uses parms from TWiki.cfg

To activate this example, copy this file to Validator.pm
#Author : sdetweil@us.ibm.com
#Date   : 5/May/2005
#
#The basic idea is taken from SessionPlugins's logon script.
#The script is modifying ENV{REMOTE_USER} value  after authentication 
#
#
#  This script depends on variables being set in the TWiki.cfg file
#
#
#  LDAP Server Name
#
#$LDAP_Server = 'ourldapserver.company.com';
#
# the LDAP_Server port where secure binds can be done to validate the users password
# 389 (default LDAP port) would send the password over the net in clear text.. 
# 636 (typical secure port) would use SSL to send the password during bind
#
#$LDAP_AuthPort = 636;
#
# we will use the default port for Search
# as searches are done ALL the time in the clear
# this is here for documentation purposes, not hard coded in the code
#
#$LDAP_SearchPort = 389;
#
# this uses the LDAP search function to locate the users distinguished (dn) name
# we do this on the non-secure port (389) cause everything else does it too
#
# this is the base of the LDAP directory to search for this user
# the directory designers/application support team can tell you what this string is for 
# the directory you need to use.
#
#$LDAP_SearchBase   ='ou=some_organization,o=ourcompany.com';
#
# this tells LDAP whether the search is single level 'base' (just in this specific branch)
# of if the search can travers the directory to locate the user 'sub'
#  the choice here depends on the directory implementation and security rules at a particular company
#
#$LDAP_SearchScope  ='sub';  # or 'base'
#
# this is the filter used on the search. As we have only the userid, that is all we can search on
# but how this is coded in the directory will determine this filter string. 
#
# note that the user name is bracketed by %%.. perl will NOT substitute at runtime
# so we have to use a replace function to rebuild the string
#
#$LDAP_SearchFilter ='(&(objectclass=person)(mail=%username%))';
#
# this tells the replace function ->s/mask/data what string the userid should replace in the
# filter above
#
#$LDAP_UserNameMask ='%username%';


=cut

package TWiki::Plugins::AuthPagePlugin::Validator;

use strict;
#use vars qw( $pre_dakar );
use Net::LDAPS; 

BEGIN {
    # Set default current working directory (needed for mod_perl)
    if( $ENV{"SCRIPT_FILENAME"} && $ENV{"SCRIPT_FILENAME"} =~ /^(.+)\/[^\/]+$/ ) {
        chdir $1;
    }
    # Set library paths in @INC, at compile time
#    unshift @INC, '.';
#    require 'setlib.cfg';
}
=pod

---++ StaticMethod validate( $user, $pass, $session )
   * =$user= - username
   * =$pass= - password
   * =$session= - Dakar only - the TWiki session object
Validate the passed username/password pair using TWiki built-in
password handling.

=cut

sub validate {
    my( $username, $password, $session) = @_;
    ## do_login authenticates users from authentication system.
    ## You have to comment the following method if you are not using LDAP 
   my $dn = &ldap_search($username);
   if ($dn ne '') {
       # setup to the server.. if the port is not 389, the it will be sercured
       my $ldap = Net::LDAPS->new($TWiki::LDAP_Server, 
                               port => $TWiki::LDAP_AuthPort) or &mydie();


       # bind with the user DN and password to validate the PW
       my $mesg = $ldap->bind( $dn, password => $password );

       $ldap->unbind;   # take down session
       # process the bind return code, 0 = successful
       if ( $mesg->code ) {
           # FAILURE (bad password)
           return 0; #FAILURE;
       } else {
           # SUCCESS
           return "SUCCESS"; #SUCCESS;
       }
   } else {
       # FAILURE (username doesn't exist)
       return 0; #FAILURE;
   }
}

sub ldap_search {

   # get the username parameter
   my($username) = @_;

   # connect to the server using the non-secure port
   # we will only pass the userid in the clear
   my $ldap = Net::LDAP->new($TWiki::LDAP_Server, # $ldap_server ,
                          port => $TWiki::LDAP_SearchPort
                         ) or &mydie();

   # bind as no user (anonymous)
   my $mesg = $ldap->bind ; 
   if ( $mesg->code ) {
       &mydie($mesg->code);
   }

   # get the filter string from TWiki.cfg
   my $filter = $TWiki::LDAP_SearchFilter;
   # replace the mask with the real user name string
   $filter =~ s/$TWiki::LDAP_UserNameMask/$username/;

   # search directory for this user entry
   $mesg = $ldap->search (
                          base   => $TWiki::LDAP_SearchBase, #$base,
                          scope  => $TWiki::LDAP_SearchScope, #$scope,
                          filter => $filter 
                         );
   # don't need to be connected anymore 
   $ldap->unbind;   # take down session                                                                

   # we assume there is only ONE valid match by email address
   my $dn="" ;
   if ($mesg->count) {
       my $entry = $mesg->entry(0);
       # extract the distinguished name 
       $dn = $entry->dn ;
   }
   return $dn ;
}

sub mydie {
   exit 2; #FAILURE
}

1;

