/*
 * Decompiled with CFR 0.152.
 */
package org.anywikidraw.twiki;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.anywikidraw.any.AbstractDrawingApplet;
import org.anywikidraw.any.DrawingPanel;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.ImageInputFormat;
import org.jhotdraw.draw.ImageOutputFormat;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.gui.DrawingComponent;
import org.jhotdraw.samples.svg.gui.ProgressIndicator;
import org.jhotdraw.samples.svg.gui.ServerAuthenticationException;
import org.jhotdraw.samples.svg.io.ClientHttpRequest;
import org.jhotdraw.samples.svg.io.ImageMapOutputFormat;
import org.jhotdraw.samples.svg.io.SVGOutputFormat;
import org.jhotdraw.samples.svg.io.SVGZInputFormat;
import org.jhotdraw.samples.svg.io.SVGZOutputFormat;

public class TWikiDrawingApplet
extends AbstractDrawingApplet {
    public TWikiDrawingApplet() {
        this.setName(MessageFormat.format("AnyWikiDraw {0} for TWiki", this.getVersion()));
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TWikiDrawingApplet tWikiDrawingApplet = new TWikiDrawingApplet();
                JFrame jFrame = new JFrame(tWikiDrawingApplet.getName());
                jFrame.getContentPane().setLayout(new BorderLayout());
                jFrame.setDefaultCloseOperation(3);
                jFrame.getContentPane().add((Component)tWikiDrawingApplet, "Center");
                jFrame.setSize(400, 400);
                tWikiDrawingApplet.init();
                jFrame.setVisible(true);
            }
        });
    }

    @Override
    protected Drawing createDrawing() {
        DefaultDrawing defaultDrawing = new DefaultDrawing();
        LinkedList<InputFormat> linkedList = new LinkedList<InputFormat>();
        linkedList.add(new SVGZInputFormat());
        linkedList.add(new ImageInputFormat(new SVGImageFigure()));
        linkedList.add(new ImageInputFormat(new SVGImageFigure(), "JPEG", "JPEG", "jpg", 1));
        LinkedList<OutputFormat> linkedList2 = new LinkedList<OutputFormat>();
        linkedList2.add(new SVGOutputFormat());
        linkedList2.add(new SVGZOutputFormat());
        linkedList2.add(new ImageOutputFormat());
        linkedList2.add(new ImageOutputFormat("JPG", "Joint Photographics Experts Group (JPEG)", "jpg", 1));
        linkedList2.add(new ImageOutputFormat("BMP", "Windows Bitmap (BMP)", "bmp", 13));
        defaultDrawing.setInputFormats(linkedList);
        defaultDrawing.setOutputFormats(linkedList2);
        if (this.getParameter("DrawingWidth") != null && this.getParameter("DrawingHeight") != null) {
            try {
                double d = Double.parseDouble(this.getParameter("DrawingWidth"));
                double d2 = Double.parseDouble(this.getParameter("DrawingHeight"));
                if (d > 0.0 && d2 > 0.0) {
                    SVGAttributeKeys.CANVAS_WIDTH.set(defaultDrawing, d);
                    SVGAttributeKeys.CANVAS_HEIGHT.set(defaultDrawing, d2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultDrawing;
    }

    @Override
    protected DrawingComponent createDrawingComponent() {
        return new DrawingPanel();
    }

    @Override
    protected DrawingPanel getDrawingComponent() {
        return (DrawingPanel)super.getDrawingComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void saveDrawing(Drawing drawing, ProgressIndicator progressIndicator) throws IOException, ServerAuthenticationException {
        block49: {
            Object object;
            StringBuilder stringBuilder;
            int n;
            Object object2;
            Object object3;
            Closeable closeable;
            Object object4;
            block47: {
                void var7_20;
                block45: {
                    progressIndicator.setMaximum(4);
                    progressIndicator.setProgress(0);
                    progressIndicator.setIndeterminate(false);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    String string = this.getParameter("DrawingName");
                    String string2 = string = string == null ? "" : string.substring(string.lastIndexOf(46) + 1);
                    if (string.equals("")) {
                        string = "svg";
                    }
                    byte[] byArray = null;
                    for (OutputFormat object62 : drawing.getOutputFormats()) {
                        if (!string.equals(object62.getFileExtension())) continue;
                        object62.write(byteArrayOutputStream, drawing);
                        byArray = byteArrayOutputStream.toByteArray();
                        break;
                    }
                    if (byArray == null) {
                        throw new IOException("Unsupported file format.");
                    }
                    Dimension dimension = new Dimension(-1, -1);
                    try {
                        dimension.width = Integer.parseInt(this.getParameter("DrawingWidth"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        dimension.height = Integer.parseInt(this.getParameter("DrawingHeight"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (dimension.width == -1 || dimension.height == -1) {
                        void var7_16;
                        void var7_13;
                        Object var7_12 = null;
                        for (Figure figure : drawing.getChildren()) {
                            if (var7_13 == null) {
                                Rectangle2D.Double double_ = figure.getDrawingArea();
                                continue;
                            }
                            var7_13.add(figure.getDrawingArea());
                        }
                        if (var7_13 == null) {
                            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 400.0, 300.0);
                        }
                        if (dimension.width == -1) {
                            dimension.width = (int)(Math.abs(var7_16.x) + var7_16.getWidth());
                        }
                        if (dimension.height == -1) {
                            dimension.height = (int)(Math.abs(var7_16.y) + var7_16.getHeight());
                        }
                    }
                    Object var7_18 = null;
                    object4 = null;
                    if (string.startsWith("svg")) {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        ImageOutputFormat imageOutputFormat = new ImageOutputFormat();
                        imageOutputFormat.write(byteArrayOutputStream, drawing, new AffineTransform(), dimension);
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        closeable = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
                        ((Writer)closeable).write("<map name=\"" + this.getParameter("DrawingName") + "\" id=\"" + this.getParameter("DrawingName") + "\">");
                        ((OutputStreamWriter)closeable).flush();
                        object3 = new ImageMapOutputFormat();
                        ((ImageMapOutputFormat)object3).write((OutputStream)byteArrayOutputStream, drawing, new AffineTransform(), dimension);
                        ((Writer)closeable).write("</map>");
                        ((OutputStreamWriter)closeable).flush();
                        object4 = byteArrayOutputStream.toByteArray();
                    }
                    progressIndicator.setProgress(1);
                    HttpURLConnection httpURLConnection = null;
                    closeable = null;
                    try {
                        object3 = new URL(this.getDocumentBase(), this.getParameter("UploadURL"));
                        HttpURLConnection httpURLConnection2 = (HttpURLConnection)((URL)object3).openConnection();
                        object2 = new ClientHttpRequest(httpURLConnection2);
                        ((ClientHttpRequest)object2).setParameter("filecomment", this.getDrawingComponent().getSummary());
                        ((ClientHttpRequest)object2).setParameter("filename", this.getParameter("DrawingName"));
                        ((ClientHttpRequest)object2).setParameter("noredirect", "1");
                        ((ClientHttpRequest)object2).setParameter("filepath", this.getParameter("DrawingName"), new ByteArrayInputStream(byArray));
                        ((ClientHttpRequest)object2).post();
                        n = httpURLConnection2.getResponseCode();
                        closeable = new BufferedReader(new InputStreamReader(httpURLConnection2.getInputStream(), "UTF-8"));
                        stringBuilder = new StringBuilder();
                        while (null != (object = ((BufferedReader)closeable).readLine())) {
                            stringBuilder.append((String)object);
                        }
                        ((BufferedReader)closeable).close();
                        closeable = null;
                        Object var9_27 = null;
                        if (stringBuilder.length() > 0) {
                            object = new IOException(stringBuilder.toString());
                            throw object;
                        }
                    }
                    catch (IOException iOException) {
                        Object object5;
                        if (httpURLConnection == null) break block45;
                        StringBuilder stringBuilder2 = new StringBuilder();
                        try {
                            closeable = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream(), "UTF-8"));
                            while (null != (object5 = ((BufferedReader)closeable).readLine())) {
                                stringBuilder2.append((String)object5);
                            }
                        }
                        finally {
                            if (closeable != null) {
                                ((BufferedReader)closeable).close();
                                closeable = null;
                            }
                        }
                        if (stringBuilder2.length() > 0) {
                            object5 = new IOException(stringBuilder2.toString());
                            ((Throwable)object5).initCause(iOException);
                            throw object5;
                        }
                        throw iOException;
                    }
                    catch (Throwable throwable) {
                        IOException iOException = new IOException(throwable.getMessage());
                        iOException.initCause(throwable);
                        throw iOException;
                    }
                }
                progressIndicator.setProgress(2);
                if (var7_20 != null) {
                    HttpURLConnection httpURLConnection = null;
                    closeable = null;
                    try {
                        object3 = new URL(this.getDocumentBase(), this.getParameter("UploadURL"));
                        HttpURLConnection httpURLConnection3 = (HttpURLConnection)((URL)object3).openConnection();
                        object2 = new ClientHttpRequest(httpURLConnection3);
                        ((ClientHttpRequest)object2).setParameter("filecomment", this.getDrawingComponent().getSummary());
                        ((ClientHttpRequest)object2).setParameter("filename", this.getParameter("DrawingName") + ".png");
                        ((ClientHttpRequest)object2).setParameter("noredirect", "1");
                        ((ClientHttpRequest)object2).setParameter("filepath", this.getParameter("DrawingName") + ".png", new ByteArrayInputStream((byte[])var7_20));
                        ((ClientHttpRequest)object2).post();
                        n = httpURLConnection3.getResponseCode();
                        closeable = new BufferedReader(new InputStreamReader(httpURLConnection3.getInputStream(), "UTF-8"));
                        stringBuilder = new StringBuilder();
                        while (null != (object = ((BufferedReader)closeable).readLine())) {
                            stringBuilder.append((String)object);
                        }
                        ((BufferedReader)closeable).close();
                        closeable = null;
                        Object var9_31 = null;
                    }
                    catch (IOException iOException) {
                        Object object6;
                        if (httpURLConnection == null) break block47;
                        object2 = new StringBuilder();
                        try {
                            closeable = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream(), "UTF-8"));
                            while (null != (object6 = ((BufferedReader)closeable).readLine())) {
                                ((StringBuilder)object2).append((String)object6);
                            }
                        }
                        finally {
                            if (closeable != null) {
                                ((BufferedReader)closeable).close();
                                closeable = null;
                            }
                        }
                        if (((StringBuilder)object2).length() > 0) {
                            object6 = new IOException(((StringBuilder)object2).toString());
                            ((Throwable)object6).initCause(iOException);
                            throw object6;
                        }
                        throw iOException;
                    }
                }
            }
            progressIndicator.setProgress(3);
            if (object4 != null) {
                HttpURLConnection httpURLConnection = null;
                closeable = null;
                try {
                    object3 = new URL(this.getDocumentBase(), this.getParameter("UploadURL"));
                    HttpURLConnection httpURLConnection4 = (HttpURLConnection)((URL)object3).openConnection();
                    object2 = new ClientHttpRequest(httpURLConnection4);
                    ((ClientHttpRequest)object2).setParameter("filecomment", this.getDrawingComponent().getSummary());
                    ((ClientHttpRequest)object2).setParameter("filename", this.getParameter("DrawingName") + ".map");
                    ((ClientHttpRequest)object2).setParameter("noredirect", "1");
                    ((ClientHttpRequest)object2).setParameter("filepath", this.getParameter("DrawingName") + ".map", new ByteArrayInputStream((byte[])object4));
                    ((ClientHttpRequest)object2).post();
                    n = httpURLConnection4.getResponseCode();
                    closeable = new BufferedReader(new InputStreamReader(httpURLConnection4.getInputStream(), "UTF-8"));
                    stringBuilder = new StringBuilder();
                    while (null != (object = ((BufferedReader)closeable).readLine())) {
                        stringBuilder.append((String)object);
                    }
                    ((BufferedReader)closeable).close();
                    closeable = null;
                    Object var9_35 = null;
                }
                catch (IOException iOException) {
                    Object object7;
                    if (httpURLConnection == null) break block49;
                    object2 = new StringBuilder();
                    try {
                        closeable = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream(), "UTF-8"));
                        while (null != (object7 = ((BufferedReader)closeable).readLine())) {
                            ((StringBuilder)object2).append((String)object7);
                        }
                    }
                    finally {
                        if (closeable != null) {
                            ((BufferedReader)closeable).close();
                            closeable = null;
                        }
                    }
                    if (((StringBuilder)object2).length() > 0) {
                        object7 = new IOException(((StringBuilder)object2).toString());
                        ((Throwable)object7).initCause(iOException);
                        throw object7;
                    }
                    throw iOException;
                }
            }
        }
        progressIndicator.setProgress(4);
    }

    private void initComponents() {
    }
}

