/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.ColorEntry;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public class ColorMap {
    static ColorEntry[] defaultMap = new ColorEntry[]{new ColorEntry("None", new Color(16762782)), new ColorEntry("White", Color.white), new ColorEntry("Light Gray", Color.lightGray), new ColorEntry("Gray", Color.gray), new ColorEntry("Dark Gray", Color.darkGray), new ColorEntry("Black", Color.black), new ColorEntry("Blue", Color.blue), new ColorEntry("Cyan", Color.cyan), new ColorEntry("Green", Color.green), new ColorEntry("Magenta", Color.magenta), new ColorEntry("Orange", Color.orange), new ColorEntry("Pink", Color.pink), new ColorEntry("Red", Color.red), new ColorEntry("Yellow", Color.yellow)};
    static ColorMap colorMap = null;
    Vector fMap = new Vector();

    ColorMap() {
        for (int i = 0; i < defaultMap.length; ++i) {
            this.addColor(defaultMap[i]);
        }
    }

    public static void reset() {
        colorMap = null;
    }

    public static ColorMap getColorMap() {
        if (colorMap == null) {
            colorMap = new ColorMap();
        }
        return colorMap;
    }

    public int size() {
        return this.fMap.size();
    }

    private void addColor(ColorEntry color) {
        this.fMap.addElement(color);
    }

    public void addColor(String name, Color colour) {
        this.addColor(new ColorEntry(name, colour));
    }

    public Color color(int index) {
        if (index < this.size() && index >= 0) {
            return ((ColorEntry)this.fMap.elementAt((int)index)).fColor;
        }
        throw new ArrayIndexOutOfBoundsException("Color index: " + index);
    }

    public Color color(String name) {
        Enumeration e = this.fMap.elements();
        while (e.hasMoreElements()) {
            ColorEntry ce = (ColorEntry)e.nextElement();
            if (!ce.fName.equals(name)) continue;
            return ce.fColor;
        }
        return Color.black;
    }

    public String name(int index) {
        if (index < this.size() && index >= 0) {
            return ((ColorEntry)this.fMap.elementAt((int)index)).fName;
        }
        throw new ArrayIndexOutOfBoundsException("Color index: " + index);
    }

    public int colorIndex(Color color) {
        Enumeration e = this.fMap.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            ColorEntry ce = (ColorEntry)e.nextElement();
            if (ce.fColor.equals(color)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public boolean isTransparent(Color color) {
        return color.equals(this.color("None"));
    }
}

