/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.twiki;

import Acme.JPM.Encoders.GifEncoder;
import CH.ifa.draw.appframe.Application;
import CH.ifa.draw.appframe.DrawFrame;
import CH.ifa.draw.contrib.PolygonTool;
import CH.ifa.draw.figures.BorderTool;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.ElbowConnection;
import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.figures.ScribbleTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.figures.URLTool;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.standard.BringToFrontCommand;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.CopyCommand;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.CutCommand;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.DuplicateCommand;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SendToBackCommand;
import CH.ifa.draw.standard.ToggleGuidesCommand;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandButton;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.StorableOutput;
import com.eteks.filter.Web216ColorsFilter;
import java.awt.Button;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.FilteredImageSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;

public class TWikiFrame
extends DrawFrame {
    private static String UNTITLED_PARAMETER = "untitled";
    private static String DRAWPATH_PARAMETER = "drawpath";
    private static String GIFPATH_PARAMETER = "gifpath";
    private static String SVGPATH_PARAMETER = "svgpath";
    private static String SAVEPATH_PARAMETER = "savepath";
    private static String HELPPATH_PARAMETER = "helppath";
    private static String BORDERSIZE_PARAMETER = "bordersize";
    private Label fStatusLabel;
    private boolean bPostEnabled = true;

    public TWikiFrame(Application applet, String colors) {
        super("TWikiDraw", applet);
        this.view().setBackground(Color.white);
        ColorMap.reset();
        if (colors != null) {
            do {
                String thisColor;
                int split;
                if ((split = colors.indexOf(44)) == -1) {
                    thisColor = colors;
                    colors = "";
                } else {
                    thisColor = colors.substring(0, split);
                    colors = colors.substring(split + 1);
                }
                split = thisColor.indexOf(61);
                if (split == -1) continue;
                String name = thisColor.substring(0, split).trim();
                if (split < thisColor.length() - 1 && thisColor.charAt(split + 1) == '#') {
                    ++split;
                }
                String value = thisColor.substring(split + 1).trim();
                try {
                    int i = Integer.valueOf(value, 16);
                    ColorMap.getColorMap().addColor(name, new Color(i));
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
            } while (colors.length() > 0);
        }
        if (applet.getParameter(DRAWPATH_PARAMETER) != null) {
            this.loadDrawing(DRAWPATH_PARAMETER);
        }
    }

    protected void populateMenuBar(MenuBar menuBar) {
        menuBar.add(this.createDrawingMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createSelectionMenu());
        menuBar.add(this.createFillMenu());
        menuBar.add(this.createLineMenu());
        menuBar.add(this.createTextMenu());
        this.setMenuBar(menuBar);
    }

    protected CommandMenu createDrawingMenu() {
        CommandMenu menu = new CommandMenu("Drawing");
        menu.add(new NewDrawingCommand(this));
        menu.add(new ReloadDrawingCommand(this));
        menu.add(new SaveDrawingCommand(this));
        menu.add(new ExitDrawingCommand(this));
        return menu;
    }

    protected CommandMenu createEditMenu() {
        CommandMenu menu = new CommandMenu("Edit");
        menu.add(new DeleteCommand("Delete", this.view()));
        menu.add(new CutCommand("Cut", this.view()));
        menu.add(new CopyCommand("Copy", this.view()));
        menu.add(new PasteCommand("Paste", this.view()));
        menu.add(new ToggleGuidesCommand("Toggle guides", this.view()));
        return menu;
    }

    protected CommandMenu createSelectionMenu() {
        CommandMenu menu = new CommandMenu("Selection");
        menu.add(new DuplicateCommand("Duplicate", this.view()));
        menu.add(new GroupCommand("Group", this.view()));
        menu.add(new UngroupCommand("Ungroup", this.view()));
        menu.add(new SendToBackCommand("Send to Back", this.view()));
        menu.add(new BringToFrontCommand("Bring to Front", this.view()));
        CommandMenu align = new CommandMenu("Align");
        align.add(new AlignCommand("Lefts", this.view(), 0));
        align.add(new AlignCommand("Centres", this.view(), 1));
        align.add(new AlignCommand("Rights", this.view(), 2));
        align.add(new AlignCommand("Tops", this.view(), 3));
        align.add(new AlignCommand("Middles", this.view(), 4));
        align.add(new AlignCommand("Bottoms", this.view(), 5));
        menu.add(align);
        return menu;
    }

    protected CommandMenu createFillMenu() {
        CommandMenu menu = new CommandMenu("Fill");
        menu.add(this.createColorMenu("FillColor"));
        return menu;
    }

    protected CommandMenu createLineMenu() {
        CommandMenu menu = new CommandMenu("Line");
        menu.add(this.createColorMenu("FrameColor"));
        CommandMenu arrowStyle = new CommandMenu("Arrows");
        arrowStyle.add(new ChangeAttributeCommand("none", "ArrowMode", new Integer(0), this.view()));
        arrowStyle.add(new ChangeAttributeCommand("at Start", "ArrowMode", new Integer(1), this.view()));
        arrowStyle.add(new ChangeAttributeCommand("at End", "ArrowMode", new Integer(2), this.view()));
        arrowStyle.add(new ChangeAttributeCommand("at Both ends", "ArrowMode", new Integer(3), this.view()));
        menu.add(arrowStyle);
        return menu;
    }

    protected CommandMenu createTextMenu() {
        CommandMenu menu = new CommandMenu("Text");
        menu.add(this.createFontMenu());
        menu.add(this.createColorMenu("TextColor"));
        CommandMenu style = new CommandMenu("Style");
        style.add(new ChangeAttributeCommand("Plain", "FontStyle", new Integer(0), this.view()));
        style.add(new ChangeAttributeCommand("Italic", "FontStyle", new Integer(2), this.view()));
        style.add(new ChangeAttributeCommand("Bold", "FontStyle", new Integer(1), this.view()));
        menu.add(style);
        CommandMenu align = new CommandMenu("Align");
        align.add(new ChangeAttributeCommand("Left", "TextAlign", "Left", this.view()));
        align.add(new ChangeAttributeCommand("Centre", "TextAlign", "Centre", this.view()));
        align.add(new ChangeAttributeCommand("Right", "TextAlign", "Right", this.view()));
        menu.add(align);
        return menu;
    }

    protected void populateWestPanel(Panel palette) {
        super.populateWestPanel(palette);
        AbstractTool tool = new TextTool(this.view(), new TextFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/TEXT", "Text Tool", tool));
        tool = new ConnectedTextTool(this.view(), new TextFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/ATEXT", "Connected Text Tool", tool));
        tool = new CreationTool(this.view(), new RectangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/RECT", "Rectangle Tool", tool));
        tool = new CreationTool(this.view(), new RoundRectangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/RRECT", "Round Rectangle Tool", tool));
        tool = new CreationTool(this.view(), new EllipseFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/ELLIPSE", "Ellipse Tool", tool));
        tool = new CreationTool(this.view(), new LineFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/LINE", "Line Tool", tool));
        tool = new ConnectionTool(this.view(), new LineConnection());
        palette.add(this.createToolButton("/CH/ifa/draw/images/CONN", "Connection Tool", tool));
        tool = new ConnectionTool(this.view(), new ElbowConnection());
        palette.add(this.createToolButton("/CH/ifa/draw/images/OCONN", "Elbow Connection Tool", tool));
        tool = new ScribbleTool(this.view());
        palette.add(this.createToolButton("/CH/ifa/draw/images/SCRIBBL", "Scribble Tool", tool));
        tool = new PolygonTool(this.view());
        palette.add(this.createToolButton("/CH/ifa/draw/images/POLYGON", "Polygon Tool", tool));
        tool = new BorderTool(this.view());
        palette.add(this.createToolButton("/CH/ifa/draw/images/BORDDEC", "Border Tool", tool));
        tool = new URLTool(this.view(), new RectangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/URL", "URL Tool", tool));
    }

    protected Panel createSouthPanel() {
        Panel split = new Panel();
        split.setLayout(new GridLayout(2, 1));
        return split;
    }

    protected void populateSouthPanel(Panel panel) {
        Panel buttons = new Panel();
        Button button = new CommandButton(new DeleteCommand("Delete", this.view()));
        buttons.add(button);
        button = new CommandButton(new DuplicateCommand("Duplicate", this.view()));
        buttons.add(button);
        button = new CommandButton(new GroupCommand("Group", this.view()));
        buttons.add(button);
        button = new CommandButton(new UngroupCommand("Ungroup", this.view()));
        buttons.add(button);
        button = new CommandButton(new BringToFrontCommand("Bring To Front", this.view()));
        buttons.add(button);
        button = new CommandButton(new SendToBackCommand("Send To Back", this.view()));
        buttons.add(button);
        button = new Button("Help");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TWikiFrame.this.showHelp();
            }
        });
        buttons.add(button);
        panel.add(buttons);
        this.fStatusLabel = new Label("Status");
        panel.add(this.fStatusLabel);
    }

    public void showStatus(String s) {
        if (this.fStatusLabel != null) {
            this.fStatusLabel.setText(s);
        } else {
            this.getApplication().showStatus(s);
        }
    }

    protected void setSimpleDisplayUpdate() {
    }

    protected void setBufferedDisplayUpdate() {
    }

    protected void showHelp() {
        String helpPath = this.getApplication().getParameter(HELPPATH_PARAMETER);
        this.getApplication().popupFrame(helpPath, "Help");
    }

    public void doLoadDrawing(String name) {
        this.loadDrawing(name);
        this.view().setBackground(Color.white);
    }

    public boolean doSaveDrawing() {
        Application app = this.getApplication();
        boolean savedMap = false;
        boolean savedGif = false;
        boolean savedSvg = false;
        boolean savedDraw = false;
        this.setCursor(new Cursor(3));
        try {
            String mapPath;
            String map;
            String savePath;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StorableOutput output = new StorableOutput(out);
            output.writeStorable(this.drawing());
            output.close();
            String drawingPath = app.getParameter(DRAWPATH_PARAMETER);
            if (drawingPath == null) {
                drawingPath = "untitled.draw";
            }
            if ((savePath = app.getParameter(SAVEPATH_PARAMETER)) == null) {
                savePath = "";
            }
            this.showStatus("Saving .draw file " + drawingPath);
            if (this.bPostEnabled) {
                savedDraw = app.post(savePath, "", "text/plain", drawingPath, out.toString(), "TWiki Draw draw file");
            }
            Dimension d = new Dimension(0, 0);
            FigureEnumeration k = this.drawing().figuresReverse();
            while (k.hasMoreElements()) {
                Figure figure = k.nextFigure();
                Rectangle r = figure.displayBox();
                if (r.x + r.width > d.width) {
                    d.setSize(r.x + r.width, d.height);
                }
                if (r.y + r.height <= d.height) continue;
                d.setSize(d.width, r.y + r.height);
            }
            int iBorder = 10;
            String sBorder = this.getApplication().getParameter(BORDERSIZE_PARAMETER);
            if (sBorder != null && (iBorder = Integer.valueOf(sBorder).intValue()) < 0) {
                iBorder = 0;
            }
            if ((map = this.drawing().getMap()).length() > 0) {
                mapPath = drawingPath.substring(0, drawingPath.length() - 5) + ".map";
                this.showStatus("Saving .map file " + mapPath);
                String area = "<area shape=\"rect\" coords=\"";
                String link = "\" href=\"%TWIKIDRAW%\" alt=\"%EDITTEXT%\" title=\"%EDITTEXT%\" %HOVER% />";
                map = "<map name=\"%MAPNAME%\">" + map + area + "0,0," + (d.width + iBorder) + "," + iBorder / 2 + link + area + "0,0," + iBorder / 2 + "," + (d.height + iBorder) + link + area + (d.width + iBorder / 2) + ",0," + (d.width + iBorder) + "," + (d.height + iBorder) + link + area + "0," + (d.height + iBorder / 2) + "," + (d.width + iBorder) + "," + (d.height + iBorder) + link + "</map>";
                savedMap = app.post(savePath, "", "text/plain", mapPath, map, "TWiki Draw map file");
            } else {
                mapPath = drawingPath.substring(0, drawingPath.length() - 5);
                savedMap = app.post(savePath, "", "text/plain", mapPath + ".map", "", "");
            }
            String gifPath = this.getApplication().getParameter(GIFPATH_PARAMETER);
            if (gifPath == null || gifPath.length() == 0) {
                gifPath = "untitled.gif";
            }
            this.showStatus("Saving .gif file " + gifPath);
            this.view().clearSelection();
            Image oImgBuffer = this.view().createImage(d.width + iBorder, d.height + iBorder);
            char[] aChar = this.convertToGif(oImgBuffer);
            if (this.bPostEnabled) {
                savedGif = app.post(savePath, "", "image/gif", gifPath, String.valueOf(aChar, 0, aChar.length), "TWiki Draw GIF file");
            }
        }
        catch (MalformedURLException e) {
            this.setCursor(new Cursor(0));
            this.showStatus("Bad Wiki servlet URL: " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setCursor(new Cursor(0));
            this.showStatus(e.toString());
        }
        this.setCursor(new Cursor(0));
        this.showStatus("Saved .draw " + (savedDraw ? "OK" : "Failed") + " .map " + (savedMap ? "OK" : "Failed") + " .gif " + (savedGif ? "OK" : "Failed"));
        return savedDraw;
    }

    void enablePost(boolean b) {
        this.bPostEnabled = b;
        if (!this.bPostEnabled) {
            this.setTitle(this.getTitle() + " - POST DISABLED FOR TESTING");
        }
    }

    static void debug(String msg) {
        System.err.println("TWikiDraw:" + msg);
    }

    private char[] convertToGif(Image oImgBuffer) throws IOException {
        TWikiFrame.debug("converting data to GIF...");
        Graphics oGrf = oImgBuffer.getGraphics();
        this.view().enableGuides(false);
        this.view().drawAll(oGrf);
        ByteArrayOutputStream oOut = null;
        try {
            oOut = new ByteArrayOutputStream();
            new GifEncoder(oImgBuffer, (OutputStream)oOut).encode();
        }
        catch (IOException ioe) {
            TWikiFrame.debug("GIF uses too many colors, reducing to 216 colors...");
            FilteredImageSource filter = new FilteredImageSource(oImgBuffer.getSource(), new Web216ColorsFilter());
            oOut = new ByteArrayOutputStream();
            new GifEncoder(filter, (OutputStream)oOut).encode();
            TWikiFrame.debug("Color reduction successful.");
        }
        byte[] aByte = oOut.toByteArray();
        int size = oOut.size();
        char[] aChar = new char[size];
        for (int i = 0; i < size; ++i) {
            aChar[i] = (char)aByte[i];
        }
        TWikiFrame.debug("conversion to GIF successful.");
        return aChar;
    }

    class ExitDrawingCommand
    extends Command {
        TWikiFrame frame;

        public ExitDrawingCommand(TWikiFrame frm) {
            super("Exit without saving");
            this.frame = frm;
        }

        public void execute() {
            TWikiFrame.this.getApplication().exit();
        }
    }

    class SaveDrawingCommand
    extends Command {
        TWikiFrame frame;

        public SaveDrawingCommand(TWikiFrame frm) {
            super("Save and Exit");
            this.frame = frm;
        }

        public void execute() {
            if (this.frame.doSaveDrawing()) {
                TWikiFrame.this.getApplication().exit();
            }
        }
    }

    class ReloadDrawingCommand
    extends Command {
        TWikiFrame frame;

        public ReloadDrawingCommand(TWikiFrame frm) {
            super("Reload");
            this.frame = frm;
        }

        public void execute() {
            this.frame.doLoadDrawing(DRAWPATH_PARAMETER);
        }
    }

    class NewDrawingCommand
    extends Command {
        TWikiFrame frame;

        public NewDrawingCommand(TWikiFrame frm) {
            super("Clear");
            this.frame = frm;
        }

        public void execute() {
            this.frame.doLoadDrawing(UNTITLED_PARAMETER);
        }
    }
}

