/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Painter;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;

public class StandardDrawingView
extends Panel
implements DrawingView,
MouseListener,
MouseMotionListener,
KeyListener {
    private transient DrawingEditor fEditor;
    private Drawing fDrawing;
    private transient Rectangle fDamage = null;
    private transient Vector fSelection;
    private transient Vector fSelectionHandles;
    private Dimension fViewSize;
    private Point fLastClick;
    private Vector fBackgrounds = null;
    private Vector fForegrounds = null;
    private Painter fUpdateStrategy;
    private PointConstrainer fConstrainer;
    private boolean showGuides;
    private static final long serialVersionUID = -3878153366174603336L;
    private int drawingViewSerializedDataVersion = 1;

    public StandardDrawingView(DrawingEditor editor, int width, int height) {
        this.fEditor = editor;
        this.fViewSize = new Dimension(width, height);
        this.fLastClick = new Point(0, 0);
        this.fConstrainer = null;
        this.fSelection = new Vector();
        this.showGuides = true;
        this.setDisplayUpdate(new BufferedUpdateStrategy());
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public void setEditor(DrawingEditor editor) {
        this.fEditor = editor;
    }

    public Tool tool() {
        return this.fEditor.tool();
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public void setDrawing(Drawing d) {
        this.clearSelection();
        if (this.fDrawing != null) {
            this.fDrawing.removeDrawingChangeListener(this);
        }
        this.fDrawing = d;
        if (this.fDrawing != null) {
            this.fDrawing.addDrawingChangeListener(this);
        }
        this.checkMinimumSize();
        this.repaint();
    }

    public DrawingEditor editor() {
        return this.fEditor;
    }

    public Figure add(Figure figure) {
        return this.drawing().add(figure);
    }

    public Figure remove(Figure figure) {
        return this.drawing().remove(figure);
    }

    public void addAll(Vector figures) {
        FigureEnumerator k = new FigureEnumerator(figures);
        while (k.hasMoreElements()) {
            this.add(k.nextFigure());
        }
    }

    public Dimension getMinimumSize() {
        return this.fViewSize;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setDisplayUpdate(Painter updateStrategy) {
        this.fUpdateStrategy = updateStrategy;
    }

    public Vector selection() {
        return (Vector)this.fSelection.clone();
    }

    public FigureEnumeration selectionElements() {
        return new FigureEnumerator(this.fSelection);
    }

    public Vector selectionZOrdered() {
        Vector<Figure> result = new Vector<Figure>(this.fSelection.size());
        FigureEnumeration figures = this.drawing().figures();
        while (figures.hasMoreElements()) {
            Figure f = figures.nextFigure();
            if (!this.fSelection.contains(f)) continue;
            result.addElement(f);
        }
        return result;
    }

    public int selectionCount() {
        return this.fSelection.size();
    }

    public void addToSelection(Figure figure) {
        if (!this.fSelection.contains(figure)) {
            this.fSelection.addElement(figure);
            this.fSelectionHandles = null;
            figure.invalidate();
            this.selectionChanged();
        }
    }

    public void addToSelectionAll(Vector figures) {
        FigureEnumerator k = new FigureEnumerator(figures);
        while (k.hasMoreElements()) {
            this.addToSelection(k.nextFigure());
        }
    }

    public void removeFromSelection(Figure figure) {
        if (this.fSelection.contains(figure)) {
            this.fSelection.removeElement(figure);
            this.fSelectionHandles = null;
            figure.invalidate();
            this.selectionChanged();
        }
    }

    public void toggleSelection(Figure figure) {
        if (this.fSelection.contains(figure)) {
            this.removeFromSelection(figure);
        } else {
            this.addToSelection(figure);
        }
        this.selectionChanged();
    }

    public void clearSelection() {
        FigureEnumeration k = this.selectionElements();
        while (k.hasMoreElements()) {
            k.nextFigure().invalidate();
        }
        this.fSelection = new Vector();
        this.fSelectionHandles = null;
        this.selectionChanged();
    }

    private Enumeration selectionHandles() {
        if (this.fSelectionHandles == null) {
            this.fSelectionHandles = new Vector();
            FigureEnumeration k = this.selectionElements();
            while (k.hasMoreElements()) {
                Figure figure = k.nextFigure();
                Enumeration kk = figure.handles().elements();
                while (kk.hasMoreElements()) {
                    this.fSelectionHandles.addElement(kk.nextElement());
                }
            }
        }
        return this.fSelectionHandles.elements();
    }

    public FigureSelection getFigureSelection() {
        return new FigureSelection(this.selectionZOrdered());
    }

    public void moveSelection(int dx, int dy) {
        FigureEnumeration figures = this.selectionElements();
        while (figures.hasMoreElements()) {
            Figure fig = figures.nextFigure();
            Figure obsrvd = (Figure)fig.getAttribute("observed.figure");
            if (obsrvd != null && figures.contains(obsrvd)) continue;
            fig.moveBy(dx, dy);
        }
        this.checkDamage();
    }

    public Handle findHandle(int x, int y) {
        Enumeration k = this.selectionHandles();
        while (k.hasMoreElements()) {
            Handle handle = (Handle)k.nextElement();
            if (!handle.containsPoint(x, y)) continue;
            return handle;
        }
        return null;
    }

    protected void selectionChanged() {
        this.fEditor.selectionChanged(this);
    }

    public Point lastClick() {
        return this.fLastClick;
    }

    public void setConstrainer(PointConstrainer c) {
        this.fConstrainer = c;
    }

    public PointConstrainer getConstrainer() {
        return this.fConstrainer;
    }

    protected Point constrainPoint(Point p) {
        Dimension size = this.getSize();
        p.x = Geom.range(1, size.width, p.x);
        p.y = Geom.range(1, size.height, p.y);
        if (this.fConstrainer != null) {
            return this.fConstrainer.constrainPoint(p);
        }
        return p;
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        Point p = this.constrainPoint(new Point(e.getX(), e.getY()));
        this.fLastClick = new Point(e.getX(), e.getY());
        this.tool().mouseDown(e, p.x, p.y);
        this.checkDamage();
    }

    public void mouseDragged(MouseEvent e) {
        Point p = this.constrainPoint(new Point(e.getX(), e.getY()));
        this.tool().mouseDrag(e, p.x, p.y);
        this.checkDamage();
    }

    public void mouseMoved(MouseEvent e) {
        this.tool().mouseMove(e, e.getX(), e.getY());
    }

    public void mouseReleased(MouseEvent e) {
        Point p = this.constrainPoint(new Point(e.getX(), e.getY()));
        this.tool().mouseUp(e, p.x, p.y);
        this.checkDamage();
        this.checkMinimumSize();
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 8 || code == 127) {
            DeleteCommand cmd = new DeleteCommand("Delete", this);
            ((Command)cmd).execute();
        } else if (code == 40 || code == 38 || code == 39 || code == 37) {
            this.handleCursorKey(code);
        } else {
            this.tool().keyDown(e, code);
        }
        this.checkDamage();
    }

    protected void handleCursorKey(int key) {
        int dx = 0;
        int dy = 0;
        int stepX = 1;
        int stepY = 1;
        if (this.fConstrainer != null) {
            stepX = this.fConstrainer.getStepX();
            stepY = this.fConstrainer.getStepY();
        }
        switch (key) {
            case 40: {
                dy = stepY;
                break;
            }
            case 38: {
                dy = -stepY;
                break;
            }
            case 39: {
                dx = stepX;
                break;
            }
            case 37: {
                dx = -stepX;
            }
        }
        this.moveSelection(dx, dy);
    }

    public synchronized void checkDamage() {
        Enumeration each = this.drawing().drawingChangeListeners();
        while (each.hasMoreElements()) {
            Object l = each.nextElement();
            if (!(l instanceof DrawingView)) continue;
            ((DrawingView)l).repairDamage();
        }
    }

    public void repairDamage() {
        if (this.fDamage != null) {
            this.repaint(this.fDamage.x, this.fDamage.y, this.fDamage.width, this.fDamage.height);
            this.fDamage = null;
        }
    }

    public void drawingInvalidated(DrawingChangeEvent e) {
        Rectangle r = e.getInvalidatedRectangle();
        if (this.fDamage == null) {
            this.fDamage = r;
        } else {
            this.fDamage.add(r);
        }
    }

    public void drawingRequestUpdate(DrawingChangeEvent e) {
        this.repairDamage();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.fUpdateStrategy.draw(g, this);
    }

    public void drawAll(Graphics g) {
        boolean isPrinting = g instanceof PrintGraphics;
        this.drawBackground(g);
        if (this.fBackgrounds != null && !isPrinting) {
            this.drawPainters(g, this.fBackgrounds);
        }
        this.drawDrawing(g, this.showGuides);
        if (this.fForegrounds != null && !isPrinting) {
            this.drawPainters(g, this.fForegrounds);
        }
        if (!isPrinting) {
            this.drawHandles(g);
        }
    }

    public void drawHandles(Graphics g) {
        Enumeration k = this.selectionHandles();
        while (k.hasMoreElements()) {
            ((Handle)k.nextElement()).draw(g);
        }
    }

    public void drawDrawing(Graphics g, boolean showGuides) {
        this.fDrawing.draw(g, showGuides);
    }

    public void drawBackground(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
    }

    private void drawPainters(Graphics g, Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            ((Painter)v.elementAt(i)).draw(g, this);
        }
    }

    public void addBackground(Painter painter) {
        if (this.fBackgrounds == null) {
            this.fBackgrounds = new Vector(3);
        }
        this.fBackgrounds.addElement(painter);
        this.repaint();
    }

    public void removeBackground(Painter painter) {
        if (this.fBackgrounds != null) {
            this.fBackgrounds.removeElement(painter);
        }
        this.repaint();
    }

    public void removeForeground(Painter painter) {
        if (this.fForegrounds != null) {
            this.fForegrounds.removeElement(painter);
        }
        this.repaint();
    }

    public void addForeground(Painter painter) {
        if (this.fForegrounds == null) {
            this.fForegrounds = new Vector(3);
        }
        this.fForegrounds.addElement(painter);
        this.repaint();
    }

    public void freezeView() {
        this.drawing().lock();
    }

    public void unfreezeView() {
        this.drawing().unlock();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.fSelection = new Vector();
        if (this.fDrawing != null) {
            this.fDrawing.addDrawingChangeListener(this);
        }
    }

    private Dimension getDrawingSize() {
        FigureEnumeration k = this.drawing().figures();
        Dimension d = new Dimension(0, 0);
        while (k.hasMoreElements()) {
            Rectangle r = k.nextFigure().displayBox();
            d.width = Math.max(d.width, r.x + r.width);
            d.height = Math.max(d.height, r.y + r.height);
        }
        return d;
    }

    private void checkMinimumSize() {
        Dimension d = this.getDrawingSize();
        boolean bloat = false;
        if (this.fViewSize.height < d.height) {
            this.fViewSize.height = d.height + 10;
            bloat = true;
        }
        if (this.fViewSize.width < d.width) {
            this.fViewSize.width = d.width + 10;
            bloat = true;
        }
        if (bloat) {
            this.setSize(this.fViewSize);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void enableGuides(boolean enable) {
        this.showGuides = enable;
    }

    public boolean guidesEnabled() {
        return this.showGuides;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }
}

