/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.ChopBoxConnector;
import CH.ifa.draw.standard.FigureAttributes;
import CH.ifa.draw.standard.FigureChangeEventMulticaster;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public abstract class AbstractFigure
implements Figure {
    private FigureAttributes fAttributes;
    private transient FigureChangeListener fListener;
    private static final long serialVersionUID = -10857585979273442L;
    private int abstractFigureSerializedDataVersion = 1;
    protected static Font dialogFont = Font.decode("dialog-PLAIN-12");

    protected AbstractFigure() {
    }

    public void moveBy(int dx, int dy) {
        this.willChange();
        this.basicMoveBy(dx, dy);
        this.changed();
    }

    protected abstract void basicMoveBy(int var1, int var2);

    public void displayBox(Point origin, Point corner) {
        this.willChange();
        this.basicDisplayBox(origin, corner);
        this.changed();
    }

    public abstract void basicDisplayBox(Point var1, Point var2);

    public abstract Rectangle displayBox();

    public abstract Vector handles();

    public FigureEnumeration figures() {
        Vector<AbstractFigure> figures = new Vector<AbstractFigure>(1);
        figures.addElement(this);
        return new FigureEnumerator(figures);
    }

    public Dimension size() {
        return new Dimension(this.displayBox().width, this.displayBox().height);
    }

    public boolean isEmpty() {
        return this.size().width < 3 || this.size().height < 3;
    }

    public Figure findFigureInside(int x, int y) {
        if (this.containsPoint(x, y)) {
            return this;
        }
        return null;
    }

    public boolean containsPoint(int x, int y) {
        return this.displayBox().contains(x, y);
    }

    public void displayBox(Rectangle r) {
        this.displayBox(new Point(r.x, r.y), new Point(r.x + r.width, r.y + r.height));
    }

    public boolean includes(Figure figure) {
        return figure == this;
    }

    public FigureEnumeration decompose() {
        Vector<AbstractFigure> figures = new Vector<AbstractFigure>(1);
        figures.addElement(this);
        return new FigureEnumerator(figures);
    }

    public void addToContainer(FigureChangeListener c) {
        this.addFigureChangeListener(c);
        this.invalidate();
    }

    public void removeFromContainer(FigureChangeListener c) {
        this.invalidate();
        this.removeFigureChangeListener(c);
        this.changed();
    }

    public void addFigureChangeListener(FigureChangeListener l) {
        this.fListener = FigureChangeEventMulticaster.add(this.fListener, l);
    }

    public void removeFigureChangeListener(FigureChangeListener l) {
        this.fListener = FigureChangeEventMulticaster.remove(this.fListener, l);
    }

    public FigureChangeListener listener() {
        return this.fListener;
    }

    public void release() {
        if (this.fListener != null) {
            this.fListener.figureRemoved(new FigureChangeEvent(this));
        }
    }

    public void invalidate() {
        if (this.fListener != null) {
            Rectangle r = this.displayBox();
            r.grow(8, 8);
            this.fListener.figureInvalidated(new FigureChangeEvent(this, r));
        }
    }

    public void willChange() {
        this.invalidate();
    }

    public void changed() {
        this.invalidate();
        if (this.fListener != null) {
            this.fListener.figureChanged(new FigureChangeEvent(this));
        }
    }

    public Point center() {
        return Geom.center(this.displayBox());
    }

    public boolean canConnect() {
        return true;
    }

    public Insets connectionInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Connector connectorAt(int x, int y) {
        return new ChopBoxConnector(this);
    }

    public void connectorVisibility(boolean isVisible) {
    }

    public Locator connectedTextLocator(Figure text) {
        return RelativeLocator.center();
    }

    public Object defaultAttribute(String name) {
        return null;
    }

    public Object getAttribute(String name) {
        if (this.fAttributes != null && this.fAttributes.hasDefined(name)) {
            return this.fAttributes.get(name);
        }
        return this.defaultAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set(name, value);
        this.changed();
    }

    public Object clone() {
        Object clone = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream(200);
        try {
            ObjectOutputStream writer = new ObjectOutputStream(output);
            writer.writeObject(this);
            writer.close();
        }
        catch (IOException e) {
            System.out.println("Class not found: " + e);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        try {
            ObjectInputStream reader = new ObjectInputStream(input);
            clone = reader.readObject();
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found: " + e);
        }
        return clone;
    }

    public void write(StorableOutput dw) {
        if (this.fAttributes == null) {
            dw.writeString("no_attributes");
        } else {
            dw.writeString("attributes");
            this.fAttributes.write(dw);
        }
    }

    public void read(StorableInput dr) throws IOException {
        if (dr.testForNumber()) {
            return;
        }
        String s = dr.readString();
        if (s.toLowerCase().equals("attributes")) {
            this.fAttributes = new FigureAttributes();
            this.fAttributes.read(dr);
        }
    }

    public abstract /* synthetic */ void draw(Graphics var1, boolean var2);

    public abstract /* synthetic */ String getMap();
}

