/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.util.FloatingTextField;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class URLTool
extends CreationTool {
    private FloatingTextField fTextField;
    private Figure fTypingTarget;
    private static Font dialogFont = Font.decode("dialog-PLAIN-12");

    public URLTool(DrawingView view, Figure prototype) {
        super(view, prototype);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        Figure pressedFigure = this.drawing().findFigureInside(x, y);
        if (pressedFigure != null) {
            this.beginEdit(pressedFigure);
        } else if (this.fTypingTarget != null) {
            this.editor().toolDone();
            this.endEdit();
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
    }

    public void mouseUp(MouseEvent e, int x, int y) {
    }

    public void deactivate() {
        super.deactivate();
        this.endEdit();
    }

    public void activate() {
        super.activate();
        this.view().clearSelection();
    }

    protected void beginEdit(Figure figure) {
        if (this.fTextField == null) {
            this.fTextField = new FloatingTextField();
        }
        if (figure != this.fTypingTarget && this.fTypingTarget != null) {
            this.endEdit();
        }
        this.fTextField.createOverlay((Container)((Object)this.view()), dialogFont);
        this.fTextField.setBounds(this.fieldBounds(figure), (String)figure.getAttribute("Sensitive"));
        this.fTypingTarget = figure;
    }

    protected void endEdit() {
        if (this.fTypingTarget != null) {
            this.fTypingTarget.setAttribute("Sensitive", this.fTextField.getText());
            this.fTypingTarget = null;
            this.fTextField.endOverlay();
            this.view().checkDamage();
        }
    }

    private Rectangle fieldBounds(Figure figure) {
        Rectangle box = figure.displayBox();
        Dimension d = this.fTextField.getPreferredSize(1, 20);
        return new Rectangle(box.x, box.y, d.width, d.height);
    }
}

