/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.FloatingTextField;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class TextTool
extends CreationTool {
    private FloatingTextField fTextField;
    private TextHolder fTypingTarget;

    public TextTool(DrawingView view, Figure prototype) {
        super(view, prototype);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        TextHolder textHolder = null;
        Figure pressedFigure = this.drawing().findFigureInside(x, y);
        if (pressedFigure instanceof TextHolder && !(textHolder = (TextHolder)((Object)pressedFigure)).acceptsTyping()) {
            textHolder = null;
        }
        if (textHolder != null) {
            this.beginEdit(textHolder);
            return;
        }
        if (this.fTypingTarget != null) {
            this.editor().toolDone();
            this.endEdit();
        } else {
            super.mouseDown(e, x, y);
            textHolder = (TextHolder)((Object)this.createdFigure());
            this.beginEdit(textHolder);
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
    }

    public void mouseUp(MouseEvent e, int x, int y) {
    }

    public void deactivate() {
        super.deactivate();
        this.endEdit();
    }

    public void activate() {
        super.activate();
        this.view().clearSelection();
    }

    protected void beginEdit(TextHolder figure) {
        if (this.fTextField == null) {
            this.fTextField = new FloatingTextField();
        }
        if (figure != this.fTypingTarget && this.fTypingTarget != null) {
            this.endEdit();
        }
        this.fTextField.createOverlay((Container)((Object)this.view()), figure.getFont());
        this.fTextField.setBounds(this.fieldBounds(figure), figure.getText());
        this.fTypingTarget = figure;
    }

    protected void endEdit() {
        if (this.fTypingTarget != null) {
            if (this.fTextField.getText().length() > 0) {
                this.fTypingTarget.setText(this.fTextField.getText());
            } else {
                this.drawing().remove((Figure)((Object)this.fTypingTarget));
            }
            this.fTypingTarget = null;
            this.fTextField.endOverlay();
            this.view().checkDamage();
        }
    }

    private Rectangle fieldBounds(TextHolder figure) {
        Rectangle box = figure.textDisplayBox();
        int nRows = figure.overlayRows();
        int nCols = figure.overlayColumns();
        Dimension d = this.fTextField.getPreferredSize(nRows, nCols);
        return new Rectangle(box.x, box.y, d.width, d.height);
    }
}

