/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.FontSizeHandle;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.OffsetLocator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class TextFigure
extends AttributeFigure
implements FigureChangeListener,
TextHolder {
    private int fOriginX = 0;
    private int fOriginY = 0;
    private transient boolean fSizeIsDirty = true;
    private transient int fWidth;
    private transient int fHeight;
    private String fText;
    private Font fFont = TextFigure.createCurrentFont();
    private boolean fIsReadOnly;
    private Figure fObservedFigure = null;
    private OffsetLocator fLocator = null;
    private static String fgCurrentFontName = "Helvetica";
    private static int fgCurrentFontSize = 12;
    private static int fgCurrentFontStyle = 0;
    private static final long serialVersionUID = 4599820785949456124L;
    private int textFigureSerializedDataVersion = 1;

    public TextFigure() {
        this.setAttribute("FillColor", ColorMap.getColorMap().color("None"));
        this.fText = new String("");
        this.fSizeIsDirty = true;
    }

    public void moveBy(int x, int y) {
        this.willChange();
        this.basicMoveBy(x, y);
        if (this.fLocator != null) {
            this.fLocator.moveBy(x, y);
        }
        this.changed();
    }

    protected void basicMoveBy(int x, int y) {
        this.fOriginX += x;
        this.fOriginY += y;
    }

    public void basicDisplayBox(Point newOrigin, Point newCorner) {
        this.fOriginX = newOrigin.x;
        this.fOriginY = newOrigin.y;
    }

    public Rectangle displayBox() {
        Dimension extent = this.textExtent();
        return new Rectangle(this.fOriginX, this.fOriginY, extent.width, extent.height);
    }

    public Rectangle textDisplayBox() {
        return this.displayBox();
    }

    public boolean readOnly() {
        return this.fIsReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.fIsReadOnly = isReadOnly;
    }

    public Font getFont() {
        return this.fFont;
    }

    public void setFont(Font newFont) {
        this.willChange();
        this.fFont = newFont;
        this.markDirty();
        this.changed();
    }

    public void changed() {
        super.changed();
        this.updateLocation();
    }

    public Object getAttribute(String name) {
        Font font = this.getFont();
        if (name.equals("FontSize")) {
            return new Integer(font.getSize());
        }
        if (name.equals("FontStyle")) {
            return new Integer(font.getStyle());
        }
        if (name.equals("FontName")) {
            return font.getName();
        }
        return super.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        Font font = this.getFont();
        if (name.equals("FontSize")) {
            Integer s = (Integer)value;
            this.setFont(new Font(font.getName(), font.getStyle(), s));
        } else if (name.equals("FontStyle")) {
            Integer s = (Integer)value;
            int style = font.getStyle();
            style = s == 0 ? 0 : (style ^= s.intValue());
            this.setFont(new Font(font.getName(), style, font.getSize()));
        } else if (name.equals("FontName")) {
            String n = (String)value;
            this.setFont(new Font(n, font.getStyle(), font.getSize()));
        } else {
            super.setAttribute(name, value);
        }
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String newText) {
        if (!newText.equals(this.fText)) {
            this.willChange();
            this.fText = new String(newText);
            this.markDirty();
            this.changed();
        }
    }

    public boolean acceptsTyping() {
        return !this.fIsReadOnly;
    }

    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        g.fillRect(r.x, r.y, r.width, r.height);
    }

    public void drawFrame(Graphics g) {
        g.setFont(this.fFont);
        g.setColor((Color)this.getAttribute("TextColor"));
        FontMetrics metrics = g.getFontMetrics(this.fFont);
        Dimension d = this.textExtent();
        int orgy = this.fOriginY;
        LineIterator st = new LineIterator(this.fText);
        while (st.hasMoreLines()) {
            String t = st.nextLine();
            int xpos = this.fOriginX;
            String sAlign = (String)this.getAttribute("TextAlign");
            if (sAlign.equals("Right")) {
                xpos += d.width - metrics.stringWidth(t);
            } else if (sAlign.equals("Centre")) {
                xpos += (d.width - metrics.stringWidth(t)) / 2;
            }
            g.drawString(t, xpos, orgy + metrics.getAscent());
            orgy += metrics.getHeight();
        }
    }

    private Dimension textExtent() {
        if (!this.fSizeIsDirty) {
            return new Dimension(this.fWidth, this.fHeight);
        }
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fFont);
        this.fWidth = 0;
        this.fHeight = 0;
        LineIterator st = new LineIterator(this.fText);
        while (st.hasMoreLines()) {
            String t = st.nextLine();
            this.fHeight += metrics.getHeight();
            int w = metrics.stringWidth(t);
            if (w <= this.fWidth) continue;
            this.fWidth = w;
        }
        this.fSizeIsDirty = false;
        return new Dimension(this.fWidth, this.fHeight);
    }

    private void markDirty() {
        this.fSizeIsDirty = true;
    }

    private Dimension getRowsAndColumns(String text) {
        int rows = 0;
        int cols = 0;
        LineIterator st = new LineIterator(text);
        while (st.hasMoreLines()) {
            String t = st.nextLine();
            if (t.length() > cols) {
                cols = t.length();
            }
            ++rows;
        }
        return new Dimension(cols, rows);
    }

    public int overlayColumns() {
        Dimension d = this.getRowsAndColumns(this.getText());
        return d.width < 20 ? 20 : d.width;
    }

    public int overlayRows() {
        Dimension d = this.getRowsAndColumns(this.getText());
        return d.height < 5 ? 5 : d.height;
    }

    public Vector handles() {
        Vector<LocatorHandle> handles = new Vector<LocatorHandle>();
        handles.addElement(new NullHandle(this, RelativeLocator.northWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.northEast()));
        handles.addElement(new NullHandle(this, RelativeLocator.southEast()));
        handles.addElement(new FontSizeHandle(this, RelativeLocator.southWest()));
        return handles;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fOriginX);
        dw.writeInt(this.fOriginY);
        dw.writeString(this.fText);
        dw.writeString(this.fFont.getName());
        dw.writeInt(this.fFont.getStyle());
        dw.writeInt(this.fFont.getSize());
        dw.writeBoolean(this.fIsReadOnly);
        dw.writeStorable(this.fObservedFigure);
        dw.writeStorable(this.fLocator);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.markDirty();
        this.fOriginX = dr.readInt();
        this.fOriginY = dr.readInt();
        this.fText = dr.readString();
        this.fFont = new Font(dr.readString(), dr.readInt(), dr.readInt());
        this.fIsReadOnly = dr.readBoolean();
        this.fObservedFigure = (Figure)dr.readStorable();
        if (this.fObservedFigure != null) {
            this.setAttribute("observed.figure", this.fObservedFigure);
            this.fObservedFigure.addFigureChangeListener(this);
        }
        this.fLocator = (OffsetLocator)dr.readStorable();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.fObservedFigure != null) {
            this.fObservedFigure.addFigureChangeListener(this);
        }
        this.markDirty();
    }

    public void connect(Figure figure) {
        if (this.fObservedFigure != null) {
            this.fObservedFigure.removeFigureChangeListener(this);
        }
        this.fObservedFigure = figure;
        this.fLocator = new OffsetLocator(figure.connectedTextLocator(this));
        this.fObservedFigure.addFigureChangeListener(this);
        this.setAttribute("observed.figure", this.fObservedFigure);
        this.updateLocation();
    }

    public void figureChanged(FigureChangeEvent e) {
        this.updateLocation();
    }

    public void figureRemoved(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    public void figureRequestRemove(FigureChangeEvent e) {
    }

    public void figureInvalidated(FigureChangeEvent e) {
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    protected void updateLocation() {
        if (this.fLocator != null) {
            Point p = this.fLocator.locate(this.fObservedFigure);
            p.x -= this.size().width / 2 + this.fOriginX;
            p.y -= this.size().height / 2 + this.fOriginY;
            if (p.x != 0 || p.y != 0) {
                this.willChange();
                this.basicMoveBy(p.x, p.y);
                this.changed();
            }
        }
    }

    public void release() {
        super.release();
        if (this.fObservedFigure != null) {
            this.fObservedFigure.removeFigureChangeListener(this);
        }
    }

    public void disconnect() {
        this.fObservedFigure.removeFigureChangeListener(this);
        this.fObservedFigure = null;
        this.fLocator = null;
        this.setAttribute("observed.figure", null);
    }

    public static Font createCurrentFont() {
        return new Font(fgCurrentFontName, fgCurrentFontStyle, fgCurrentFontSize);
    }

    public static void setCurrentFontName(String name) {
        fgCurrentFontName = name;
    }

    public static void setCurrentFontSize(int size) {
        fgCurrentFontSize = size;
    }

    public static void setCurrentFontStyle(int style) {
        fgCurrentFontStyle = style;
    }

    private class LineIterator {
        int place;
        String s;

        public LineIterator(String t) {
            this.s = t;
            this.place = 0;
        }

        public boolean hasMoreLines() {
            return this.place < this.s.length();
        }

        public String nextLine() {
            int end = this.s.indexOf("\n", this.place);
            if (end < 0) {
                end = this.s.length();
            }
            String r = this.s.substring(this.place, end);
            this.place = end + 1;
            return r;
        }
    }
}

