/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.ChopEllipseConnector;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Vector;

public class EllipseFigure
extends AttributeFigure {
    private Rectangle fDisplayBox;
    private static final long serialVersionUID = -6856203289355118951L;
    private int ellipseFigureSerializedDataVersion = 1;

    public EllipseFigure() {
        this(new Point(0, 0), new Point(0, 0));
    }

    public EllipseFigure(Point origin, Point corner) {
        this.basicDisplayBox(origin, corner);
    }

    public Vector handles() {
        Vector handles = new Vector();
        BoxHandleKit.addHandles(this, handles);
        return handles;
    }

    public void basicDisplayBox(Point origin, Point corner) {
        this.fDisplayBox = new Rectangle(origin);
        this.fDisplayBox.add(corner);
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    protected void basicMoveBy(int x, int y) {
        this.fDisplayBox.translate(x, y);
    }

    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        g.fillOval(r.x, r.y, r.width, r.height);
    }

    public void drawFrame(Graphics g) {
        Rectangle r = this.displayBox();
        g.drawOval(r.x, r.y, r.width - 1, r.height - 1);
    }

    public Insets connectionInsets() {
        Rectangle r = this.fDisplayBox;
        int cx = r.width / 2;
        int cy = r.height / 2;
        return new Insets(cy, cx, cy, cx);
    }

    public Connector connectorAt(int x, int y) {
        return new ChopEllipseConnector(this);
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fDisplayBox.x);
        dw.writeInt(this.fDisplayBox.y);
        dw.writeInt(this.fDisplayBox.width);
        dw.writeInt(this.fDisplayBox.height);
    }

    public String getMap() {
        String sense = (String)this.getAttribute("Sensitive");
        if (sense != null && sense.length() > 0) {
            try {
                sense = URLDecoder.decode(sense);
            }
            catch (Exception e) {
                // empty catch block
            }
            Rectangle box = this.displayBox();
            double w = (double)box.width / 2.0;
            double h = (double)box.height / 2.0;
            double ang = box.height > box.width ? 1.5707963267948966 : 0.0;
            Point c = this.center();
            String coords = "";
            for (int i = 0; i < 6; ++i) {
                if (i > 0) {
                    coords = coords + ",";
                }
                int x = (int)((double)c.x + Math.cos(ang) * w);
                int y = (int)((double)c.y + Math.sin(ang) * h);
                coords = coords + x + "," + y;
                ang += 1.0471975511965976;
            }
            return "<area shape=\"poly\" coords=\"" + coords + "\" href=\"" + sense + "\" alt=\"" + sense + "\" />";
        }
        return "";
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDisplayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
    }
}

