/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

class PolygonScaleHandle
extends AbstractHandle {
    private Point fOrigin = null;
    private Point fCurrent = null;
    private Polygon fOrigPoly = null;

    public PolygonScaleHandle(PolygonFigure owner) {
        super(owner);
    }

    public void invokeStart(int x, int y, Drawing drawing) {
        this.fOrigPoly = ((PolygonFigure)this.owner()).getPolygon();
        this.fOrigin = this.getOrigin();
        this.fCurrent = new Point(this.fOrigin.x, this.fOrigin.y);
    }

    public void invokeStep(int dx, int dy, Drawing drawing) {
        this.fCurrent = new Point(this.fOrigin.x + dx, this.fOrigin.y + dy);
        ((PolygonFigure)this.owner()).scaleRotate(this.fOrigin, this.fOrigPoly, this.fCurrent);
    }

    public void invokeEnd(int dx, int dy, Drawing drawing) {
        this.fOrigPoly = null;
        this.fOrigin = null;
        this.fCurrent = null;
    }

    public Point locate() {
        if (this.fCurrent != null) {
            return this.fCurrent;
        }
        return this.getOrigin();
    }

    Point getOrigin() {
        Point outer = ((PolygonFigure)this.owner()).outermostPoint();
        Point ctr = ((PolygonFigure)this.owner()).center();
        double len = Geom.length(outer.x, outer.y, ctr.x, ctr.y);
        if (len == 0.0) {
            return new Point(outer.x - 4, outer.y + 4);
        }
        double u = 8.0 / len;
        if (u > 1.0) {
            return new Point((outer.x * 3 + ctr.x) / 4, (outer.y * 3 + ctr.y) / 4);
        }
        return new Point((int)((double)outer.x * (1.0 - u) + (double)ctr.x * u), (int)((double)outer.y * (1.0 - u) + (double)ctr.y * u));
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.yellow);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}

