/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.applet;

import CH.ifa.draw.applet.SleeperThread;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.DuplicateCommand;
import CH.ifa.draw.standard.SelectionTool;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.CommandButton;
import CH.ifa.draw.util.CommandChoice;
import CH.ifa.draw.util.Filler;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.PaletteButton;
import CH.ifa.draw.util.PaletteLayout;
import CH.ifa.draw.util.PaletteListener;
import CH.ifa.draw.util.StorableInput;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.StringTokenizer;

public class DrawApplet
extends Applet
implements DrawingEditor,
PaletteListener {
    private transient Drawing fDrawing;
    private transient Tool fTool;
    private transient StandardDrawingView fView;
    private transient ToolButton fDefaultToolButton;
    private transient ToolButton fSelectedToolButton;
    private transient boolean fSimpleUpdate;
    private transient Button fUpdateButton;
    private transient Choice fFrameColor;
    private transient Choice fFillColor;
    private transient Choice fArrowChoice;
    private transient Choice fFontChoice;
    private transient Thread fSleeper;
    private Iconkit fIconkit;
    static String fgUntitled = "untitled";
    private static final String fgDrawPath = "/CH/ifa/draw/";
    public static final String IMAGES = "/CH/ifa/draw/images/";

    public void init() {
        this.fIconkit = new Iconkit(this);
        this.setLayout(new BorderLayout());
        this.fView = this.createDrawingView();
        Panel attributes = this.createAttributesPanel();
        this.createAttributeChoices(attributes);
        this.add("North", attributes);
        Panel toolPanel = this.createToolPalette();
        this.createTools(toolPanel);
        this.add("West", toolPanel);
        this.add("Center", this.fView);
        Panel buttonPalette = this.createButtonPanel();
        this.createButtons(buttonPalette);
        this.add("South", buttonPalette);
        this.initDrawing();
        this.setBufferedDisplayUpdate();
        this.setupAttributes();
    }

    protected Panel createAttributesPanel() {
        Panel panel = new Panel();
        panel.setLayout(new PaletteLayout(2, new Point(2, 2), false));
        return panel;
    }

    protected void createAttributeChoices(Panel panel) {
        panel.add(new Label("Fill"));
        this.fFillColor = this.createColorChoice("FillColor");
        panel.add(this.fFillColor);
        panel.add(new Label("Pen"));
        this.fFrameColor = this.createColorChoice("FrameColor");
        panel.add(this.fFrameColor);
        panel.add(new Label("Arrow"));
        CommandChoice choice = new CommandChoice();
        this.fArrowChoice = choice;
        choice.addItem(new ChangeAttributeCommand("none", "ArrowMode", new Integer(0), this.fView));
        choice.addItem(new ChangeAttributeCommand("at Start", "ArrowMode", new Integer(1), this.fView));
        choice.addItem(new ChangeAttributeCommand("at End", "ArrowMode", new Integer(2), this.fView));
        choice.addItem(new ChangeAttributeCommand("at Both", "ArrowMode", new Integer(3), this.fView));
        panel.add(this.fArrowChoice);
        panel.add(new Label("Font"));
        this.fFontChoice = this.createFontChoice();
        panel.add(this.fFontChoice);
    }

    protected Choice createColorChoice(String attribute) {
        CommandChoice choice = new CommandChoice();
        ColorMap map = ColorMap.getColorMap();
        for (int i = 0; i < map.size(); ++i) {
            choice.addItem(new ChangeAttributeCommand(map.name(i), attribute, map.color(i), this.fView));
        }
        return choice;
    }

    protected Choice createFontChoice() {
        CommandChoice choice = new CommandChoice();
        String[] fonts = Toolkit.getDefaultToolkit().getFontList();
        for (int i = 0; i < fonts.length; ++i) {
            choice.addItem(new ChangeAttributeCommand(fonts[i], "FontName", fonts[i], this.fView));
        }
        return choice;
    }

    protected Panel createButtonPanel() {
        Panel panel = new Panel();
        panel.setLayout(new PaletteLayout(2, new Point(2, 2), false));
        return panel;
    }

    protected void createButtons(Panel panel) {
        panel.add(new Filler(24, 20));
        Choice drawingChoice = new Choice();
        drawingChoice.addItem(fgUntitled);
        String param = this.getParameter("DRAWINGS");
        if (param == null) {
            param = "";
        }
        StringTokenizer st = new StringTokenizer(param);
        while (st.hasMoreTokens()) {
            drawingChoice.addItem(st.nextToken());
        }
        if (drawingChoice.getItemCount() > 1) {
            panel.add(drawingChoice);
        } else {
            panel.add(new Label(fgUntitled));
        }
        drawingChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DrawApplet.this.loadDrawing((String)e.getItem());
                }
            }
        });
        panel.add(new Filler(6, 20));
        Button button = new CommandButton(new DeleteCommand("Delete", this.fView));
        panel.add(button);
        button = new CommandButton(new DuplicateCommand("Duplicate", this.fView));
        panel.add(button);
        button = new CommandButton(new GroupCommand("Group", this.fView));
        panel.add(button);
        button = new CommandButton(new UngroupCommand("Ungroup", this.fView));
        panel.add(button);
        button = new Button("Help");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawApplet.this.showHelp();
            }
        });
        panel.add(button);
        this.fUpdateButton = new Button("Simple Update");
        this.fUpdateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (DrawApplet.this.fSimpleUpdate) {
                    DrawApplet.this.setBufferedDisplayUpdate();
                } else {
                    DrawApplet.this.setSimpleDisplayUpdate();
                }
            }
        });
    }

    protected Panel createToolPalette() {
        Panel palette = new Panel();
        palette.setLayout(new PaletteLayout(2, new Point(2, 2)));
        return palette;
    }

    protected void createTools(Panel palette) {
        Tool tool = this.createSelectionTool();
        this.fDefaultToolButton = this.createToolButton("/CH/ifa/draw/images/SEL", "Selection Tool", tool);
        palette.add(this.fDefaultToolButton);
    }

    protected Tool createSelectionTool() {
        return new SelectionTool(this.view());
    }

    protected ToolButton createToolButton(String iconName, String toolName, Tool tool) {
        return new ToolButton(this, iconName, toolName, tool);
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    protected StandardDrawingView createDrawingView() {
        return new StandardDrawingView(this, 410, 370);
    }

    public void paletteUserSelected(PaletteButton button) {
        ToolButton toolButton = (ToolButton)button;
        this.setTool(toolButton.tool(), toolButton.name());
        this.setSelected(toolButton);
    }

    public void paletteUserOver(PaletteButton button, boolean inside) {
        if (inside) {
            this.showStatus(((ToolButton)button).name());
        } else {
            this.showStatus(this.fSelectedToolButton.name());
        }
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public Tool tool() {
        return this.fTool;
    }

    public DrawingView view() {
        return this.fView;
    }

    public void toolDone() {
        this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
        this.setSelected(this.fDefaultToolButton);
    }

    public void selectionChanged(DrawingView view) {
        this.setupAttributes();
    }

    private void initDrawing() {
        this.fDrawing = this.createDrawing();
        this.fView.setDrawing(this.fDrawing);
        this.toolDone();
    }

    private void setTool(Tool t, String name) {
        if (this.fTool != null) {
            this.fTool.deactivate();
        }
        this.fTool = t;
        if (this.fTool != null) {
            this.showStatus(name);
            this.fTool.activate();
        }
    }

    private void setSelected(ToolButton button) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.reset();
        }
        this.fSelectedToolButton = button;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.select();
        }
    }

    protected void loadDrawing(String param) {
        if (param == fgUntitled) {
            this.fDrawing.release();
            this.initDrawing();
            return;
        }
        String filename = this.getParameter(param);
        if (filename != null) {
            this.readDrawing(filename);
        }
    }

    private void readDrawing(String filename) {
        this.toolDone();
        String type = this.guessType(filename);
        if (type.equals("storable")) {
            this.readFromStorableInput(filename);
        } else if (type.equals("serialized")) {
            this.readFromObjectInput(filename);
        } else {
            this.showStatus("Unknown file type");
        }
    }

    private void readFromStorableInput(String filename) {
        try {
            URL url = new URL(this.getCodeBase(), filename);
            InputStream stream = url.openStream();
            StorableInput input = new StorableInput(stream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)input.readStorable();
            this.fView.setDrawing(this.fDrawing);
        }
        catch (IOException e) {
            this.initDrawing();
            this.showStatus("Error:" + e);
        }
    }

    private void readFromObjectInput(String filename) {
        try {
            URL url = new URL(this.getCodeBase(), filename);
            InputStream stream = url.openStream();
            ObjectInputStream input = new ObjectInputStream(stream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)input.readObject();
            this.fView.setDrawing(this.fDrawing);
        }
        catch (IOException e) {
            this.initDrawing();
            this.showStatus("Error: " + e);
        }
        catch (ClassNotFoundException e) {
            this.initDrawing();
            this.showStatus("Class not found: " + e);
        }
    }

    private String guessType(String file) {
        if (file.endsWith(".draw")) {
            return "storable";
        }
        if (file.endsWith(".ser")) {
            return "serialized";
        }
        return "unknown";
    }

    private void setupAttributes() {
        Color frameColor = (Color)AttributeFigure.getDefaultAttribute("FrameColor");
        Color fillColor = (Color)AttributeFigure.getDefaultAttribute("FillColor");
        Color textColor = (Color)AttributeFigure.getDefaultAttribute("TextColor");
        Integer arrowMode = (Integer)AttributeFigure.getDefaultAttribute("ArrowMode");
        String fontName = (String)AttributeFigure.getDefaultAttribute("FontName");
        FigureEnumeration k = this.fView.selectionElements();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            frameColor = (Color)f.getAttribute("FrameColor");
            fillColor = (Color)f.getAttribute("FillColor");
            textColor = (Color)f.getAttribute("TextColor");
            arrowMode = (Integer)f.getAttribute("ArrowMode");
            fontName = (String)f.getAttribute("FontName");
        }
        this.fFrameColor.select(ColorMap.getColorMap().colorIndex(frameColor));
        this.fFillColor.select(ColorMap.getColorMap().colorIndex(fillColor));
        if (arrowMode != null) {
            this.fArrowChoice.select(arrowMode);
        }
        if (fontName != null) {
            this.fFontChoice.select(fontName);
        }
    }

    protected void setSimpleDisplayUpdate() {
        this.fView.setDisplayUpdate(new SimpleUpdateStrategy());
        this.fUpdateButton.setLabel("Simple Update");
        this.fSimpleUpdate = true;
    }

    protected void setBufferedDisplayUpdate() {
        this.fView.setDisplayUpdate(new BufferedUpdateStrategy());
        this.fUpdateButton.setLabel("Buffered Update");
        this.fSimpleUpdate = false;
    }

    protected void showHelp() {
        try {
            String appletPath = this.getClass().getName().replace('.', '/');
            URL url = new URL(this.getCodeBase(), appletPath + "Help.html");
            this.getAppletContext().showDocument(url, "Help");
        }
        catch (IOException e) {
            this.showStatus("Help file not found");
        }
    }

    private void startSleeper() {
        if (this.fSleeper == null) {
            this.fSleeper = new SleeperThread(this);
        }
        this.fSleeper.start();
    }

    private void stopSleeper() {
        if (this.fSleeper != null) {
            this.fSleeper.stop();
        }
    }
}

