/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.appframe;

import CH.ifa.draw.appframe.Application;
import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.DuplicateCommand;
import CH.ifa.draw.standard.SelectionTool;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.CommandButton;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.Filler;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.PaletteButton;
import CH.ifa.draw.util.PaletteLayout;
import CH.ifa.draw.util.PaletteListener;
import CH.ifa.draw.util.StorableInput;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.Label;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.StringTokenizer;

public class DrawFrame
extends Frame
implements DrawingEditor,
PaletteListener {
    private transient Drawing fDrawing;
    private transient Tool fTool;
    private transient StandardDrawingView fView;
    private transient ToolButton fDefaultToolButton;
    private transient ToolButton fSelectedToolButton;
    private transient boolean fSimpleUpdate;
    private transient Button fUpdateButton;
    private transient Panel fPanel;
    private Iconkit fIconkit;
    static String fgUntitled = "untitled";
    private static final String fgDrawPath = "/CH/ifa/draw/";
    public static final String IMAGES = "/CH/ifa/draw/images/";
    private Application fApplication;

    public DrawFrame(String title, Application application) {
        super(title);
        this.fApplication = application;
        this.fIconkit = new Iconkit(this);
        this.setLayout(new BorderLayout());
        this.fView = this.createDrawingView();
        MenuBar mb = new MenuBar();
        this.populateMenuBar(mb);
        this.setMenuBar(mb);
        Panel panel = this.createSouthPanel();
        if (panel != null) {
            this.populateSouthPanel(panel);
            this.add("South", panel);
        }
        if ((panel = this.createWestPanel()) != null) {
            this.populateWestPanel(panel);
            this.add("West", panel);
        }
        if ((panel = this.createEastPanel()) != null) {
            this.populateEastPanel(panel);
            this.add("East", panel);
        }
        if ((panel = this.createNorthPanel()) != null) {
            this.populateNorthPanel(panel);
            this.add("North", panel);
        }
        ScrollPane sp = new ScrollPane();
        sp.add(this.fView);
        this.add("Center", sp);
        this.initDrawing();
        this.setBufferedDisplayUpdate();
    }

    public Application getApplication() {
        return this.fApplication;
    }

    public void showStatus(String s) {
        this.fApplication.showStatus(s);
    }

    protected void populateMenuBar(MenuBar mb) {
    }

    protected Panel createSouthPanel() {
        Panel panel = new Panel();
        panel.setLayout(new PaletteLayout(2, new Point(2, 2), false));
        return panel;
    }

    protected void populateSouthPanel(Panel panel) {
        panel.add(new Filler(24, 20));
        Choice drawingChoice = new Choice();
        drawingChoice.addItem(fgUntitled);
        String param = this.fApplication.getParameter("DRAWINGS");
        if (param == null) {
            param = "";
        }
        StringTokenizer st = new StringTokenizer(param);
        while (st.hasMoreTokens()) {
            drawingChoice.addItem(st.nextToken());
        }
        if (drawingChoice.getItemCount() > 1) {
            panel.add(drawingChoice);
        } else {
            panel.add(new Label(fgUntitled));
        }
        drawingChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DrawFrame.this.loadDrawing((String)e.getItem());
                }
            }
        });
        panel.add(new Filler(6, 20));
        Button button = new CommandButton(new DeleteCommand("Delete", this.fView));
        panel.add(button);
        button = new CommandButton(new DuplicateCommand("Duplicate", this.fView));
        panel.add(button);
        button = new CommandButton(new GroupCommand("Group", this.fView));
        panel.add(button);
        button = new CommandButton(new UngroupCommand("Ungroup", this.fView));
        panel.add(button);
        button = new Button("Help");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawFrame.this.showHelp();
            }
        });
        panel.add(button);
        this.fUpdateButton = new Button("Simple Update");
        this.fUpdateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (DrawFrame.this.fSimpleUpdate) {
                    DrawFrame.this.setBufferedDisplayUpdate();
                } else {
                    DrawFrame.this.setSimpleDisplayUpdate();
                }
            }
        });
        panel.add(this.fUpdateButton);
    }

    protected CommandMenu createColorMenu(String attribute) {
        CommandMenu menu = new CommandMenu("Colour");
        ColorMap map = ColorMap.getColorMap();
        for (int i = 0; i < map.size(); ++i) {
            menu.add(new ChangeAttributeCommand(map.name(i), attribute, map.color(i), this.fView));
        }
        return menu;
    }

    protected CommandMenu createFontMenu() {
        CommandMenu menu = new CommandMenu("Font");
        String[] fonts = Toolkit.getDefaultToolkit().getFontList();
        for (int i = 0; i < fonts.length; ++i) {
            menu.add(new ChangeAttributeCommand(fonts[i], "FontName", fonts[i], this.fView));
        }
        return menu;
    }

    protected Panel createEastPanel() {
        return null;
    }

    protected void populateEastPanel(Panel panel) {
    }

    protected Panel createNorthPanel() {
        return null;
    }

    protected void populateNorthPanel(Panel panel) {
    }

    protected Panel createWestPanel() {
        Panel palette = new Panel();
        palette.setLayout(new PaletteLayout(2, new Point(2, 2)));
        return palette;
    }

    protected void populateWestPanel(Panel palette) {
        Tool tool = this.createSelectionTool();
        this.fDefaultToolButton = this.createToolButton("/CH/ifa/draw/images/SEL", "Selection Tool", tool);
        palette.add(this.fDefaultToolButton);
    }

    protected Tool createSelectionTool() {
        return new SelectionTool(this.fView);
    }

    protected ToolButton createToolButton(String iconName, String toolName, Tool tool) {
        return new ToolButton(this, iconName, toolName, tool);
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    protected StandardDrawingView createDrawingView() {
        return new StandardDrawingView(this, 410, 370);
    }

    public void paletteUserSelected(PaletteButton button) {
        ToolButton toolButton = (ToolButton)button;
        this.setTool(toolButton.tool(), toolButton.name());
        this.setSelected(toolButton);
    }

    public void paletteUserOver(PaletteButton button, boolean inside) {
        if (inside) {
            this.showStatus(((ToolButton)button).name());
        } else {
            this.showStatus(this.fSelectedToolButton.name());
        }
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public Tool tool() {
        return this.fTool;
    }

    public DrawingView view() {
        return this.fView;
    }

    public void toolDone() {
        this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
        this.setSelected(this.fDefaultToolButton);
    }

    public void selectionChanged(DrawingView view) {
    }

    private void initDrawing() {
        this.fDrawing = this.createDrawing();
        this.fView.setDrawing(this.fDrawing);
        this.toolDone();
    }

    private void setTool(Tool t, String name) {
        if (this.fTool != null) {
            this.fTool.deactivate();
        }
        this.fTool = t;
        if (this.fTool != null) {
            this.showStatus(name);
            this.fTool.activate();
        }
    }

    private void setSelected(ToolButton button) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.reset();
        }
        this.fSelectedToolButton = button;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.select();
        }
    }

    protected void loadDrawing(String param) {
        if (param == fgUntitled) {
            this.fDrawing.release();
            this.initDrawing();
            return;
        }
        String filename = this.fApplication.getParameter(param);
        if (filename != null) {
            this.readDrawing(filename);
        }
    }

    private void readDrawing(String filename) {
        this.toolDone();
        String type = this.guessType(filename);
        if (type.equals("storable")) {
            this.readFromStorableInput(filename);
        } else if (type.equals("serialized")) {
            this.readFromObjectInput(filename);
        } else {
            this.showStatus("Unknown file type");
        }
    }

    private void readFromStorableInput(String filename) {
        try {
            InputStream stream = this.fApplication.getStream(filename);
            StorableInput input = new StorableInput(stream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)input.readStorable();
            this.fView.setDrawing(this.fDrawing);
        }
        catch (IOException e) {
            this.initDrawing();
            this.showStatus("Error reading " + filename + ": " + e);
            e.printStackTrace();
        }
    }

    private void readFromObjectInput(String filename) {
        try {
            InputStream stream = this.fApplication.getStream(filename);
            ObjectInputStream input = new ObjectInputStream(stream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)input.readObject();
            this.fView.setDrawing(this.fDrawing);
        }
        catch (IOException e) {
            this.initDrawing();
            this.showStatus("Error reading (OI) " + filename + ": " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            this.initDrawing();
            this.showStatus("Class not found: " + e);
        }
    }

    private String guessType(String file) {
        if (file.endsWith(".draw")) {
            return "storable";
        }
        if (file.endsWith(".ser")) {
            return "serialized";
        }
        return "unknown";
    }

    protected void setSimpleDisplayUpdate() {
        this.fView.setDisplayUpdate(new SimpleUpdateStrategy());
        this.fUpdateButton.setLabel("Simple Update");
        this.fSimpleUpdate = true;
    }

    protected void setBufferedDisplayUpdate() {
        this.fView.setDisplayUpdate(new BufferedUpdateStrategy());
        this.fUpdateButton.setLabel("Buffered Update");
        this.fSimpleUpdate = false;
    }

    protected void showHelp() {
        String helpPath = this.getClass().getName().replace('.', '/');
        this.fApplication.popupFrame(helpPath + "Help.html", "Help");
    }
}

