# Module of TWiki Enterprise Collaboration Platform, http://TWiki.org/
#
# Copyright (C) 20005-2011 TWiki Contributors. All Rights Reserved.
# TWiki Contributors are listed in the AUTHORS file in the root of
# this distribution. NOTE: Please extend that file, not this notice.
#
# Additional copyrights apply to some or all of the code in this
# file as follows:
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. For
# more details read LICENSE in the root of this distribution.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# As per the GPL, removal of this notice is prohibited.
#
# Author: Crawford Currie http://c-dot.co.uk

=pod

---+ package TWiki::Infix::Error

Class of errors used with TWiki::Infix::Parser

=cut

package TWiki::Infix::Error;
use base 'Error';

use strict;

sub new {
    my( $class, $message, $expr, $at ) = @_;
    if (defined $expr && length($expr)) {
        $message .= " in '$expr'";
    }
    if (defined $at && length($at)) {
        $message .= " at '$at'";
    }
    return $class->SUPER::new(
        -text => $message,
        -file => 'dummy',
        -line => 'dummy' );
}

1;
